package org.jibble.pircbot;

import java.net.*;
import java.io.*;

/**
 * This class is used to allow the bot to interact with a DCC Chat session.
 *
 * @copyright Paul James Mutton, 2001-2002.
 * @author    Paul James Mutton, http://www.jibble.org/
 * @version 0.9.11 (Build time: Sat Nov 23 19:17:09 2002)
 */
public class DccChat {
    
    
    /**
     * This constructor is used when we are accepting a DCC CHAT request
     * from somebody. It attempts to connect to the client that issued the
     * request.
     */
    public DccChat(PircBot bot, String sourceNick, String address, int port) throws IOException {
        _bot = bot;
        _sourceNick = sourceNick;
        _socket = new Socket(address, port);
        _reader = new BufferedReader(new InputStreamReader(_socket.getInputStream()));
        _writer = new BufferedWriter(new OutputStreamWriter(_socket.getOutputStream()));
    }
    
    
    /**
     * This constructor is used after we have issued a DCC CHAT request to
     * somebody. If the client accepts the chat request, then the socket we
     * obtain is passed to this constructor.
     */
    public DccChat(PircBot bot, String sourceNick, Socket socket) throws IOException {
        _bot = bot;
        _sourceNick = sourceNick;
        _socket = socket;
        _reader = new BufferedReader(new InputStreamReader(_socket.getInputStream()));
        _writer = new BufferedWriter(new OutputStreamWriter(_socket.getOutputStream()));        
    }
    
    
    /**
     * Reads the next line of text from the client at the other end of our DCC Chat
     * connection.  This method blocks until something can be returned.
     * If the connection has closed, null is returned.
     *
     * @return The next line of text from the client.  Returns null if the
     *          connection has closed.
     */
    public String readLine() throws IOException {
        String line = _reader.readLine();
        if (line != null) {
            _bot.log("+++ DCC CHAT " + _sourceNick + " " + line);
        }
        return line;
    }
    
    
    /**
     * Sends a line of text to the client at the other end of our DCC Chat
     * connection.
     * 
     * @param line The line of text to be sent.  This should not include
     *             linefeed characters.
     */
    public void sendLine(String line) throws IOException {
        // No need for synchronization here really...
        _bot.log("+++ DCC CHAT " + _sourceNick + " >>>" + line);
        _writer.write(line + "\r\n");
        _writer.flush();
    }
    
    
    /**
     * Closes the DCC Chat connection.
     */
    public void close() throws IOException {
        _bot.log("+++ DCC CHAT with " + _sourceNick + " ended by us.");
        _socket.close();
    }
    
    private PircBot _bot;
    private String _sourceNick;
    private BufferedReader _reader;
    private BufferedWriter _writer;
    private Socket _socket;
    
}