

#use POSIX;
use Socket;


# dns request handler, called by message.pl like 
# &dnshandler($innick, $inchan, $inmsg);

sub dnshandler {
$innick = $_[0];
$inchan = $_[1];
$inmsg = $_[2];
$inmsg = lc($inmsg);
$inmsg =~ s/ //g;
@zxcvb = split('dns', $inmsg, 2);
$dnhost = $zxcvb[1];
&DNS($dnhost, $inchan, $innick);
}


sub REAPER {
	$SIG{CHLD} = \&REAPER;	# loathe sysV
	$waitedpid = wait;
}

$SIG{CHLD} = \&REAPER;
$DNS_CACHE_EXPIRE_TIME = 7*24*60*60;

sub DNS {
    my $in = $_[0];
    $outchan = $_[1];
    $outnick = $_[2];
    my($match, $x, $y, $result);

    if (($DNS_CACHE{$in}) && ((time()-$DNS_TIME_CACHE{$in}) < $DNS_CACHE_EXPIRE_TIME)) {
	return $DNS_CACHE{$in};
    }

    if (!defined($pid = fork)) {
	return "no luck, $safeWho";
    } elsif ($pid) {
	# parent
    } else {
	# child
	if ($in =~ /(\d+\.\d+\.\d+\.\d+)/) {
#	    &status("DNS query by IP address: $in");
	    $match = $1;
	    $y = pack('C4', split(/\./, $match));
	    $x = (gethostbyaddr($y, &AF_INET));
	    if ($x !~ /^\s*$/) {
		$result = $match." is ".$x unless ($x =~ /^\s*$/);
	    } else {
		$result = $outnick.", I can't seem to find that IP in DNS, sorry!";
	    }
	} else {
#	    &status("DNS query by name: $in");
	    $x = join('.',unpack('C4',(gethostbyname($in))[4]));
	    if ($x !~ /^\s*$/) {
		$result = $in." resolved to ".$x;
	    } else {
		$result = $outnick.", I can\'t find that host in DNS, sorry!";
	    }
	}
	$DNS_TIME_CACHE{$in} = time();
	$DNS_CACHE{$in} = $result;

	&privmsg($outchan, $result);
	exit;			# bye child
    }
}

1;
