use Socket;

our $KILLED;
our $CONNECTS;

sub load_config
{
	$cfg = "$curdir/defender.conf";
	$dir = $curdir;
	open (CONFIG, $cfg) or die "Can't locate config file! ($cfg): $!";
	while (chomp($pair=<CONFIG>))
	{
	        ( $var, $val ) = split ( "=", $pair );  # Split name/value pairs
	        $val =~ s/%(..)/pack("c",hex($1))/ge;   # Replace %nn with char
	        $dataValues{"$var"} = "$val";
	}
	close(CONFIG);
	$domain = $dataValues{"domain"};
	$nspass = $dataValues{"nickserv"};
	$dir = $dataValues{"datadir"};
	$killurl = $dataValues{"url"};
	$killmail = $dataValues{"mail"};
	$server = $dataValues{"server"};
	$server_re = $dataValues{"servregexp"};
	$botnick = $dataValues{"botnick"};
	$mychan = $dataValues{"channel"};
	$quitmsg = $dataValues{"quitmsg"};
	$port = $dataValues{"port"};
	$paranoia = $dataValues{"paranoia"};
	$botname = $dataValues{"fullname"};
	$oname = $dataValues{"opername"};
	$opass = $dataValues{"operpass"};
	$password = $dataValues{"password"};
	$netname    = $dataValues{"networkname"};
	$servername = $dataValues{"servername"};
	$numeric    = $dataValues{"numeric"};
	$serverdesc = $dataValues{"serverdesc"};
	$linkmodule = $dataValues{"linktype"};
	$logger = $dataValues{"logto"};
}


sub init_modules
{
	require "Modules/Link/$linkmodule.pm";
	print ("Using $linkmodule connection module (loaded OK)...\n");

	print ("\nLoading modules...\n");

	$modules = $dataValues{"modules"};
	our @modlist = split(",",$modules);
	foreach $mod (@modlist) {
	        print ("Loading: Modules/Scan/$mod.pm... ");
	        require "Modules/Scan/$mod.pm";
	        my $func = "Modules::Scan::" . $mod . "::init";
	        eval $func;
	        print ("OK!\n");
	}

	require "Modules/Log/$logger.pm";
	print "Switching to $logger logging method from now\n";
	my $startup = ("Modules::Log::" . $logger . "::init");
	eval $startup;
	print $@ if $@;
}

sub rehash
{
	&load_config;
	&init_modules;
}

sub daemon
{
	use POSIX qw(setsid);
	chdir '/'                 or die "Can't chdir to /: $!";
	umask 0;
	open STDIN, '/dev/null'   or die "Can't read /dev/null: $!";
	open STDERR, '>/dev/null' or die "Can't write to /dev/null: $!";
	defined(my $pid = fork)   or die "Can't fork: $!";
	exit if $pid;
	setsid                    or die "Can't start a new session: $!";
	$SIG{'INT'} = 'shutdown';
	$SIG{'HUP'} = 'rehash';
}

1;
