package Modules::Scan::cgiirc;

use strict;
use warnings;

my $cgi_connects;
my $cgi_killtotal;

sub stats {
	my $per = (($Modules::Scan::cgiirc::cgi_killtotal/($Modules::Scan::cgiirc::cgi_connects+0.0001))*100);
	if (length($per)>6)
	{
		$per  = substr($per,0,6);
	}
	main::message("Total clients killed:             \002$Modules::Scan::cgiirc::cgi_killtotal\002");
	main::message("Total connecting clients scanned: \002$Modules::Scan::cgiirc::cgi_connects\002");
	main::message("Percentage CGI users:             \002$per%\002");
}

my @names;

sub scan_user
{
	my ($ident,$host,$serv,$nick,$fullname,$print_always) = @_;
	my $nicksyms = 0;
	my $nicknums = 0;
	my $total = 0;
	my $status = "";

	if (($fullname =~ /^\[[0-9a-f]{8}\]../i) || ($ident =~ /^[0-9a-f]{8}$/i))
	{
		if (($host !~ /winbot/) && ($host !~ /underhanded/))
		{
			main::message_to($nick,"\001VERSION\001");
			main::message("Possible unauthorised CGI:IRC usage by $nick!$ident\@$host, \"$fullname\"");
			my $coded = "";
			if ($fullname =~ /^\[([0-9a-f]{8})\]../i)
			{
				$coded = $1;
			}
			if ($ident =~ /^([0-9a-f]{8})$/i)
			{
				$coded = $1;
			}
		}
	}
	$Modules::Scan::cgiirc::cgi_connects++;
}

sub handle_notice
{
	my ($nick,$ident,$host,$chan,$notice) = @_;
	if ($notice =~ /\001VERSION CGI\:IRC (.+) - http\:\/\/cgiirc\.sf\.net\/\001/)
	{
                my $version = $1;
		$Modules::Scan::cgiirc::cgi_killtotal++;
                main::message("\002Killed! Unauthorised IRC VERIFIED\002 from nickname $nick (using CGI:IRC version \002$version\002)");
                main::killuser($nick,"You are using an \002unauthorised CGI:IRC gateway\002 to connect to $main::netname. This is a form of \002open proxy\002 used to evade bans and get around firewall policies, and is therefore not allowed. Please email \002$main::killmail\002 for a list of authorised CGI:IRC proxies for connecting to $main::netname.");
	}
}

sub handle_privmsg
{
        my ($nick,$ident,$host,$chan,$msg) = @_;
}


sub init {
	$Modules::Scan::cgiirc::cgi_killtotal = 0;
	$Modules::Scan::cgiirc::cgi_connects = 0;
}


1;
