# version.pm by typobox43
# Permission is granted to modify and/or distribute this file in any way, 
# providing that this notice is left intact.
package Modules::Scan::version;

use strict;
use warnings;

my $connects = 0;
# my $responded; - not utilizing until conflicts with cgiirc.pm are resolved
my $killed = 0;

my $mirc = 0;
my $winbot = 0;
my $xchat = 0;
my $bitchx = 0;
my $trillian = 0;
my $eggdrop = 0;
my $kvirc = 0;
my $ircii = 0;
my $irssi = 0;
my $hydrairc = 0;
my $darkbot = 0;
my $nulls = 0;
my $infobot = 0;
my $muh = 0;
my $pjirc = 0;
my $cgiirc = 0;

my %blacklist;

sub stats {

	my $percent = ($connects ? $killed/$connects*100 : 0);
	$percent = $percent ? sprintf("%.3f", $percent) : 0;

	main::message("Total clients killed: \002$killed\002");
	main::message("Total connecting clients scanned: \002$connects\002");
#	main::message("Clients not responding to CTCP VERSION: \002" . $connects-$responded . "\002");
	main::message("Percentage of blacklisted versions: \002$percent%\002");
	main::message(" ");
	main::message("\002Version Survey:\002");
	main::message(" ");
	my $pmirc = ($connects ? $mirc/$connects*100 : 0);
	my $pkvirc = ($connects ? $kvirc/$connects*100 : 0);
	my $peggdrop  = ($connects ? $eggdrop/$connects*100 : 0);
	my $pwinbot = ($connects ? $winbot/$connects*100 : 0);
	my $pxchat = ($connects ? $xchat/$connects*100 : 0);
	my $pbitchx = ($connects ? $bitchx/$connects*100 : 0);
	my $ptrillian = ($connects ? $trillian/$connects*100 : 0);
	my $pircii = ($connects ? $ircii/$connects*100 : 0);
	my $pirssi = ($connects ? $irssi/$connects*100 : 0);
	my $phydrairc = ($connects ? $hydrairc/$connects*100 : 0);
	my $pdarkbot = ($connects ? $darkbot/$connects*100 : 0);
	my $pnull = ($connects ? $nulls/$connects*100 : 0);
	my $pinfobot = ($connects ? $infobot/$connects*100 : 0);
	my $pmuh = ($connects ? $muh/$connects*100 : 0);
	my $ppjirc = ($connects ? $pjirc/$connects*100 : 0);
	my $pcgiirc = ($connects ? $cgiirc/$connects*100 : 0);
	my $scantotal = $mirc+$eggdrop+$winbot+$xchat+$bitchx+$trillian+$kvirc+$ircii+$irssi+$hydrairc+$darkbot+$nulls+$infobot+$muh+$cgiirc+$pjirc;
	my $unresponsive = $connects - $scantotal;
	#my $pother = ($connects ? $other/$connects*100 : 0);
	#my $unknown = $connects-($mirc+$winbot+$xchat+$bitchx+$trillian+$other);
	#if ($unknown < 0) {
	#	$unknown = 0;
	#}
	my $punresponsive = ($connects ? $unresponsive/$connects*100 : 0);
	$punresponsive = $punresponsive ? sprintf("%.3f", $punresponsive) : 0;
	$pmirc = $pmirc ? sprintf("%.3f", $pmirc) : 0;
	$pcgiirc = $pcgiirc ? sprintf("%.3f", $pcgiirc) : 0;
	$ppjirc = $ppjirc ? sprintf("%.3f", $ppjirc) : 0;
	$pircii = $pircii ? sprintf("%.3f", $pircii) : 0;
	$pkvirc = $pkvirc ? sprintf("%.3f", $pkvirc) : 0;
	$pwinbot = $pwinbot ? sprintf("%.3f", $pwinbot) : 0;
	$pxchat = $pxchat ? sprintf("%.3f", $pxchat) : 0;
	$pbitchx = $pbitchx ? sprintf("%.3f", $pbitchx) : 0;
	$ptrillian = $ptrillian ? sprintf("%.3f", $ptrillian) : 0;
	$peggdrop = $peggdrop ? sprintf("%.3f", $peggdrop) : 0;
	$pirssi = $pirssi ? sprintf("%.3f", $pirssi) : 0;
	$phydrairc = $phydrairc ? sprintf("%.3f", $hydrairc) : 0;
	$pdarkbot = $pdarkbot ? sprintf("%.3f", $pdarkbot) : 0;
	$pnull = $pnull ? sprintf("%.3f", $pnull) : 0;
	$pinfobot = $pinfobot ? sprintf("%.3f", $pinfobot) : 0;
	$pmuh = $pmuh ? sprintf("%.3f", $pmuh) : 0;
	#$punknown = $punknown ? sprintf("%.3f", $punknown) : 0;
	main::message("mIRC:         \002$mirc\002 ($pmirc%)");
	main::message("WinBot:       \002$winbot\002 ($pwinbot%)");
	main::message("X-Chat:       \002$xchat\002 ($pxchat%)");
	main::message("BitchX:       \002$bitchx\002 ($pbitchx%)");
	main::message("Trillian:     \002$trillian\002 ($ptrillian%)");
	main::message("Eggdrop:      \002$eggdrop\002 ($peggdrop%)");
	main::message("KVIrc:        \002$kvirc\002 ($pkvirc%)");
	main::message("ircII/EPIC:   \002$ircii\002 ($pircii%)");
	main::message("Irssi:        \002$irssi\002 ($pirssi%)");
	main::message("HydraIRC:     \002$hydrairc\002 ($phydrairc%)");
	main::message("Darkbot:      \002$darkbot\002 ($pdarkbot%)");
	main::message("Infobot:      \002$infobot\002 ($pinfobot%)");
	main::message("Empty reply:  \002$nulls\002 ($pnull%)");
	main::message("muh (bounce): \002$muh\002 ($pmuh%)");
	main::message("PJIRC:        \002$pjirc\002 ($ppjirc%)");
	main::message("CGI:IRC:      \002$cgiirc\002 ($pcgiirc%)");
	main::message("Others:       \002$unresponsive\002 ($punresponsive%)");
	#main::message("No reply:    \002$unknown\002 ($punknown%)");
}

sub scan_user {

	# dont version everyone on NETJOIN, users get pissy
        return if ($main::NETJOIN == 1);

	my($ident, $host, $serv, $nick, $fullname, $print_always) = @_;

	if ($host !~ /underhanded/)
	{	
		main::message_to($nick, "\001VERSION\001");
	}
	$connects++;
}

sub handle_notice {

	my($nick, $ident, $host, $chan, $notice) = @_;

	if ($notice =~ /^\001VERSION mIRC.+\001$/) {
		$mirc++;
	}
	elsif ($notice =~ /^\001VERSION eggdrop.+\001$/) {
		$eggdrop++;
	}
	elsif ($notice =~ /^\001VERSION WinBot.+\001$/) {
		$winbot++;
	}
	elsif ($notice =~ /^\001VERSION xchat.+\001$/) {
		$xchat++;
	}
	elsif ($notice =~ /^\001VERSION.+BitchX.+\001$/) {
		$bitchx++;
	}
	elsif ($notice =~ /^\001VERSION.+Trillian/) {
		$trillian++;
	}
	elsif ($notice =~ /^\001VERSION KVIrc/) {
		$kvirc++;
	}
	elsif ($notice =~ /^\001VERSION.+ircII.+/) {
		$ircii++;
	}
	elsif ($notice =~ /^\001VERSION.+irssi.+/) {
		$irssi++;
	}
	elsif ($notice =~ /^\001VERSION.+HydraIRC.+/) {
		$hydrairc++;
	}
	elsif ($notice =~ /^\001VERSION.+Darkbot.+/) {
		$darkbot++;
	}
	elsif ($notice =~ /^\001VERSION.+infobot.+/) {
		$infobot++;
	}
	elsif ($notice =~ /^\001VERSION.+http\:\/\/mind\.riot\.org\/muh/) {
		$muh++;
	}
	elsif ($notice =~ /^\001VERSION.+PJIRC.+/) {
		$pjirc++;
	}
	elsif ($notice =~ /^\001VERSION.+CGI\:IRC.+/) {
		$cgiirc++;
	}
	elsif ($notice eq "") {
		$nulls++;
	}
	
	$notice =~ /^\001VERSION (.+)\001$/;
	print "Version reply for $nick is \"$1\"\n";
	

	foreach my $version (keys %blacklist) {

		if($notice =~ /^\001VERSION ($version)\001$/) {

			main::killuser($nick, "Your client is not allowed to connect to $main::netname.  Reason: " . $blacklist{$version} . ". If you feel that there has been an error, please contact $main::killmail.");
			main::message("$nick using $1 matches version blacklist entry ($version), killed.");
			$killed++;
			return;

		}

	}

}

sub handle_privmsg { }

# The version blacklist file consists of a tab-separated list of regexps to match client versions and reasons.  Example:
#
# .*subseven.*	SubSeven Trojan
# .*mIRC 6.08.*	Insecure mIRC version
sub init {

	open(BL, "<$main::dir/deny_version.conf") or die "Missing deny_version.conf file!";
	
	while(<BL>) {

		chomp;
		my($version, $reason) = split(/\t/);
		$blacklist{$version} = $reason;

	}

	close BL;

}

# Thou shalt not forget to end thy modules with 1.
1;
