/**********************************/
/* Copyright (C) 2005-2007 IRCtoo */
/**********************************/
/* $Id: irctoo.c 192 2007-06-24 20:27:08Z Kobi_S $ */

#include <sys/utsname.h>
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "channel.h"
#include "h.h"
#include "throttle.h"
#include "irctoo.h"
#include "pcre.h"

#define PCRE_COMP_FLAGS PCRE_EXTRA|PCRE_ANCHORED|PCRE_UNGREEDY

extern int check_channelname(aClient *, unsigned char *); /* for m_aj */
extern aChannel *get_channel(aClient *, char *, int, int *); /* for m_aj */
extern Link *find_channel_link(Link *, aChannel *); /* for m_aj */
extern void add_user_to_channel(aChannel *, aClient *, int); /* for m_aj */
extern char *oflagtotext(int oflags); /* for m_ctrl */
extern AliasInfo aliastab[];
extern int user_modes[];

int services_cj = 0; /* Move join requests to services - Disabled by default */
int disable_helpop = 0; /* Disable the /helpop command */
int disable_nw = 0; /* Disable network wide warnings (only throttles atm) */
int level_chatops = 0;
int level_wallops = 0;
static char buf2[BUFSIZE];

struct ulf_server
{
    struct ulf_server *next;
    char *name;
    long uflags;
};

struct ulf_server *ulf_servers = NULL;

extern struct ulf_server *new_ulf_server(char *name, long uflags);
extern int del_ulf_server(char *name);
extern int del_ulf_servers();

struct spam_filter
{
    struct spam_filter *next;
    char *text;
    long flags;
    char *reason;
    pcre *re;
};

struct spam_filter *spam_filters = NULL;

/* m_aj - Accept channel join from services
 * parv[1] = [*@%+]nick
 * parv[2] = channel
 * parv[3] = TS
 * -Kobi_S 16/07/2005
 */
int m_aj(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    aClient *acptr;
    aChannel *chptr;
    Link *lp;
    int flags = 0;
    ts_val newts;
    int created;

    if(!IsULine(sptr))
        return 0; /* Only to be used by u:lined servers */

    if(parc < 3 || *parv[1] == 0)
        return 0;

    while(*parv[1] == '@' || *parv[1] == '+')
    {
        switch(*parv[1])
        {
            case '@':
                flags |= CHFL_CHANOP;
                break;
            case '+':
                flags |= CHFL_VOICE;
                break;
        }
        parv[1]++;
    }

    if(!(acptr = find_client(parv[1], NULL)))
        return 0; /* Can't find the target nick */

    if(*parv[2] == '0' && !atoi(parv[2]))
    {
        if(acptr->user->channel == NULL)
            return 0; /* Target nick isn't on any channels */
        while ((lp = acptr->user->channel))
        {
            chptr = lp->value.chptr;
            sendto_channel_butserv(chptr, acptr, ":%s PART %s", acptr->name, chptr->chname);
            remove_user_from_channel(acptr, chptr);
        }
    }
    else
    {
        if(!check_channelname(acptr, (unsigned char *)parv[2]))
            return 0; /* Invalid channel name */
        chptr = get_channel(acptr, parv[2], CREATE, &created);
        if(!chptr)
            return 0; /* Shouldn't happen! */
        if(parc>3)
        {
            newts = atol(parv[3]);
            if(created || newts<chptr->channelts)
                chptr->channelts = newts;
        }
        if(!IsMember(acptr, chptr))
        {
            add_user_to_channel(chptr, acptr, flags);
            sendto_channel_butserv(chptr, acptr, ":%s JOIN :%s", acptr->name, parv[2]);
            if(MyClient(acptr))
            {
                del_invite(acptr, chptr);
                if(chptr->topic[0] != '\0')
                {
                    sendto_one(acptr, rpl_str(RPL_TOPIC), me.name, acptr->name,
                               chptr->chname, chptr->topic);
                    sendto_one(acptr, rpl_str(RPL_TOPICWHOTIME), me.name, acptr->name,
                               chptr->chname, chptr->topic_nick, chptr->topic_time);
                }
                parv[0] = acptr->name;
                parv[1] = chptr->chname;
                m_names(acptr, acptr, 2, parv);
            }
            if(flags)
            {
                if(flags & CHFL_CHANOP)
                 sendto_channel_butserv(chptr, sptr, ":%s MODE %s +o %s", sptr->name,
                                        chptr->chname, acptr->name);
                if(flags & CHFL_VOICE)
                 sendto_channel_butserv(chptr, sptr, ":%s MODE %s +v %s", sptr->name,
                                        chptr->chname, acptr->name);
            }
        }
    }

    /* Pass it to all the other servers... */
    sendto_serv_butone(cptr, ":%s AJ %s %s %ld", sptr->name, acptr->name, chptr->chname, chptr->channelts);

    return 0;
}

/* m_cj - Check the join (request) with services
 * -Kobi_S 16/07/2005
 */
int m_cj(aClient *cptr, aClient *sptr, int parc, char *parv[], AliasInfo *ai)
{
    if(sptr==cptr)
        return 0; /* Don't let local users use it without permission */

    if(parc < 3 || *parv[2] == 0)
        return 0;

    if(!ai->client || ai->client->from == sptr->from)
        return 0; /* Check to avoid message loops when admins get stupid */

    if(parc<4)
        sendto_one(ai->client->from, ":%s CJ %s %s", sptr->name, parv[1], parv[2]);
    else
        sendto_one(ai->client->from, ":%s CJ %s %s :%s", sptr->name, parv[1], parv[2], parv[3]);

    return 0;
}

int send_cj(aClient *sptr, char *chname, char *key)
{
    aChannel *chptr = find_channel(chname, NULL);
    int is_invited = 0;
    Link *lp;

    if(chptr)
    {
        for(lp = sptr->user->invited; lp; lp = lp->next)
        {
            if(lp->value.chptr == chptr)
            {
                is_invited = 1;
                break;
            }
        }
    }

    if(!aliastab[AII_NS].client)
        return 1; /* Services are off-line */

    if(key)
        sendto_one(aliastab[AII_NS].client->from, ":%s CJ %d %s :%s", sptr->name,
                   is_invited, chname, key);
    else
        sendto_one(aliastab[AII_NS].client->from, ":%s CJ %d %s", sptr->name,
                   is_invited, chname);

    return 0;
}

/* m_spoof - Lets services change a user's host.
 * -Kobi_S 20/07/2005
 */
int m_spoof(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    aClient *acptr;

    if(!IsULine(sptr) || parc<3 || *parv[2]==0)
        return 0; /* Not u:lined client or not enough parameters */

    if(!(acptr = find_person(parv[1], NULL)))
        return 0; /* Target user doesn't exist */

    if(strlen(parv[2]) > HOSTLEN)
        return 0; /* The requested host is too long */

    strcpy(acptr->user->host, parv[2]); /* Set the requested (masked) host */

    /* Pass it to all the other servers */
    sendto_serv_butone(cptr, ":%s SPOOF %s %s", parv[0], parv[1], parv[2]);

    return 0;
}

/* m_ctrl - Lets services control some settings...
 * -Kobi_S 30/07/2005
 */
int m_ctrl(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    if(!IsULine(sptr) || parc<4)
        return 0;
    if(hunt_server(cptr, sptr, ":%s CTRL %s %s :%s", 1, parc, parv) != HUNTED_ISME)
        return 0;

    if(!mycmp(parv[2], "SCJ"))
    {
        services_cj = atoi(parv[3]);
        return 0;
    }
    else if(!mycmp(parv[2], "HELPOP"))
    {
        disable_helpop = atoi(parv[3]);
        return 0;
    }
    else if(!mycmp(parv[2], "NW"))
    {
        disable_nw = atoi(parv[3]);
        return 0;
    }
    else if(!mycmp(parv[2], "WALLOPS"))
    {
        level_wallops = atoi(parv[3]);
        return 0;
    }
    else if(!mycmp(parv[2], "CHATOPS"))
    {
        level_chatops = atoi(parv[3]);
        return 0;
    }
    else if(!mycmp(parv[2], "RESET"))
    {
        services_cj = 0;
        disable_helpop = 0;
        disable_nw = 0;
        level_chatops = 0;
        level_wallops = 0;
        del_ulf_servers();
        return del_levels();
    }
    else if(parv[2][0]=='+' && parv[2][1]!='\0')
    {
        parv[2]++;
        new_ulf_server(parv[2], atol(parv[3]));
        return 0;
    }
    else if(parv[2][0]=='-' && parv[2][1]!='\0')
    {
        parv[2]++;
        del_ulf_server(parv[2]);
        return 0;
    }
    else if(!mycmp(parv[2], "SAVE"))
    {
        return save_levels();
    }
    else if(!mycmp(parv[2], "LOAD"))
    {
        return load_levels();
    }
    else if(!mycmp(parv[2], "GETINFO"))
    {
        struct utsname uninfo;
        int i;
        aClass *tmp_y;
        aAllow *tmp_i;
        aOper *tmp_o;
        aConnect *tmp_c;

        uname(&uninfo);
        sendto_one(sptr, "OS I 1 %ld %s %s %s %s", time(NULL), uninfo.nodename, 
                   uninfo.sysname, uninfo.release, uninfo.machine);
        sendto_one(sptr, "OS I 2 %s", uninfo.version);
        send_rplversion(sptr);
        for(tmp_y = classes; tmp_y; tmp_y = tmp_y->next)
            sendto_one(sptr, rpl_str(RPL_STATSYLINE), me.name,
                       sptr->name, 'Y', tmp_y->name, tmp_y->pingfreq,
                       tmp_y->connfreq, tmp_y->ip24clones, tmp_y->maxlinks,
                       tmp_y->maxsendq);
        for(tmp_i = allows; tmp_i; tmp_i = tmp_i->next)
        {
            sendto_one(sptr, rpl_str(RPL_STATSILINE), me.name,
                       sptr->name, (tmp_i->legal == -1 ? "Ix" : "I"),
                       tmp_i->ipmask, tmp_i->flags, tmp_i->hostmask, tmp_i->port,
                       tmp_i->class->name);
        }
        for(tmp_o = opers; tmp_o; tmp_o = tmp_o->next)
            for(i = 0; tmp_o->hosts[i]; i++)
                sendto_one(sptr, rpl_str(RPL_STATSOLINE), me.name,
                        sptr->name, (tmp_o->legal == -1 ? "Ox" : "O"),
                        tmp_o->hosts[i], tmp_o->nick, oflagtotext(tmp_o->flags),
                        tmp_o->class->name);
        for(tmp_c = connects; tmp_c; tmp_c = tmp_c->next)
        {
            if(tmp_c->legal == -1)
                continue;
            sendto_one(sptr, "OS I 3 %s %s %d %d %s", find_aUserver(tmp_c->name)&&mycmp(parv[3], "1")?"*":tmp_c->host, tmp_c->name, 
                       tmp_c->port, tmp_c->flags, tmp_c->class->name);
        }
        for(i = 0; uservers[i]; i++)
            sendto_one(sptr, rpl_str(RPL_STATSULINE), me.name, sptr->name, "U", "*", 
                       uservers[i], 0, 0);

        return 0;
    }

    return 0;
}

/* m_redir - Redirects a user to another server using raw 010.
 * -Kobi_S 12/11/2005
 *
 * parv[1] - nick/server
 * parv[2] - host
 * parv[3] - port
 * parv[4] - reason
 */
int m_redir(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    aClient *acptr;
    int i;

    if(!IsULine(sptr) || parc<5)
        return 0;
    if(hunt_server(cptr, sptr, ":%s REDIR %s %s %s :%s", 1, parc, parv) != HUNTED_ISME)
        return 0;

    if(!mycmp(parv[1], me.name))
    {
        /* It's the server, send it to all local users */
        for (i = 0; i <= highest_fd; i++)
        {
            if(!(acptr = local[i]))
                continue;
            if(IsClient(acptr) && !IsAnOper(acptr))
                sendto_one(acptr, ":%s 010 %s %s %s :%s", me.name,
                           acptr->name, parv[2], parv[3], parv[4]);
        }
        return 0;
    }

    if(!(acptr = find_person(parv[1], NULL)))
        return 0;

    sendto_one(acptr, ":%s 010 %s %s %s :%s", me.name, acptr->name, 
               parv[2], parv[3], parv[4]);
    return 0;
}

/* do_redir - Redirects a user/server to another server using raw 010 when 
              the server is full or /die is issued.
 * -Kobi_S 12/11/2005
 */
int do_redir(aClient *acptr, char *reason)
{
    if(!acptr)
      return -1;

    sendto_one(acptr, ":%s 010 %s irc.irctoo.net 6667 :%s", me.name, 
               acptr->name, reason);

    return 0;
}

/* do_redir_all - Redirect all local users to another server using raw 010.
 * -Kobi_S 15/02/2006
 */
int do_redir_all(char *reason)
{
    aClient *acptr;
    int i;

    for (i = 0; i <= highest_fd; i++)
    {
        if(!(acptr = local[i]))
            continue;

        if(IsClient(acptr))
            sendto_one(acptr, ":%s 010 %s irc.irctoo.net 6667 :%s", me.name, 
                       acptr->name, reason);
     }

    return 0;
}

struct user_level *user_levels = NULL;

/* find_level - Finds a user level in memory
 *              Returns: On success - A pointer to the level
 *                       On failure - NULL
 */
struct user_level *find_level(unsigned int level)
{
    struct user_level *p = user_levels;

    for(; p; p = p->next)
    {
        if(p->level==level)
            return p; /* Found! */
    }

    return NULL; /* Not found */
}

/* new_level - Adds a new user level to memory
 *             Returns: A pointer to the new level
 */
struct user_level *new_level(unsigned int level, char *title, int sendq_new, int recvq_new, int sendq_plus, int recvq_plus, int maxchannels, unsigned int raw)
{
    struct user_level *p;

    p = find_level(level);
    if(p)
    {
        if(p->title)
            MyFree(p->title);
    }
    else
    {
        p = MyMalloc(sizeof(struct user_level));
        p->next = user_levels;
        user_levels = p;
    }
    if(title)
    {
        p->title = MyMalloc(strlen(title) + 1);
        strcpy(p->title, title);
    }
    else p->title = NULL;
    p->level = level;
    p->sendq_new = sendq_new;
    p->recvq_new = recvq_new;
    p->sendq_plus = sendq_plus;
    p->recvq_plus = recvq_plus;
    p->maxchannels = maxchannels;
    p->raw = raw;

    return p;
}


/* del_level - Deletes a user level from memory
 *             Returns: 1 = Success
 *                      0 = Failure
 */
int del_level(unsigned int level)
{
    aClient *acptr;
    struct user_level *p, *pprev, *pn;

    for(p = user_levels, pprev = NULL; p; pprev = p, p = pn)
    {
        pn = p->next;
        if(p->level==level)
        {
            if(pprev)
                pprev->next = p->next;
            else
                user_levels = p->next;
            if(p->title)
                MyFree(p->title);
            for(acptr = client; acptr; acptr = acptr->next)
            {
                if(IsClient(acptr) && acptr->user->level==p)
                    acptr->user->level = NULL;
            }
            MyFree(p);
            return 1; /* Success */
        }
    }

    return 0; /* Failure */
}

/* del_levels - Deletes all user levels from memory */
int del_levels()
{
    aClient *acptr;
    struct user_level *p, *pn;

    for(acptr = client; acptr; acptr = acptr->next)
    {
        if(IsClient(acptr) && acptr->user->level)
            acptr->user->level = NULL;
    }

    for(p = user_levels; p; p = pn)
    {
        pn = p->next;
        if(p->title)
            MyFree(p->title);
        MyFree(p);
    }
    user_levels = NULL;

    return 1;
}

/* load_levels - Load the user levels settings
 *               Returns: 1 = Success
 *                        0 = Failure
 */
int load_levels()
{
    FILE *fle;
    char line[1024];
    char *para[MAXPARA + 1];
    int parc;

    if(!(fle = fopen("irctoo.conf", "r")))
        return 0; /* Can't open file! */

    while(fgets(line, sizeof(line), fle))
    {
        char *tmp = strchr(line, '\n');
        if(!tmp)
            break;
        *tmp = '\0';
        tmp = line;
        parc = 0;
        while(*tmp)
        {
            while(*tmp==' ')
             *tmp++ = '\0';

            if(*tmp==':')
            {
                para[parc++] = tmp + 1;
                break;
            }
            para[parc++] = tmp;
            while(*tmp && *tmp!=' ')
                tmp++;
        }
        para[parc + 1] = NULL;
        if(parc>8 && !mycmp(para[0],"UL"))
            new_level(atoi(para[1]), para[parc-1], atoi(para[2]), atoi(para[3]), 
                      atoi(para[4]), atoi(para[5]), atoi(para[6]), atoi(para[7]));
        else if(parc>2 && !mycmp(para[0],"S"))
            new_ulf_server(para[1], atol(para[2]));
        else if(parc>1 && !mycmp(para[0],"SCJ"))
            services_cj = atoi(para[1]);
        else if(parc>1 && !mycmp(para[0],"DHO"))
            disable_helpop = atoi(para[1]);
        else if(parc>1 && !mycmp(para[0],"DNW"))
            disable_nw = atoi(para[1]);
        else if(parc>1 && !mycmp(para[0],"WO"))
            level_wallops = atoi(para[1]);
        else if(parc>1 && !mycmp(para[0],"CO"))
            level_chatops = atoi(para[1]);
        else if(parc>3 && !mycmp(para[0],"SF"))
            new_sf(para[1], atol(para[2]), para[3]);
    }
    fclose(fle);

    return 1;
}

/* save_levels - Save the user levels settings
 *               Returns: 1 = Success
 *                        0 = Failure
 */
int save_levels()
{
    FILE *fle;
    struct user_level *p = user_levels;
    struct ulf_server *u = ulf_servers;
    struct spam_filter *sf = spam_filters;

    fle = fopen("irctoo.conf","w");
    if(!fle)
        return 0;

    for(; p; p = p->next)
    {
        fprintf(fle, "UL %u %d %d %d %d %d %u :%s\n", p->level, p->sendq_new, p->recvq_new, p->sendq_plus, p->recvq_plus, p->maxchannels, p->raw, p->title);
    }
    for(; u; u = u->next)
    {
        fprintf(fle, "S %s %ld\n", u->name, u->uflags);
    }
    for(; sf; sf = sf->next)
    {
        fprintf(fle, "SF %s %ld :%s\n", sf->text, sf->flags, sf->reason);
    }
    fprintf(fle, "SCJ %d\n", services_cj);
    fprintf(fle, "DHO %d\n", disable_helpop);
    fprintf(fle, "DNW %d\n", disable_nw);
    fprintf(fle, "WO %d\n", level_wallops);
    fprintf(fle, "CO %d\n", level_chatops);
    fclose(fle);

    return 1;
}

/* irctoo_sendserver - Send IRCtoo [user level] lists on server connections
 * -Kobi_S 26/11/2005
 */
void irctoo_sendserver(aClient *acptr)
{
    struct user_level *p;
    struct spam_filter *sf;

    for(p = user_levels; p; p = p->next)
    {
        sendto_one(acptr, "UL + %u %s%d %s%d %d %u :%s",
                   p->level,
                   p->sendq_plus>0?"+":"",
                   p->sendq_plus?p->sendq_plus:p->sendq_new,
                   p->recvq_plus>0?"+":"",
                   p->recvq_plus?p->recvq_plus:p->recvq_new,
                   p->maxchannels, p->raw, p->title);
    }

    for(sf = spam_filters; sf; sf = sf->next)
    {
        sendto_one(acptr, "SF %s %ld :%s", sf->text, sf->flags, sf->reason);
    }
}

/* m_ul - Set User Levels
 * parv[1] - Command (+,-,RESET)
 * parv[2] - level
 * parv[3] - sendq_new or sendq_plus
 * parv[4] - recvq_new or recvq_plus
 * parv[5] - maxchannels
 * parv[6] - raw
 * parv[7] - Whois title (should actually be parc-1 and not 7)
 */
int m_ul(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    char pbuf[512];
    AliasInfo *ai = &aliastab[AII_NS];
    int sendq_new = 0;
    int recvq_new = 0;
    int sendq_plus = 0;
    int recvq_plus = 0;

    if(!IsServer(sptr) || parc<2)
        return 0;

    if(parc > 6 && !mycmp(parv[1], "+"))
    {
        if(!IsULine(sptr) && ai->client && ai->client->from!=cptr->from)
        {
            /*
             * We don't accept commands from a non-services direction.
             * Also, we remove non-existed levels if they come from this location.
             * Note: we don't need to worry about existed levels on the other side 
             * because they will be overrided anyway.
             */
            if(!find_level(atoi(parv[2])))
                sendto_one(cptr, ":%s UL - %s", me.name, parv[2]);
            return 0;
        }
        if(parv[3][0]=='+' || parv[3][0]=='-')
            sendq_plus = atoi(parv[3]);
        else
            sendq_new = atoi(parv[3]);
        if(parv[4][0]=='+' || parv[4][0]=='-')
            recvq_plus = atoi(parv[4]);
        else
            recvq_new = atoi(parv[4]);
        new_level(atoi(parv[2]), parv[parc-1], sendq_new, recvq_new, sendq_plus, recvq_plus, 
                  atoi(parv[5]), atoi(parv[6]));
        make_parv_copy(pbuf, parc, parv);
        sendto_serv_butone(cptr, ":%s UL %s", parv[0], pbuf);
        return 1;
    }

    if(ai->client && ai->client->from!=cptr->from)
        return 0; /* Ignore it if services are on-line from another direction */

    make_parv_copy(pbuf, parc, parv);
    sendto_serv_butone(cptr, ":%s UL %s", parv[0], pbuf);

    if(parc > 2 && !mycmp(parv[1], "-"))
    {
        return del_level(atoi(parv[2]));
    }
    else if(!mycmp(parv[1], "RESET"))
    {
        return del_levels();
    }
    else if(!mycmp(parv[1], "SAVE"))
    {
        return save_levels();
    }
    else if(!mycmp(parv[1], "LOAD"))
    {
        return load_levels();
    }

    return 0;
}

/* m_sl - Sets the user's level
 * -Kobi_S 13/11/2005
 * parv[1] - nick
 * parv[2] - ts
 * parv[3] - level
 * parv[4] - [+/-]flags (optional)
 */
int m_sl(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    aClient *acptr;
    ts_val tsinfo;
    struct user_level *level;

    if(!IsServer(sptr) || (parc<4))
        return 0;

    if(!(acptr = find_person(parv[1], NULL)))
         return 0;
    tsinfo = atol(parv[2]);        
    if(tsinfo && tsinfo!=acptr->tsinfo)
        return 0; /* wrong tsinfo */

    if(!IsULine(sptr))
    {
        if(cptr->from!=acptr->from)
            return 0; /* Wrong direction */
    }

    level = find_level(atoi(parv[3])); /* Note: level *CAN* be NULL! */

    acptr->user->level = level;

    if(parc==5)
    {
        if(!MyClient(acptr))
        {
            sendto_serv_butone(cptr, ":%s SL %s %ld %s %s", parv[0], acptr->name, tsinfo, 
                               parv[3], parv[4]);
            return 0;
        }
        if(parv[4][0]=='-')
            acptr->oflag &= ~(atol(parv[4]) * -1);
        else if(parv[4][0]=='+')
            acptr->oflag |= atol(parv[4]);
        else
            acptr->oflag = atol(parv[4]);
    }
    sendto_serv_butone(cptr, ":%s SL %s %ld %s", parv[0], acptr->name, tsinfo, parv[3]);

    return 0;
}

/* m_lwo - Level WallOps
           parv[1] = minimum level
           parv[2] = maximum level (optinal)
           parv[2] or parv[3] = message
 */
int m_lwo(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    int i;
    unsigned int minlevel,maxlevel;
    char *msg;
    aClient *acptr;

    if(!IsULine(sptr) || parc<3)
        return 0;

    minlevel = atoi(parv[1]);
    if(parc==4)
    {
        maxlevel = atoi(parv[2]);
        msg = parv[3];
    }
    else
    {
        maxlevel = minlevel;
        msg = parv[2];
    }
    for(i=0;i<=highest_fd;i++)
    {
        if((acptr=local[i])!=NULL)
        {
            if(!IsRegisteredUser(acptr) || !SendWallops(acptr) || !acptr->user->level || acptr->user->level->level<minlevel || acptr->user->level->level>maxlevel|| (maxlevel<25 && IsAnOper(acptr)))
                continue;
            sendto_prefix_one(acptr, sptr, ":%s WALLOPS :%s", parv[0], msg);
        }
    }

    if(parc==4)
        sendto_serv_butone(cptr, ":%s LWO %s %s :%s", parv[0], parv[1], parv[2], msg);
    else
        sendto_serv_butone(cptr, ":%s LWO %s :%s", parv[0], parv[1], msg);

    return 0;
}

/* m_lgo - Level GlobOps
           parv[1] = minimum level
           parv[2] = maximum level (optinal)
           parv[2] or parv[3] = message
 */
int m_lgo(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    int i;
    unsigned int minlevel,maxlevel;
    char *msg;
    aClient *acptr;

    if(!IsULine(sptr) || parc<3)
        return 0;

    minlevel = atoi(parv[1]);
    if(parc==4)
    {
        maxlevel = atoi(parv[2]);
        msg = parv[3];
    }
    else
    {
        maxlevel = minlevel;
        msg = parv[2];
    }
    for(i=0;i<=highest_fd;i++)
    {
        if((acptr=local[i])!=NULL)
        {
            if(!IsRegisteredUser(acptr) || !SendGlobops(acptr) || !acptr->user->level || acptr->user->level->level<minlevel || acptr->user->level->level>maxlevel || (maxlevel<25 && IsAnOper(acptr)))
                continue;
            sendto_prefix_one(acptr, sptr, ":%s NOTICE %s :*** Global -- from %s: %s", 
                              me.name, acptr->name, parv[0], msg);
        }
    }

    if(parc==4)
        sendto_serv_butone(cptr, ":%s LGO %s %s :%s", parv[0], parv[1], parv[2], msg);
    else
        sendto_serv_butone(cptr, ":%s LGO %s :%s", parv[0], parv[1], msg);

    return 0;
}

/* send_helpops - Send a notice to all the local +h users.
 * -Kobi_S 01/12/2005
 */
void send_helpops(char *pattern, ...)
{
    aClient *cptr;
    char nbuf[1024];
    va_list vl;
    int i;

    va_start(vl, pattern);
    for (i = 0; i <= highest_fd; i++)
    {
        if ((cptr = local[i]) && !IsServer(cptr) && !IsMe(cptr) && IsUmodeh(cptr))
        {
            ircsprintf(nbuf, ":%s NOTICE %s :*** HelpOp -- %s",
                       me.name, cptr->name, pattern);
            vsendto_one(cptr, nbuf, vl);
        }
    }
    va_end(vl);

    return;
}

/* m_helpop - Send a notice to all the +h users/opers.
              parv[1] = message
 */
int m_helpop(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    char *message = parc > 1 ? parv[1] : NULL;

    if (BadPtr(message))
    {
        if (MyClient(sptr))
            sendto_one(sptr, err_str(ERR_NEEDMOREPARAMS),
                       me.name, parv[0], "HELPOP");
        return 0;
    }

    if(disable_helpop && ((disable_helpop > 1) || (MyConnect(sptr) && !IsUmodeh(sptr) && !IsAnOper(sptr))))
    {
        sendto_one(sptr, ":%s NOTICE %s :The helpop command has been disabled.",
                   me.name, parv[0]);
        return 0;
    }

    if (strlen(message) > TOPICLEN)
        message[TOPICLEN] = '\0';
    sendto_serv_butone_super(cptr, 0, ":%s HELPOP %s", parv[0], message);
    if (MyConnect(sptr) && !IsUmodeh(sptr) && !IsAnOper(sptr))
    {
        sptr->since += 4;
        sendto_one(sptr, ":%s NOTICE %s :Your help request has been forwarded to our helpers,",
                   me.name, parv[0]);
        sendto_one(sptr, ":%s NOTICE %s :They will try to assist you as soon as possible.", 
                   me.name, parv[0]);
        sendto_one(sptr, ":%s NOTICE %s :If you need help with %s's services or help from an IRC Operator goto #IRCtoo", me.name, parv[0], Network_Name);
        sendto_one(sptr, ":%s NOTICE %s :Thank you for using %s!", me.name, parv[0], 
                   Network_Name);
        send_helpops("from %s (Local): %s", parv[0], message);
    }
    else
        send_helpops("from %s: %s", parv[0], message);
    return 0;
}

/* send_irctoo_chatops - Send a notice to all the local +b users (not only to +b opers).
 * -Kobi_S 04/12/2005
 */
void send_irctoo_chatops(char *pattern, ...)
{
    aClient *cptr;
    char nbuf[1024];
    va_list vl;
    int i;

    va_start(vl, pattern);
    for (i = 0; i <= highest_fd; i++)
    {
        if ((cptr = local[i]) && !IsServer(cptr) && !IsMe(cptr) && SendChatops(cptr))
        {
            ircsprintf(nbuf, ":%s NOTICE %s :*** ChatOps -- %s",
                       me.name, cptr->name, pattern);
            vsendto_one(cptr, nbuf, vl);
        }
    }
    va_end(vl);

    return;
}

int set_irctoo_ulf(aClient *acptr)
{
    struct ulf_server *p = ulf_servers;

    for(; p; p = p->next)
    {
        if(!mycmp(acptr->name, p->name))
        {
            acptr->serv->uflags = p->uflags;
            return 1; /* Found! */
        }
    }

    return 0; /* Not found */
}

struct ulf_server *new_ulf_server(char *name, long uflags)
{
    struct ulf_server *p;
    aClient *acptr = find_client(name, NULL);

    p = MyMalloc(sizeof(struct ulf_server));
    p->next = ulf_servers;
    ulf_servers = p;
    p->name = MyMalloc(strlen(name) + 1);
    strcpy(p->name, name);
    p->uflags = uflags;

    if(acptr && IsServer(acptr))
        acptr->serv->uflags = uflags;

    return p;
}

/* del_ulf_server - Deletes a server from ulf servers list.
 *             Returns: 1 = Success
 *                      0 = Failure
 */
int del_ulf_server(char *name)
{
    struct ulf_server *p, *pprev, *pn;

    for(p = ulf_servers, pprev = NULL; p; pprev = p, p = pn)
    {
        pn = p->next;
        if(!mycmp(name, p->name))
        {
            if(pprev)
                pprev->next = p->next;
            else
                ulf_servers = p->next;
            if(p->name)
                MyFree(p->name);
            MyFree(p);
            return 1; /* Success */
        }
    }

    return 0; /* Failure */
}

/* del_ulf_servers - Deletes all ulf servers from memory */
int del_ulf_servers()
{
    struct ulf_server *p, *pn;

    for(p = ulf_servers; p; p = pn)
    {
        pn = p->next;
        if(p->name)
            MyFree(p->name);
        MyFree(p);
    }
    ulf_servers = NULL;

    return 1;
}

void send_warnops(char *pattern, ...)
{
    aClient *cptr;
    char nbuf[1024];
    va_list vl;
    int i;

    va_start(vl, pattern);
    for (i = 0; i <= highest_fd; i++)
    {
        if ((cptr = local[i]) && !IsServer(cptr) && !IsMe(cptr) && OPCanW(cptr) && SendServNotice(cptr))
        {
            ircsprintf(nbuf, ":%s NOTICE %s :*** Warning -- %s",
                       me.name, cptr->name, pattern);
            vsendto_one(cptr, nbuf, vl);
        }
    }
    va_end(vl);

    return;
}

int m_wo(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    char       *message = parc > 1 ? parv[1] : NULL;

    if (BadPtr(message))
    {
        return 0;
    }

    if (!IsServer(sptr))
    {
        sendto_one(sptr, err_str(ERR_NOPRIVILEGES), me.name, parv[0]);
        return 0;
    }
    if (strlen(message) > TOPICLEN)
        message[TOPICLEN] = '\0';
    sendto_serv_butone_super(cptr, 0, ":%s WO :%s", parv[0], message);
    send_warnops("from %s: %s", parv[0], message);

    return 0;
}

int m_nw(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    int level;

    if (!IsServer(sptr))
    {
        sendto_one(sptr, err_str(ERR_NOPRIVILEGES), me.name, parv[0]);
        return 0;
    }

    if(parc<3)
        return 0;

    if (strlen(parv[2]) > TOPICLEN)
        parv[2][TOPICLEN] = '\0';
    level = atoi(parv[1]);
    sendto_serv_butone_super(cptr, 0, ":%s NW %d :%s", parv[0], level, parv[2]);
    sendto_realops_lev(level, "from %s: %s", parv[0], parv[2]);

    return 0;
}

int check_sf(aClient *cptr, char *text, char *caction, int action, char *target)
{
    struct spam_filter *p = spam_filters;
    unsigned short blocked = 0;
    unsigned short reported = 0;
    unsigned short warned = 0;
    unsigned short matched;
    char stripamsg[512];
    char stripcmsg[512];
    unsigned int len = 0; /* For regexp */
    int ovector[30]; /* For regexp */

    if(IsAnOper(cptr))
        return 0;

    stripamsg[0] = '\0';
    stripcmsg[0] = '\0';

    for(; p; p = p->next)
    {
        if(!(p->flags & action))
            continue;
        if(IsRegNick(cptr) && !(p->flags & SF_FLAG_MATCHREG))
            continue;
        if(p->flags & SF_FLAG_STRIPALL)
        {
            if(stripamsg[0]=='\0')
                stripall(stripamsg, text);
            matched = !match(p->text,stripamsg);
        }
        else if(p->flags & SF_FLAG_STRIPCTRL)
        {
            if(stripcmsg[0]=='\0')
                stripcolors(stripcmsg, text);
            matched = !match(p->text,stripcmsg);
        }
        else if(p->flags & SF_FLAG_REGEXP)
        {
            if(!len)
                len = strlen(p->text);
            if(pcre_exec(p->re, NULL, p->text, len, 0, 0, ovector, 30) > 0)
                matched = 1;
            
        }
        else matched = !match(p->text,text);
        if(matched) {
            if(p->flags & SF_ACT_LAG)
                cptr->since += 4;
            if(p->flags & SF_ACT_BLOCK)
                blocked = 1;
            if(!warned && (p->flags & SF_ACT_WARN))
            {
                sendto_one(cptr, ":%s NOTICE %s :*** Notice -- Your message has been %s. Reason: %s",
                           me.name, cptr->name, blocked?"blocked":"warned",
                           p->reason?p->reason:"<none>");
                sendto_one(cptr, ":%s NOTICE %s :*** Notice -- Please visit http://www.irctoo.net/kb/view.php?kb=118 for more information.",
                           me.name, cptr->name);
                warned++;
            }
            if(!reported && (p->flags & SF_ACT_REPORT))
            {
                send_warnops("spamfilter %s: %s by %s to %s --> %s", p->text,
                             caction, cptr->name, target, text);
                sendto_serv_butone(NULL, ":%s WO :spamfilter %s: %s by %s to %s --> %s",
                                   me.name, p->text, caction, cptr->name, target, text);
                reported++;
            }
            if(p->flags & SF_ACT_AKILL)
            {
                if(aliastab[AII_OS].client)
                    sendto_one(aliastab[AII_OS].client->from, ":%s OS SFAKILL %s %s", me.name, cptr->name, 
                               p->reason?p->reason:"<none>");
            }
            if(p->flags & SF_ACT_KILL)
            {
                blocked = 2;
                if(action!=SF_CMD_QUIT)
                {
                    ircsprintf(buf2, "Local kill by %s (%s)", me.name, p->reason?p->reason:"<none>");
                    exit_client(cptr, cptr, cptr, buf2);
                    return blocked;
                }
            }
            if(p->flags & SF_FLAG_BREAK)
                return blocked;
        }
    }

    return blocked;
}

struct spam_filter *find_sf(char *text)
{
    struct spam_filter *p = spam_filters;

    for(; p; p = p->next)
    {
        if(!mycmp(p->text,text))
            return p; /* Found! */
    }

    return NULL; /* Not found */
}

struct spam_filter *new_sf(char *text, long flags, char *reason)
{
    struct spam_filter *p;
    int erroroffset;
    const char *error;
    pcre *re;

    if(flags & SF_FLAG_REGEXP)
    {
        re = pcre_compile(text, PCRE_COMP_FLAGS, &error, &erroroffset, NULL);
        if(!re)
            return NULL; /* error! */
    }
    else
        re = NULL;

    p = find_sf(text);
    if(p)
    {
        if(p->reason)
            MyFree(p->reason);
    }
    else
    {
        p = MyMalloc(sizeof(struct spam_filter));
        p->next = spam_filters;
        spam_filters = p;
        p->text = MyMalloc(strlen(text) + 1);
        strcpy(p->text, text);
    }
    p->flags = flags;
    p->re = re;
    if(reason) {
      p->reason = MyMalloc(strlen(reason) + 1);
      strcpy(p->reason, reason);
    }
    else p->reason = NULL;

    return p;
}

int del_sf(char *text)
{
    struct spam_filter *p, *pprev, *pn;

    for(p = spam_filters, pprev = NULL; p; pprev = p, p = pn)
    {
        pn = p->next;
        if(!mycmp(p->text,text))
        {
            if(pprev)
                pprev->next = p->next;
            else
                spam_filters = p->next;
            if(p->text)
                MyFree(p->text);
            if(p->reason)
                MyFree(p->reason);
            if(p->re)
                MyFree(p->re);
            MyFree(p);
            return 1; /* Success */
        }
    }

    return 0; /* Failure */
}

/* m_sf - Spam Filter
 * parv[1] - Text
 * parv[2] - Flags (0 to delete)
 * parv[3] - Reason
 */
int m_sf(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    AliasInfo *ai = &aliastab[AII_OS];

    if(!IsServer(sptr) || parc<3)
        return 0;

    if(!IsULine(sptr) && ai->client && ai->client->from!=cptr->from)
    {
        /*
         * We don't accept commands from a non-services direction.
         * Also, we remove non-existed levels if they come from this location.
         * Note: we don't need to worry about existed levels on the other side
         * because they will be overrided anyway.
         */
        if(!find_sf(parv[1]) && mycmp(parv[2], "0"))
            sendto_one(cptr, ":%s SF %s 0", me.name, parv[1]);
        return 0;
    }
    if(mycmp(parv[2], "0"))
        new_sf(parv[1], atol(parv[2]), parv[3]);
    else
        del_sf(parv[1]);

    if(parc<4)
        sendto_serv_butone(cptr, ":%s SF %s %s", parv[0], parv[1], parv[2]);
    else
        sendto_serv_butone(cptr, ":%s SF %s %s :%s", parv[0], parv[1], parv[2], parv[3]);

    return 0;
}

/* m_fixts - Changes a channel's TS
 * -Kobi_S 21/04/2007
 * parv[1] - channel
 * parv[2] - newts
 */
int m_fixts(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
    aChannel *chptr;

    if(!IsULine(sptr) || (parc<3))
        return 0;

    if(!(chptr = find_channel(parv[1], NULL)))
        return 0;

    chptr->channelts = atol(parv[2]);
    sendto_serv_butone(cptr, ":%s FIXTS %s %s", parv[0], parv[1], parv[2]);

    return 0;
}

/* Strip colors and other control codes from a text */
void stripcolors(char new[512], char *org)
{
    int len = 0;

    for(; (*org && len<512); org++)
    {
        if(*org=='\022' || *org=='\033' || *org=='\002' || *org=='\031' || *org=='\015')
            continue;
        if(*org=='\003')
        {
            org++;
            while(IsDigit(*org) || *org==',')
                org++;
        }
        new[len++] = *org;
    }
    new[len] = '\0';
}

/* Strip all "special" chars */
void stripall(char new[512], char *org)
{
#define fstripall(c) ((c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || IsDigit(c) || c == '-' || c == '/' || c == '.' || c== '$' || c == '(' || (c >= '' && c <= '')) /* to strip everything ;) */
    int len = 0;

    for(; (*org && len<512); org++)
    {
        if(*org=='\022' || *org=='\033' || *org=='\002' || *org=='\031' || *org=='\015')
            continue;
        if(*org=='\003')
        {
            org++;
            while(IsDigit(*org) || *org==',')
                org++;
        }
        if(!fstripall(*org))
            continue;
        new[len++] = *org;
    }
    new[len] = '\0';
}

char *irctoo_umodes(aClient *cptr)
{
    static char umodes[31];
    int len = 0;
    int *s, flag;

    umodes[0] = '+';

    for(s = user_modes; (flag = *s); s += 2)
    {
        if(cptr->umode & flag)
            umodes[++len] = *(s + 1);
    }
    if(!(cptr->umode & UMODE_r))
    {
        if(len == 0) len--;
        umodes[++len] = '-';
        umodes[++len] = 'r';
    }

    umodes[++len] = '\0';

    return umodes;
}

int has_opvoice(aClient *cptr, aChannel *chptr)
{
    chanMember   *cm;

    if (chptr)
        if ((cm = find_user_member(chptr->members, cptr)))
            return ((cm->flags & CHFL_CHANOP) || (cm->flags & CHFL_VOICE));

    return 0;
}

