/*
 *   IRC - Internet Relay Chat, include/struct.h
 *   Copyright (C) 1990 Jarkko Oikarinen and
 *                      University of Oulu, Computing Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	__struct_include__
#define __struct_include__

#include "config.h"
#include "common.h"
#include "sys.h"

#include <stdarg.h>

#include <stdio.h>
#include <sys/types.h>
#ifndef _WIN32
#include <netinet/in.h>
#include <netdb.h>
#endif
#ifdef HAVE_STDDEF_H
# include <stddef.h>
#endif

#ifdef USE_SYSLOG
# include <syslog.h>
# ifdef HAVE_SYS_SYSLOG_H
#  include <sys/syslog.h>
# endif
#endif
#ifdef	pyr
#include <sys/time.h>
#endif

typedef struct  SqlineItem aSqlineItem;
typedef	struct	ConfItem aConfItem;
typedef struct	Notify	aNotify;
typedef	struct 	Client	aClient;
typedef	struct	Channel	aChannel;
typedef	struct	User	anUser;
typedef	struct	Server	aServer;
typedef	struct	SLink	Link;
typedef struct	sMember	Member;
typedef	struct	sHush	Hush;
typedef struct	SBan	Ban;
typedef	struct	SMode	Mode;
typedef struct	ListOptions	LOpts;
typedef struct	Message	Msg;
typedef	struct	sModeFlag ModeFlag;

typedef struct  CloneItem aClone;

#ifdef NEED_U_INT32_T
typedef unsigned int  u_int32_t; /* XXX Hope this works! */
#endif

#ifndef VMSP
#include "class.h"
#include "dbuf.h"	/* THIS REALLY SHOULDN'T BE HERE!!! --msa */
#endif

#define	HOSTLEN		63	/* Length of hostname.  Updated to         */
				/* comply with RFC1123                     */

#define	NICKLEN		30
#define	USERLEN		10
#define	REALLEN	 	50
#define	TOPICLEN	307
#define AWAYLEN		115
#define	CHANNELLEN	32
#define	PASSWDLEN 	32	/* orig. 20, changed to 32 for nickpasswords */
#define	KEYLEN		11
#define	BUFSIZE		512		/* WARNING: *DONT* CHANGE THIS!!!! */
#define	MAXRECIPIENTS 	20
#define	MAXKILLS	10
#define	MAXBANS		60
#define	MAXBANLENGTH	1024
#define	MAXSILES	5
#define	MAXSILELENGTH	128
/*
 * Watch it - Don't change this unless you also change the ERR_TOOMANYWATCH
 * and PROTOCOL_SUPPORTED settings.
 */
#define MAXWATCH	128

#define	USERHOST_REPLYLEN	(NICKLEN+HOSTLEN+USERLEN+5)


/* NOTE: this must be down here so the stuff from struct.h IT uses works */
#include "whowas.h"


/*
** 'offsetof' is defined in ANSI-C. The following definition
** is not absolutely portable (I have been told), but so far
** it has worked on all machines I have needed it. The type
** should be size_t but...  --msa
*/
#ifndef offsetof
#define	offsetof(t,m) (int)((&((t *)0L)->m))
#endif

#define	elementsof(x) (sizeof(x)/sizeof(x[0]))

/*
** flags for bootup options (command line flags)
*/
#define	BOOT_CONSOLE	1
#define	BOOT_QUICK	2
#define	BOOT_DEBUG	4
#define	BOOT_INETD	8
#define	BOOT_TTY	16
#define	BOOT_OPER	32
#define	BOOT_AUTODIE	64

#define	STAT_LOG	-6	/* logfile for -x */
#define	STAT_MASTER	-5	/* Local ircd master before identification */
#define	STAT_CONNECTING	-4
#define	STAT_HANDSHAKE	-3
#define	STAT_ME		-2
#define	STAT_UNKNOWN	-1
#define	STAT_SERVER	0
#define	STAT_CLIENT	1

/*
 * status macros.
 */
#define	IsRegisteredUser(x)	((x)->status == STAT_CLIENT)
#define	IsRegistered(x)		((x)->status >= STAT_SERVER)
#define	IsConnecting(x)		((x)->status == STAT_CONNECTING)
#define	IsHandshake(x)		((x)->status == STAT_HANDSHAKE)
#define	IsMe(x)			((x)->status == STAT_ME)
#define	IsUnknown(x)		((x)->status == STAT_UNKNOWN || \
				 (x)->status == STAT_MASTER)
#define	IsServer(x)		((x)->status == STAT_SERVER)
#define	IsClient(x)		((x)->status == STAT_CLIENT)
#define	IsLog(x)		((x)->status == STAT_LOG)
#define IsService(x)		0

#define	SetMaster(x)		((x)->status = STAT_MASTER)
#define	SetConnecting(x)	((x)->status = STAT_CONNECTING)
#define	SetHandshake(x)		((x)->status = STAT_HANDSHAKE)
#define	SetMe(x)		((x)->status = STAT_ME)
#define	SetUnknown(x)		((x)->status = STAT_UNKNOWN)
#define	SetServer(x)		((x)->status = STAT_SERVER)
#define	SetClient(x)		((x)->status = STAT_CLIENT)
#define	SetLog(x)		((x)->status = STAT_LOG)
#define	SetService(x)		((x)->status = STAT_SERVICE)

#define	FLAGS_PINGSENT   0x0001	/* Unreplied ping sent */
#define	FLAGS_DEADSOCKET 0x0002	/* Local socket is dead--Exiting soon */
#define	FLAGS_KILLED     0x0004	/* Prevents "QUIT" from being sent for this */
#define	FLAGS_BLOCKED    0x0008	/* socket is in a blocked condition */
#define	FLAGS_CLOSING    0x0020	/* set when closing to suppress errors */
#define	FLAGS_LISTEN     0x0040 /* used to mark clients which we listen() on */
#define	FLAGS_CHKACCESS  0x0080 /* ok to check clients access if set */
#define	FLAGS_DOINGDNS	 0x0100 /* client is waiting for a DNS response */
#define	FLAGS_AUTH	 0x0200 /* client is waiting on rfc931 response */
#define	FLAGS_WRAUTH	 0x0400	/* set if we havent writen to ident server */
#define	FLAGS_LOCAL	 0x0800 /* set for local clients */
#define	FLAGS_GOTID	 0x1000	/* successful ident lookup achieved */
#define	FLAGS_DOID	 0x2000	/* I-lines say must use ident return */
#define	FLAGS_NONL	 0x4000 /* No \n in buffer */
#define FLAGS_ULINE	0x10000 /* User/server is considered U-lined */
#define FLAGS_SQUIT	0x20000 /* Server has been /squit by an oper */
#define	FLAGS_GOTUSER	0x80000 /* got USER message from this client */

/* Dec 26th, 1997 - added flags2 when I ran out of room in flags -DuffJ 

/* Dec 26th, 1997 - having a go at
 * splitting flags into flags and umodes
 * -DuffJ
 */

#define	UMODE_INVISIBLE  0x00001 /* makes user invisible */
#define	UMODE_OPER       0x00002 /* Operator */
#define	UMODE_WALLOP     0x00004 /* send wallops to them */
#define UMODE_FAILOP	 0x00008 /* Shows some global messages */
#define UMODE_REGNICK	 0x00020 /* Nick set by services as registered */
#define UMODE_SADMIN	 0x00040 /* Services Admin */
#define UMODE_ADMIN	 0x00080 /* Admin */

#define	UMODE_SERVNOTICE 0x00100 /* server notices such as kill */
#define	UMODE_LOCOP      0x00200 /* Local operator -- SRB */
#define UMODE_KILLS	 0x00400 /* Show server-kills... */
#define UMODE_CLIENT	 0x00800 /* Show client information */
#define UMODE_FLOOD	 0x01000 /* Receive flood warnings */
#define UMODE_CHATOP	 0x02000 /* can receive chatops */
#define	UMODE_JUNK	 0x04000 /* receive annoying server junk, such as
				failed server conncetions, nick collisions,
				etc. */
#define	UMODE_CSOP	 0x08000 /* user is a CSop */
#define UMODE_SRA	 0x10000 /* user is a Services Root Administrator */
#define	UMODE_DISGUISE	 0x20000 /* hide a user's most specific part of addy */
#define	UMODE_HUSHNOTICE 0x40000 /* display hush notices */
#define UMODE_FORCEDIS	 0x80000 /* force user to be disguised */
#define	UMODE_LIMITREG	0x100000 /* only allow regnicks to contact person */
#define UMODE_TSNOTICE  0x200000 /* display TS notices */

#define	UMODE_ANYOP	(UMODE_OPER|UMODE_LOCOP)
#define	ALL_UMODES	0xFFFFFFFF
#define SEND_UMODES	(UMODE_OPER|UMODE_INVISIBLE|UMODE_REGNICK|	\
			 UMODE_ADMIN|UMODE_SADMIN|UMODE_CSOP|UMODE_SRA|  \
			 UMODE_DISGUISE|UMODE_FORCEDIS|UMODE_WALLOP	\
			 |UMODE_LIMITREG)
#define	FLAGS_ID	(FLAGS_DOID|FLAGS_GOTID)

/*
 * flags macros.
 */
#define IsKillsF(x)		((x)->umodes & UMODE_KILLS)
#define IsClientF(x)		((x)->umodes & UMODE_CLIENT)
#define IsFloodF(x)		((x)->umodes & UMODE_FLOOD)
#define IsAdmin(x)		((x)->umodes & UMODE_ADMIN)
#define IsSAdmin(x)		((x)->umodes & UMODE_SADMIN)
#define SendFailops(x)		((x)->umodes & UMODE_FAILOP)
#define SendChatops(x)		((x)->umodes & UMODE_CHATOP)
#define	SendJunk(x)		((x)->umodes & UMODE_JUNK)
#define	IsOper(x)		((x)->umodes & UMODE_OPER)
#define	IsLocOp(x)		((x)->umodes & UMODE_LOCOP)
#define	IsInvisible(x)		((x)->umodes & UMODE_INVISIBLE)
#define	IsSRA(x)		((x)->umodes & UMODE_SRA)
#define	IsCSop(x)		((x)->umodes & UMODE_CSOP)
#define	IsAnOper(x)		((x)->umodes & (UMODE_OPER|UMODE_LOCOP))
#define	IsDisguise(x)		((x)->umodes & UMODE_DISGUISE)
#define IsForceDis(x)		((x)->umodes & UMODE_FORCEDIS)
#define IsARegNick(x)		((x)->umodes & (UMODE_REGNICK))
#define IsRegNick(x)		((x)->umodes & UMODE_REGNICK)
#define	GotUser(x)		((x)->flags & FLAGS_GOTUSER)
#define	IsPerson(x)		(IsClient(x))
#define	IsPrivileged(x)		(IsAnOper(x) || IsServer(x))
#define	SendWallops(x)		((x)->umodes & UMODE_WALLOP)
#define	SendServNotice(x)	((x)->umodes & UMODE_SERVNOTICE)
#define	SendHushNotice(x)	((x)->umodes & UMODE_HUSHNOTICE)
#define	IsUnixSocket(x)		((x)->flags & FLAGS_UNIX)
#define	IsListening(x)		((x)->flags & FLAGS_LISTEN)
#define	DoAccess(x)		((x)->flags & FLAGS_CHKACCESS)
#define	IsLocal(x)		((x)->flags & FLAGS_LOCAL)
#define	IsDead(x)		((x)->flags & FLAGS_DEADSOCKET)
#define IsBlocked(x)		((x)->flags & FLAGS_BLOCKED)

#define SetKillsF(x)		((x)->umodes |= UMODE_KILLS)
#define SetClientF(x)		((x)->umodes |= UMODE_CLIENT)
#define SetFloodF(x)		((x)->umodes |= UMODE_FLOOD)
#define	SetOper(x)		((x)->umodes |= UMODE_OPER)
#define	SetLocOp(x)    		((x)->umodes |= UMODE_LOCOP)
#define	SetInvisible(x)		((x)->umodes |= UMODE_INVISIBLE)
#define	SetWallops(x)  		((x)->umodes |= UMODE_WALLOP)
#define	SetUnixSock(x)		((x)->flags |= FLAGS_UNIX)
#define	SetDNS(x)		((x)->flags |= FLAGS_DOINGDNS)
#define	DoingDNS(x)		((x)->flags & FLAGS_DOINGDNS)
#define	SetAccess(x)		((x)->flags |= FLAGS_CHKACCESS)
#define SetBlocked(x)		((x)->flags |= FLAGS_BLOCKED)
#define	DoingAuth(x)		((x)->flags & FLAGS_AUTH)
#define	NoNewLine(x)		((x)->flags & FLAGS_NONL)
#define SetRegNick(x)		((x)->umodes & UMODE_REGNICK)

#define ClearAdmin(x)		((x)->umodes &= ~UMODE_ADMIN)
#define ClearSAdmin(x)		((x)->umodes &= ~UMODE_SADMIN)
#define ClearKillsF(x)		((x)->umodes &= ~UMODE_KILLS)
#define ClearClientF(x)		((x)->umodes &= ~UMODE_CLIENT)
#define ClearFloodF(x)		((x)->umodes &= ~UMODE_FLOOD)
#define ClearFailops(x)		((x)->umodes &= ~UMODE_FAILOP)
#define ClearChatops(x)		((x)->umodes &= ~UMODE_CHATOP)
#define	ClearOper(x)		((x)->umodes &= ~UMODE_OPER)
#define	ClearInvisible(x)	((x)->umodes &= ~UMODE_INVISIBLE)
#define	ClearWallops(x)		((x)->umodes &= ~UMODE_WALLOP)
#define	ClearHushNotice(x)	((x)->umodes &= ~UMODE_HUSHNOTICE)
#define ClearDisguise(x)	((x)->umodes &= ~UMODE_DISGUISE)
#define	ClearDNS(x)		((x)->flags &= ~FLAGS_DOINGDNS)
#define	ClearAuth(x)		((x)->flags &= ~FLAGS_AUTH)
#define	ClearAccess(x)		((x)->flags &= ~FLAGS_CHKACCESS)
#define ClearBlocked(x)		((x)->flags &= ~FLAGS_BLOCKED)

/*
 * ProtoCtl options
 */
#define PROLEV_USER		-1
#define PROLEV_GEN		0
#define PROLEV_NOQUIT		1
#define PROLEV_TOKEN		2
#define PROLEV_SERVHASH		3
#define PROLEV_COMPACT		4
#define	PROLEV_AKILL		4
#define PROLEV_CACHE		4

#define PROLEV_MAX PROLEV_CACHE

#define	DontSendQuit(x)		((x)->prolev >= PROLEV_NOQUIT)
#define	IsToken(x)		((x)->prolev >= PROLEV_TOKEN)
#define IsServHash(x)		((x)->prolev >= PROLEV_SERVHASH)
#define	IsCompact(x)		((x)->prolev >= PROLEV_COMPACT)
#define	IsNewAkill(x)		((x)->prolev >= PROLEV_AKILL)

#define	SetUser(x)		((x)->prolev = PROLEV_USER)
#define AddProto(x,p)		(((x)->prolev<p)?((x)->prolev=p):0)
#define SetNoQuit(x)		AddProto(x,PROLEV_NOQUIT)
#define	SetToken(x)		AddProto(x,PROLEV_TOKEN)
#define SetServHash(x)		AddProto(x,PROLEV_SERVHASH)

/*
 * defined operator access levels
 */
#define OFLAG_REHASH	0x00000001  /* Oper can /rehash server */
#define OFLAG_DIE	0x00000002  /* Oper can /die the server */
#define OFLAG_RESTART	0x00000004  /* Oper can /restart the server */
#define OFLAG_GLOBOP	0x00000010  /* Oper can send /GlobOps */
#define OFLAG_WALLOP	0x00000020  /* Oper can send /WallOps */
#define OFLAG_LOCOP	0x00000040  /* Oper can send /LocOps */
#define OFLAG_LROUTE	0x00000080  /* Oper can do local routing */
#define OFLAG_GROUTE	0x00000100  /* Oper can do global routing */
#define OFLAG_LKILL	0x00000200  /* Oper can do local kills */
#define OFLAG_GKILL	0x00000400  /* Oper can do global kills */
#define OFLAG_KLINE	0x00000800  /* Oper can /kline users */
#define OFLAG_UNKLINE	0x00001000  /* Oper can /unkline users */
#define OFLAG_LNOTICE	0x00002000  /* Oper can send local serv notices */
#define OFLAG_GNOTICE	0x00004000  /* Oper can send global notices */
#define OFLAG_ADMIN	0x00008000  /* Admin */
#define OFLAG_UMODEC	0x00010000  /* Oper can set umode +c */
#define OFLAG_UMODEF	0x00020000  /* Oper can set umode +f */
#define OFLAG_SADMIN    0x00040000  /* Oper can be a services admin */
#define OFLAG_ZLINE	0x00080000  /* Oper can use /zline and /unzline */
#define OFLAG_REMOTE	0x00100000  /* Oper can do remote klines, rehashes, etc */
#define OFLAG_SET       0x00200000  /* Oper can use the set command */

#define OFLAG_LOCAL	(OFLAG_REHASH|OFLAG_GLOBOP|OFLAG_WALLOP|OFLAG_LOCOP|OFLAG_LROUTE|OFLAG_LKILL|OFLAG_KLINE|OFLAG_UNKLINE|OFLAG_LNOTICE|OFLAG_UMODEC|OFLAG_UMODEF)
#define OFLAG_GLOBAL	(OFLAG_LOCAL|OFLAG_GROUTE|OFLAG_GKILL|OFLAG_GNOTICE)
#define OFLAG_ISGLOBAL	(OFLAG_GROUTE|OFLAG_GKILL|OFLAG_GNOTICE)

#define OPCanZline(x)		((x)->oflag & OFLAG_ZLINE)
#define OPCanRehash(x)		((x)->oflag & OFLAG_REHASH)
#define OPCanDie(x)		((x)->oflag & OFLAG_DIE)
#define OPCanRestart(x)		((x)->oflag & OFLAG_RESTART)
#define OPCanGlobOps(x)		((x)->oflag & OFLAG_GLOBOP)
#define OPCanWallOps(x)		((x)->oflag & OFLAG_WALLOP)
#define OPCanLocOps(x)		((x)->oflag & OFLAG_LOCOP)
#define OPCanLRoute(x)		((x)->oflag & OFLAG_LROUTE)
#define OPCanGRoute(x)		((x)->oflag & OFLAG_GROUTE)
#define OPCanLKill(x)		((x)->oflag & OFLAG_LKILL)
#define OPCanGKill(x)		((x)->oflag & OFLAG_GKILL)
#define OPCanKline(x)		((x)->oflag & OFLAG_KLINE)
#define OPCanUnKline(x)		((x)->oflag & OFLAG_UNKLINE)
#define OPCanLNotice(x)		((x)->oflag & OFLAG_LNOTICE)
#define OPCanGNotice(x)		((x)->oflag & OFLAG_GNOTICE)
#define OPIsAdmin(x)		((x)->oflag & OFLAG_ADMIN)
#define OPIsSAdmin(x)		((x)->oflag & OFLAG_SADMIN)
#define OPCanUModeC(x)		((x)->oflag & OFLAG_UMODEC)
#define OPCanUModeF(x)		((x)->oflag & OFLAG_UMODEF)
#define OPCanRemote(x)		((x)->oflag & OFLAG_REMOTE)
#define OPCanSet(x)		((x)->oflag & OFLAG_SET)

#define OPSetRehash(x)		((x)->oflag |= OFLAG_REHASH)
#define OPSetDie(x)		((x)->oflag |= OFLAG_DIE)
#define OPSetRestart(x)		((x)->oflag |= OFLAG_RESTART)
#define OPSetGlobOps(x)		((x)->oflag |= OFLAG_GLOBOP)
#define OPSetWallOps(x)		((x)->oflag |= OFLAG_WALLOP)
#define OPSetLocOps(x)		((x)->oflag |= OFLAG_LOCOP)
#define OPSetLRoute(x)		((x)->oflag |= OFLAG_LROUTE)
#define OPSetGRoute(x)		((x)->oflag |= OFLAG_GROUTE)
#define OPSetLKill(x)		((x)->oflag |= OFLAG_LKILL)
#define OPSetGKill(x)		((x)->oflag |= OFLAG_GKILL)
#define OPSetKline(x)		((x)->oflag |= OFLAG_KLINE)
#define OPSetUnKline(x)		((x)->oflag |= OFLAG_UNKLINE)
#define OPSetLNotice(x)		((x)->oflag |= OFLAG_LNOTICE)
#define OPSetGNotice(x)		((x)->oflag |= OFLAG_GNOTICE)
#define OPSSetAdmin(x)		((x)->oflag |= OFLAG_ADMIN)
#define OPSSetSAdmin(x) 	((x)->oflag |= OFLAG_SADMIN)
#define OPSetUModeC(x)		((x)->oflag |= OFLAG_UMODEC)
#define OPSetUModeF(x)		((x)->oflag |= OFLAG_UMODEF)
#define OPSetZLine(x)		((x)->oflag |= OFLAG_ZLINE)

#define OPClearRehash(x)	((x)->oflag &= ~OFLAG_REHASH)
#define OPClearDie(x)		((x)->oflag &= ~OFLAG_DIE)  
#define OPClearRestart(x)	((x)->oflag &= ~OFLAG_RESTART)
#define OPClearGlobOps(x)	((x)->oflag &= ~OFLAG_GLOBOP)
#define OPClearWallOps(x)	((x)->oflag &= ~OFLAG_WALLOP)
#define OPClearLocOps(x)	((x)->oflag &= ~OFLAG_LOCOP)
#define OPClearLRoute(x)	((x)->oflag &= ~OFLAG_LROUTE)
#define OPClearGRoute(x)	((x)->oflag &= ~OFLAG_GROUTE)
#define OPClearLKill(x)		((x)->oflag &= ~OFLAG_LKILL)
#define OPClearGKill(x)		((x)->oflag &= ~OFLAG_GKILL)
#define OPClearKline(x)		((x)->oflag &= ~OFLAG_KLINE)
#define OPClearUnKline(x)	((x)->oflag &= ~OFLAG_UNKLINE)
#define OPClearLNotice(x)	((x)->oflag &= ~OFLAG_LNOTICE)
#define OPClearGNotice(x)	((x)->oflag &= ~OFLAG_GNOTICE)
#define OPClearAdmin(x)		((x)->oflag &= ~OFLAG_ADMIN)
#define OPClearSAdmin(x)	((x)->oflag &= ~OFLAG_SADMIN)
#define OPClearUModeC(x)	((x)->oflag &= ~OFLAG_UMODEC)
#define OPClearUModeF(x)	((x)->oflag &= ~OFLAG_UMODEF)
#define OPClearZLine(x)		((x)->oflag &= ~OFLAG_ZLINE)

/*
 * defined debugging levels
 */
#define	DEBUG_FATAL  0
#define	DEBUG_ERROR  1	/* report_error() and other errors that are found */
#define	DEBUG_NOTICE 3
#define	DEBUG_DNS    4	/* used by all DNS related routines - a *lot* */
#define	DEBUG_INFO   5	/* general usful info */
#define	DEBUG_NUM    6	/* numerics */
#define	DEBUG_SEND   7	/* everything that is sent out */
#define	DEBUG_DEBUG  8	/* anything to do with debugging, ie unimportant :) */
#define	DEBUG_MALLOC 9	/* malloc/free calls */
#define	DEBUG_LIST  10	/* debug list use */

struct  SqlineItem	{
	unsigned int	status;
	char *sqline;
	char *reason;
	struct	SqlineItem *next;
};

struct	ConfItem	{
	unsigned int	status;	/* If CONF_ILLEGAL, delete when no clients */
	int	clients;	/* Number of *LOCAL* clients using this */
	struct	in_addr ipnum;	/* ip number of host field */
	char	*host;
	char	*passwd;
	char	*name;
	int	port;
	time_t	hold;	/* Hold action until this time (calendar time) */
	int	tmpconf;
#ifndef VMSP
	aClass	*class;  /* Class of connection */
#endif
	struct	ConfItem *next;
};

#define	CONF_ILLEGAL		0x80000000
#define	CONF_MATCH		0x40000000
#define CONF_NOOP_GLOBAL	0x20000000
#define CONF_NOOP_LOCAL		0x10000000
#define	CONF_QUARANTINED_SERVER	0x0001
#define	CONF_CLIENT		0x0002
#define	CONF_CONNECT_SERVER	0x0004
#define	CONF_NOCONNECT_SERVER	0x0008
#define	CONF_LOCOP		0x0010
#define	CONF_OPERATOR		0x0020
#define	CONF_ME			0x0040
#define	CONF_KILL		0x0080
#define	CONF_ADMIN		0x0100
#define	CONF_CLASS		0x0400
#define	CONF_SERVICE		0x0800
#define	CONF_LEAF		0x1000
#define	CONF_LISTEN_PORT	0x2000
#define	CONF_HUB		0x4000
#define	CONF_UWORLD		0x8000
#define CONF_QUARANTINED_NICK	0x10000
#define CONF_ZAP		0x20000
#define CONF_CONFIG             0x100000
#define CONF_MISSING		0x800000
#define CONF_SADMIN		0x1000000
#define CONF_DRPASS		0x2000000   /* DIE/RESTART pass - NikB */

#define	CONF_OPS		(CONF_OPERATOR | CONF_LOCOP)
#define	CONF_SERVER_MASK	(CONF_CONNECT_SERVER | CONF_NOCONNECT_SERVER)
#define	CONF_CLIENT_MASK	(CONF_CLIENT | CONF_SERVICE | CONF_OPS | \
				 CONF_SERVER_MASK)
#define CONF_QUARANTINE		(CONF_QUARANTINED_SERVER|CONF_QUARANTINED_NICK)

#define	IsIllegal(x)	((x)->status & CONF_ILLEGAL)
#define IsTemp(x)	((x)->tmpconf)

#define IsHushed(x)	(IsPerson(x) && (x)->u->hush)

/*
 * User structure.
 */
struct User
{
	char	nick[NICKLEN+1];  /* this ***MUST*** come first!!! */
	char	rhost[HOSTLEN+1]; /* REAL host, bypasses +d mode */
	char	dhost[HOSTLEN+1]; /* DISGUISED host, always present! */
	char	*host;		  /* points to host to be seen by normals */
	time_t	nickts;		  /* timestamp on this nick */
	u_int32_t sstamp;         /* Services' time stamp variable */
	Link	*silence;	  /* chain of silence pointer blocks */
	char	*away;		  /* pointer to away message; null if here */
	Hush	*hush;		  /* reason why the user is hushed */
	aName	*whowas;	  /* this user went by another nick before ? */
	Member	*channel;	  /* chain of channel pointer blocks */
	Link	*invited;	  /* chain of invite pointer blocks */
	u_int16_t joined;	  /* number of channels joined */
};

/* 
 * Server structure.
 *   NOTE: Keep this struct smaller than the user struct!
 *
 *   Special note on servid/shortn: shortn will contain the first four letters
 *  of the server's name and a trailing \0; the first four characters will be
 *  stored in servid and the \0 will be in fuzz2.  fuzz1 will align sndot
 *  properly so when sndot is accessed you will see the string ".serv"
 *  if the server's name begins with the letters serv.
 */
struct Server
{
	char		name[HOSTLEN+1];	/* server name, MUST BE FIRST HERE! */
	char		by[NICKLEN+1];

	int		downlinks;		/* number of direct downlinks */
	aClient		*down, *side;		/* down-link and side-link */
	aClient		*next;			/* next server in list */
	aConfItem 	*nline;			/* N-line pointer for this server */
	aClient 	*hnext;			/* next server in server hash */
	aClient		*lastsptr;		/* last sender ptr from this server */
	u_int32_t	servid;			/* 32-bit servid where shortn is stored */
	char		sndot[1];		/* a dot before the shortn (.serv) */
	char		shortn[0];		/* 4-char short name for this serv */
};

/*
 * Client structure.
 *
 *   New features: the client and server part is stored statically in an
 *   internal union, rather than relying upon pointers.  This reduces the
 *   size of the client structure greatly.  Also, the name of the client
 *   is leeched from the server or user structure.  That way, we don't need
 *   to give an entire 63 characters for users' nicknames like before.
 *   Servers get 63 chars and users get 30 chars now.  That's why in the
 *   server and user struct the name field absolutely must come first!
 */
struct Client
{
#if defined(__cplusplus)||defined(c_plusplus)||defined(_WIN32)
	union { char name[HOSTLEN+1]; anUser u[1]; aServer srv[1]; };
#else
	char	name[0];	/* name leeching off of user/serv info area */
	anUser	u[0];		/* static equiv of cptr->user */
	aServer	s[0];		/* static equiv of cptr->serv */
	union { anUser u; aServer s; } idata;
#endif

	aClient *hnext, *prev, *next, **hbase;
	aClient	*from;		/* == self, if Local Client, *NEVER* NULL! */
	aClient	*srvptr;	/* server introducing this.  may be &me. */	
	
	u_int32_t umodes;	/* user modes */
	u_int32_t flags;	/* client flags */
	
	short	fd;		/* >= 0, for local clients */
	short	status;		/* Client type */
	short	hopcount;	/* number of servers to this, 0 = local */
	
	char	username[USERLEN+1]; /* username here now for auth stuff */
	char	info[REALLEN+1]; /* Free form additional client information */


	/*
	** The following fields are allocated only for local clients
	** (directly connected to *this* server with a socket.
	** The first of them *MUST* be the "count"--it is the field
	** to which the allocation is tied to! *Never* refer to
	** these fields, if (from != self).
	*/
	int	count;		/* Amount of data in buffer */
	char	buffer[BUFSIZE]; /* Incoming message buffer */
	short	lastsq;		/* # of 2k blocks when sendqueued called last*/
	dbuf	sendQ;		/* Outgoing message queue--if socket full */
	dbuf	recvQ;		/* Hold for data incoming yet to be parsed */
	long	oflag;		/* Operator access flags -Cabal95 */
	long	sendM;		/* Statistics: protocol messages send */
	long	sendK;		/* Statistics: total k-bytes send */
	long	receiveM;	/* Statistics: protocol messages received */
	long	receiveK;	/* Statistics: total k-bytes received */
	u_short	sendB;		/* counters to count upto 1-k lots of bytes */
	u_short	receiveB;	/* sent and received. */
	short	prolev;		/* protocol level */
	aClient	*acpt;		/* listening client which we accepted from */
	Link	*confs;		/* Configuration record associated */
	int	authfd;		/* fd for rfc931 authentication */
	struct	in_addr	ip;	/* keep real ip# too */
	u_short	port;		/* and the remote port# too :-) */
	struct	hostent	*hostp;
	u_short	notifies;	/* Keep track of count of notifies */
	Link	*notify;	/* Links to clients notify-structures */
	LOpts	*lopt;		/* Saved /list options */
	char	sockhost[HOSTLEN+1]; /* This is the host name from the socket
				     ** and after which the connection was
				     ** accepted.
				     */
	char	passwd[PASSWDLEN+1];
	time_t	lastdcc;	/* last dcc send... */
	time_t	since;		/* last time we parsed something */
	time_t	lasttime;	/* ...should be only LOCAL clients? --msa */
	time_t	firsttime;	/* time client was created */
	time_t	ulast;		/* time used for idle computation */
#ifdef DEBUGMODE
	time_t	cputime;
#endif
};

#define	CLIENT_LOCAL_SIZE sizeof(aClient)
#define	CLIENT_REMOTE_SIZE offsetof(aClient,count)

struct ListOptions {
	LOpts	*next;
	Link	*yeslist, *nolist;
	int	starthash;
	short int	showall;
	unsigned short	usermin;
	int	usermax;
	time_t	currenttime;
	time_t	chantimemin;
	time_t	chantimemax;
	time_t	topictimemin;
	time_t	topictimemax;
};

/* mode structure for channels */

struct	SMode	{
	u_int32_t mode;
	u_int16_t limit;
	u_int16_t maxrept;
	u_int16_t flood;
	char	key[KEYLEN+1];
};

/* Message table structure */

struct	Message	{
	char	cmd[16];
	int	(* func)();
	unsigned int	count;
	int	parameters;
	u_char	token[2]; /* Cheat for tokenized value */
	char	flags;
		/* bit 0 set means that this command is allowed to be used
		 * only on the average of once per 2 seconds -SRB */
	unsigned long bytes;
	unsigned long l_utime;
	unsigned long r_utime;
};

/* ModeFlag structure */
struct sModeFlag
{
	u_int32_t flag;
	char c;
	int extra;
};

/* Used for notify-hash buckets... -Donwulff */

struct Notify {
	aNotify	*hnext;
	time_t	lasttime;
	Link	*notify;
	char	nick[1];
};

/* general link structure used for chains */

struct	SLink	{
	struct	SLink	*next;
	int	flags;
	union {
		aClient	*cptr;
		aChannel *chptr;
		aConfItem *aconf;
		aNotify	*nptr;
		aName *whowas;
		char	*cp;
	} value;
};

struct sMember
{
	struct sMember *nextu; /* next user, in a channel userlist */
	struct sMember *nextc; /* next chan, in a user's chan list */
	aClient *cptr;
	aChannel *chptr;
	u_int16_t flags;
	u_int16_t msg1, msg2; /* hashes of the last 2 messages sent */
	u_char repeats; /* number of consecutive "identical" messages */
	u_int32_t since; /* timestamp (tenths of seconds) for flood ctrl */
};

struct	SBan
{
	struct	SBan	*next;
	time_t when;
	char *who;
	char *banhost;
	char *banuser;
	char banstr[0];
};

struct sHush
{
	time_t end;
	char s[0];
};

/* channel structure */

struct Channel
{
	struct	Channel *nextch, *prevch, *hnext;
	Mode	mode;
	time_t	channelts;
	char	topic[TOPICLEN+1];
	char	topic_nick[NICKLEN+1];
	time_t	topic_time;
	int	users;
	Member	*members;
	Member	**lmembers; /* local members */
	Link	*invites;
	Ban	*banlist;
	char	chname[CHANNELLEN+1];
};

/*
** Channel Related macros follow
*/

/* Channel related flags */

#define	CHFL_CHANOP     0x0001 /* Channel operator */
#define	CHFL_VOICE      0x0002 /* the power to speak */

#ifdef HALFOPS
#define CHFL_HALFOP	0x0004 /* Restricted operator */
#define	CHFL_OVERLAP	(CHFL_CHANOP|CHFL_VOICE|CHFL_HALFOP)
#else
#define CHFL_HALFOP	0
#define	CHFL_OVERLAP    (CHFL_CHANOP|CHFL_VOICE)
#endif

#define	CHFL_BAN	0x0040 /* ban channel flag */
#define CHFL_UNBAN	0x0080 /* unbanned */
#define CHFL_BANSET	(CHFL_BAN|CHFL_UNBAN)

/* Channel Visibility macros */
 
#define	MODE_PRIVATE	 0x0001
#define	MODE_SECRET	 0x0002
#define	MODE_MODERATED   0x0004
#define	MODE_TOPICLIMIT  0x0008
#define	MODE_INVITEONLY  0x0010
#define	MODE_NOPRIVMSGS  0x0020
#define MODE_RGSTR	 0x0040
#define MODE_RGSTRONLY   0x0080
#define	MODE_STRIPCOLOR	 0x0100
#define	MODE_PRIVMSGONLY 0x0200
#define MODE_NODCCS      0x0400

#define	MODE_BAN	 0x10000000
#define	MODE_STRPARAM	 0x20000000
#define	MODE_INTPARAM	 0x40000000
#define	MODE_MEMBER	 0x80000000
#define	MODE_CLEAR       0

#define	MODE_WPARAS	(MODE_MEMBER|MODE_INTPARAM|MODE_STRPARAM|MODE_BAN)
#define	MODE_SIMPLE	(~(MODE_WPARAS))


/* name invisible */
#define	SecretChannel(x)	(((x)->mode.mode & MODE_SECRET))
/* channel not shown in /whois but shown in list */
#define	HiddenChannel(x)	(((x)->mode.mode & MODE_PRIVATE))
/* channel visible */
#define	ShowChannel(v,c)	(PubChannel(c) || IsMember((v),(c)))
#define	PubChannel(x)		(((x)->mode.mode &\
				 (MODE_PRIVATE | MODE_SECRET)) == 0)

#define	IsMember(u,c)		((int)find_member(c,u))

#define	IsChannelName(name)	((name) && (*(name) == '#'))

/* Misc macros */

#define	BadPtr(x) (!(x) || (*(x) == '\0'))

#define	isvalid(c) (((c) >= 'A' && (c) < '~') || isdigit(c) || (c) == '-')

#define	MyConnect(x)			((x)->fd >= 0)
#define	MyClient(x)			(IsClient(x->from))
#define	MyOper(x)			(IsOper(x->from))

/* Lifted somewhat from Undernet code --Rak */

#define IsSendable(x)		(DBufLength(&x->sendQ) < 2048)
#define DoList(x)		((x)->lopt)

/* String manipulation macros */

/* strncopynt --> strncpyzt to avoid confusion, sematics changed
   N must be now the number of bytes in the array --msa */
#define	strncpyzt(x, y, N) do{(void)strncpy(x,y,N);x[N-1]='\0';}while(0)
#define	strncatzt(x, y, N) do{(void)strncat(x,y,N);x[N-1]='\0';}while(0)
#define	StrEq(x,y)	(!strcmp((x),(y)))

/* return values for hunt_server() */

#define	HUNTED_NOSUCH	(-1)	/* if the hunted server is not found */
#define	HUNTED_ISME	0	/* if this server should execute the command */
#define	HUNTED_PASS	1	/* if message passed onwards successfully */

/* used when sending to #mask or $mask */

#define	MATCH_SERVER  1
#define	MATCH_HOST    2

/* used for async dns values */

#define	ASYNC_NONE	(-1)
#define	ASYNC_CLIENT	0
#define	ASYNC_CONNECT	1
#define	ASYNC_CONF	2
#define	ASYNC_SERVER	3

/* misc variable externs */

extern	char	*version, *infotext[], *contribtext[];
extern	char	*generation, *creation;

/* misc defines */

#define	FLUSH_BUFFER	-2
#define	UTMP		"/etc/utmp"
#define	COMMA		","

#include "alloc.h"

#endif /* __struct_include__ */
