/*
 *   Forks Internet Relay Chat Daemon, src/modules/m_helplogin.c
 *   (C) 2009 Forks Project Team
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef _WIN32
#include <io.h>
#endif
#include <fcntl.h>
#include "h.h"
#include "proto.h"
#include "inet.h"
#ifdef STRIPBADWORDS
#include "badwords.h"
#endif
#ifdef _WIN32
#include "version.h"
#endif

DLLFUNC int m_helplogin(aClient *cptr, aClient *sptr, int parc, char *parv[]);


/* Place includes here */
#define MSG_HELPLOGIN        "HELPLOGIN"  /* OPER */
#define TOK_HELPLOGIN        "$;"     /* 59 */

typedef struct helper_hflag_ {
	int flag;
	long* umode;	/* you just HAD to make them variables */
	char** host;
	char* announce;
} helper_table;

static helper_table helper_hflags[10];

static void init_helperflags()
{
	helper_hflags[0].flag = HFLAG_SENIOR;
	helper_hflags[0].umode = &UMODE_HELPER;
	helper_hflags[0].host = &senior_help_host;
	helper_hflags[0].announce = "is now a Senior HelpStaff Operator (S)";
	helper_hflags[1].flag = HFLAG_LEADER;
	helper_hflags[1].umode = &UMODE_HELPER;
	helper_hflags[1].host = &leader_help_host;
	helper_hflags[1].announce = "is now a HelpStaff Leader (L)";
	helper_hflags[2].flag = HFLAG_LEVEL2;
	helper_hflags[2].umode = &UMODE_HELPER;
	helper_hflags[2].host = &supv_help_host;
	helper_hflags[2].announce = "is now a Level 2 HelpStaff Operator (H)";
	helper_hflags[3].flag = HFLAG_HELPER;
	helper_hflags[3].umode = &UMODE_HELPER;
	helper_hflags[3].host = &staff_help_host;
	helper_hflags[3].announce = "is now a HelpStaff Member Operator (h)";
	helper_hflags[4].flag = 0;
	helper_hflags[4].umode = NULL;
	helper_hflags[4].host = NULL;
	helper_hflags[4].announce = NULL;
}


ModuleHeader MOD_HEADER(m_helplogin)
  = {
	"helplogin",	/* Name of module */
	"$Id: m_helplogin.c,v 1.0.1 2009/09/10 10:06:37 Sephiroth Exp $", /* Version */
	"command /helplogin", /* Short description of module */
	"3.2-b8-1",
	NULL
    };

/* This is called on module init, before Server Ready */
DLLFUNC int MOD_INIT(m_helplogin)(ModuleInfo *modinfo)
{
	/*
	 * We call our add_Command crap here
	*/
	add_Command(MSG_HELPLOGIN, TOK_HELPLOGIN, m_helplogin, MAXPARA);
	MARK_AS_OFFICIAL_MODULE(modinfo);
	return MOD_SUCCESS;
}

/* Is first run when server is 100% ready */
DLLFUNC int MOD_LOAD(m_helplogin)(int module_load)
{
	init_helperflags();
	return MOD_SUCCESS;
}

/* Called when module is unloaded */
DLLFUNC int MOD_UNLOAD(m_helplogin)(int module_unload)
{
	if (del_Command(MSG_HELPLOGIN, TOK_HELPLOGIN, m_helplogin) < 0)
	{
		sendto_realops("Failed to delete commands when unloading %s",
				MOD_HEADER(m_helplogin).name);
	}
	return MOD_SUCCESS;
}


/*
** m_helplogin
**	parv[0] = sender prefix
**	parv[1] = oper name
**	parv[2] = oper password
*/

DLLFUNC int  m_helplogin(aClient *cptr, aClient *sptr, int parc, char *parv[]) {
	ConfigItem_helper *aconf;
	ConfigItem_helper_from *helper_from;
	char *name, *password, nuhhost[NICKLEN+USERLEN+HOSTLEN+6], nuhhost2[NICKLEN+USERLEN+HOSTLEN+6];
	char* host = 0;
	int i = 0, j = 0;
	char* announce = 0;

	if (!MyClient(sptr))
		return 0;

	if (parc < 3) {
		sendto_one(sptr, err_str(ERR_NEEDMOREPARAMS),
		    me.name, parv[0], "HELPLOGIN");
		return 0;
	}

	if (SVSNOOP) {
		sendto_one(sptr,
		    ":%s %s %s :*** This server is in NOOP mode, you cannot /helplogin",
		    me.name, IsWebTV(sptr) ? "PRIVMSG" : "NOTICE", sptr->name);
		return 0;
	}

	if (IsHelpOper(sptr)) {
		sendto_one(sptr, ":%s 381 %s :HelpStaff Login Successful", me.name, parv[0]);
		return 0;
	}

	name = parv[1];
	password = parv[2];

	if (!(aconf = Find_helper(name))) {
		sendto_one(sptr, ":%s 491 %s :No W-lines for your host", me.name, parv[0]);
		sendto_snomask_global
		    (SNO_OPER, "Failed HELPLOGIN attempt by %s (%s@%s) [unknown helper]",
		    parv[0], sptr->user->username, sptr->sockhost);
		ircd_log(LOG_OPER, "HELPLOGIN UNKNOWNHELPER (%s) by (%s!%s@%s)", name, parv[0],
			sptr->user->username, sptr->sockhost);
		sptr->since += 7;
		return 0;
	}
	strlcpy(nuhhost, make_user_host(sptr->user->username, sptr->user->realhost), sizeof(nuhhost));
	strlcpy(nuhhost2, make_user_host(sptr->user->username, Inet_ia2p(&sptr->ip)), sizeof(nuhhost2));
	for (helper_from = (ConfigItem_helper_from *) aconf->from;
	    helper_from; helper_from = (ConfigItem_helper_from *) helper_from->next)
		if (match_ip(sptr->ip, nuhhost, helper_from->name, helper_from->netmask) ||
		    !match(helper_from->name, nuhhost2))
			break;
	if (!helper_from)	{
		sendto_one(sptr, ":%s 491 %s :No W-lines for your host", me.name, parv[0]);
		sendto_snomask_global
		    (SNO_OPER, "Failed HELPLOGIN attempt by %s (%s@%s) using UID %s [host doesnt match]",
		    parv[0], sptr->user->username, sptr->sockhost, name);
		ircd_log(LOG_OPER, "HELPLOGIN NOHOSTMATCH (%s) by (%s!%s@%s)", name, parv[0],
			sptr->user->username, sptr->sockhost);
		sptr->since += 7;
		return 0;
	}

	i = Auth_Check(cptr, aconf->auth, password);
	if (i > 1)
	{
		int  old = (sptr->umodes & ALL_UMODES);

		//Maybe, put a helper version here? --Sephiroth
		/*
		if (sptr->user->operlogin)
			MyFree(sptr->user->operlogin);
		sptr->user->operlogin = strdup(aconf->name); */

		sptr->hflag = 0;
		if (aconf->swhois) {
			if (sptr->user->swhois)
				MyFree(sptr->user->swhois);
			sptr->user->swhois = MyMalloc(strlen(aconf->swhois) +1);
			strcpy(sptr->user->swhois, aconf->swhois);
			sendto_serv_butone_token(cptr, me.name,
				MSG_SWHOIS, TOK_SWHOIS, "%s :%s", sptr->name, aconf->swhois);
		}

/* handle oflags that trigger umodes */

		while(helper_hflags[j].umode) {
			if(aconf->flags & helper_hflags[j].flag) {	/* we match this oflag */
				if (!announce && helper_hflags[j].announce) { /* we haven't matched an oper_type yet */
					host = *helper_hflags[j].host;	/* set the iNAH host */
					announce = helper_hflags[j].announce; /* set the announcement */
				}
				sptr->umodes |=
					*helper_hflags[j].umode; /* add the umode for this oflag */
			}
			j++;
		}

		sptr->hflag = aconf->flags;
		sptr->user->snomask |= SNO_SNOTICE; /* set +s if needed */
		sptr->umodes |= UMODE_SERVNOTICE;


		send_umode_out(cptr, sptr, old);
		sendto_one(sptr, rpl_str(RPL_SNOMASK),
			me.name, parv[0], get_sno_str(sptr));

#ifndef NO_FDLIST
		addto_fdlist(sptr->slot, &helper_fdlist);
#endif
		sendto_one(sptr, ":%s 381 %s :HelpStaff Login Successful", me.name, parv[0]);
		if (IsInvisible(sptr) && !(old & UMODE_INVISIBLE))
			IRCstats.invisible++;

		ircd_log(LOG_OPER, "HELPLOGIN (%s) by (%s!%s@%s)", name, parv[0], sptr->user->username,
			sptr->sockhost);

	}
	if (i == -1)
	{
		sendto_one(sptr, err_str(ERR_PASSWDMISMATCH), me.name, parv[0]);
		if (FAILOPER_WARN)
			sendto_one(sptr,
			    ":%s %s %s :*** Your attempt has been logged.", me.name,
			    IsWebTV(sptr) ? "PRIVMSG" : "NOTICE", sptr->name);
		ircd_log(LOG_OPER, "HELPLOGIN FAILEDAUTH (%s) by (%s!%s@%s)", name, parv[0],
			sptr->user->username, sptr->sockhost);
		sendto_snomask_global
		    (SNO_OPER, "Failed HELPLOGIN attempt by %s (%s@%s) using UID %s [FAILEDAUTH]",
		    parv[0], sptr->user->username, sptr->sockhost, name);
		sptr->since += 7;
	}
	/* Belay that order, number One. (-2) */
	return 0;
}
