;ignitionServer is (C) Keith Gable and Contributors
;----------------------------------------------------
;You must include this notice in any modifications you make. You must additionally
;follow the GPL's provisions for sourcecode distribution and binary distribution.
;If you are not familiar with the GPL, please read LICENSE.TXT.
;(you are welcome to add a "Based On" line above this notice, but this notice must
;remain intact!)
;Released under the GNU General Public License
;
;Contact information: Keith Gable (Ziggy) <ziggy@ignition-project.com>
;Contributors:        Nigel Jones (DigiGuy) <digi_guy@users.sourceforge.net>
;                     Reid Burke  (Airwalk) <airwalk@ignition-project.com>

; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
SetCompressor lzma
!define PRODUCT_NAME "ignitionServer"
!define PRODUCT_VERSION "0.3.6-P1"
!define PRODUCT_VERSION_MAJOR "0"
!define PRODUCT_VERSION_MINOR "3"
!define PRODUCT_VERSION_REVISION "6"
!define PRODUCT_PUBLISHER "The Ignition Project"
!define PRODUCT_WEB_SITE "http://www.ignition-project.com/"
!define PRODUCT_DOCUMENTATION "http://www.ignition-project.com/ignition/server/docs/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\ignitionServer.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "installer.ico"
!define MUI_UNICON "installer.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "wizard.bmp"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "header.bmp"
!define MUI_HEADERIMAGE_RIGHT

; Welcome page
!define MUI_WELCOMEPAGE_TEXT "This wizard will guide you through the installation of ${PRODUCT_NAME} ${PRODUCT_VERSION}, an open source IRCX server for Windows.\r\n\r\nPlease make sure that ${PRODUCT_NAME} is not running (Ctrl+Alt+Delete). If you use the monitor, also make sure it is not running.\r\n\r\nWARNING: If you are upgrading, your configuration files will be overwritten. Please back them up in a safe place before continuing!\r\n\r\nPress Next to continue."
!insertmacro MUI_PAGE_WELCOME

; License page
!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "..\docs\license.rtf"

; Directory page
!insertmacro MUI_PAGE_DIRECTORY

; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "ignitionServer"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP

; Components Page
!insertmacro MUI_PAGE_COMPONENTS

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\docs\readme.rtf"
!define MUI_FINISHPAGE_NOREBOOTSUPPORT
!define MUI_FINISHPAGE_LINK "The Ignition Project Homepage"
!define MUI_FINISHPAGE_LINK_LOCATION "${PRODUCT_WEB_SITE}"
!define MUI_FINISHPAGE_TEXT "${PRODUCT_NAME} ${PRODUCT_VERSION} has been installed on your computer. Before running ${PRODUCT_NAME}, please read the readme.\r\n\r\nClick Finish to close this wizard."
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Language Stuff
LangString DESC_SEC01 ${LANG_ENGLISH} "Install ignitionServer Core Components"
LangString DESC_SEC02 ${LANG_ENGLISH} "Install ignitionServer Monitor (all versions of Windows)"
LangString DESC_SEC03 ${LANG_ENGLISH} "Install ignitionServer PassCrypt for ease in encrypting passwords"
LangString DESC_SEC04 ${LANG_ENGLISH} "Install the IRCXpro Migration Wizard, to easily convert your IRCXpro settings to settings compatible with ignitionServer"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup.exe"
InstallDir "$PROGRAMFILES\ignitionServer"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show
BrandingText "${PRODUCT_NAME} ${PRODUCT_VERSION} Installer" ; how about something a little less weird sounding? :P

Section -"Core" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite on
  File "..\ignitionServer.exe"
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\ignitionServer (Daemon Mode).lnk" "$INSTDIR\ignitionServer.exe"
  File "..\changelog.txt"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Changes.lnk" "$INSTDIR\changelog.txt"
  File "..\control.exe"
  ; really need to ask for this stuff.
  SetOverwrite ifnewer
  File "..\ircx.conf"
  File "..\ircx.motd"
  SetOverwrite on
  ; Overwrite the docs stuff
  ; We do update them occasionally.
  SetOutPath "$INSTDIR\docs"
  File "..\docs\credits.txt"
  File "..\docs\license.html"
  File "..\docs\license.rtf"
  File "..\docs\license.txt"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\GNU General Public License.lnk" "$INSTDIR\docs\license.txt"
  File "..\docs\readme.rtf"
  File "..\docs\readme.txt"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Read Me First!.lnk" "$INSTDIR\docs\readme.txt"
  File "..\docs\releasenotes.txt"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Release Notes.lnk" "$INSTDIR\docs\releasenotes.txt"
SectionEnd

Section "Monitor" SEC02
  SetOutPath "$INSTDIR"
  SetOverwrite on
  File "..\monitor.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\ignitionServer.lnk" "$INSTDIR\monitor.exe"
SectionEnd

Section "PassCrypt" SEC03
  SetOutPath "$INSTDIR"
  SetOverwrite on
  File "..\PassCrypt.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\ignitionServer PassCrypt.lnk" "$INSTDIR\PassCrypt.exe"
SectionEnd

Section "IRCXpro Migration Wizard" SEC04
  SetOutPath "$INSTDIR"
  SetOverwrite on
  File "..\migwiz.exe"
  File "..\migwiz.cftpl"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\IRCXpro Migration Wizard.lnk" "$INSTDIR\migwiz.exe"
SectionEnd

Section -AdditionalIcons
  SetOverwrite on
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  WriteIniStr "$INSTDIR\Documentation.url" "InternetShortcut" "URL" "${PRODUCT_DOCUMENTATION}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\The Ignition Project.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk" "$INSTDIR\Documentation.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\Uninstall.exe"
SectionEnd

Section -Post
  SetOverwrite on
  WriteUninstaller "$INSTDIR\Uninstall.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\ignitionServer.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstallLocation" "$INSTDIR"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\ignitionServer.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "${PRODUCT_STARTMENU_REGVAL}" "$ICONS_GROUP"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLUpdateInfo" "http://www.ignition-project.com/ignition/server/"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "HelpLink" "http://www.ignition-project.com/forum/"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionMajor" "${PRODUCT_VERSION_MAJOR}"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionMinor" "${PRODUCT_VERSION_MINOR}"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionRevision" "${PRODUCT_VERSION_REVISION}" ; in case of future Windows updates :P
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "NoModify" "1"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "NoRepair" "1"
SectionEnd

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SEC01} $(DESC_SEC01)
!insertmacro MUI_DESCRIPTION_TEXT ${SEC02} $(DESC_SEC02)
!insertmacro MUI_DESCRIPTION_TEXT ${SEC03} $(DESC_SEC03)
!insertmacro MUI_DESCRIPTION_TEXT ${SEC04} $(DESC_SEC04)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  ReadRegStr $ICONS_GROUP ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "${PRODUCT_STARTMENU_REGVAL}"
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\Documentation.url"
  Delete "$INSTDIR\Uninstall.exe"
  Delete "$INSTDIR\PassCrypt.exe"
  Delete "$INSTDIR\monitor.exe"
  Delete "$INSTDIR\docs\releasenotes.txt"
  Delete "$INSTDIR\docs\readme.txt"
  Delete "$INSTDIR\docs\readme.rtf"
  Delete "$INSTDIR\docs\license.txt"
  Delete "$INSTDIR\docs\license.rtf"
  Delete "$INSTDIR\docs\license.html"
  Delete "$INSTDIR\docs\credits.txt"
  Delete "$INSTDIR\ircx.motd"
  Delete "$INSTDIR\ircx.conf"
  Delete "$INSTDIR\changelog.txt"
  Delete "$INSTDIR\ignitionServer.exe"
  Delete "$INSTDIR\control.exe"
  Delete "$INSTDIR\control.log"
  Delete "$INSTDIR\migwiz.cftpl"
  Delete "$INSTDIR\migwiz.exe"
  Delete "$INSTDIR\errorlog.txt" ; delete the error log
  Delete "$INSTDIR\ircx.log" ; delete any debug logs
  
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\The Ignition Project.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\ignitionServer PassCrypt.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\ignitionServer.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Release Notes.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Read Me First!.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\GNU General Public License.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Changes.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\ignitionServer (Daemon Mode).lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\IRCXpro Migration Wizard.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR\logs"
  RMDir "$INSTDIR\docs"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
