/*
 *   IRC - Internet Relay Chat, include/config.h
 *   Copyright (C) 1990 Jarkko Oikarinen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	CONFIG_H
#define	CONFIG_H

#include "setup.h"

/* Type of host. These should be made redundant somehow. -avalon */

/*      BSD                     Nothing needed 4.{2,3} BSD, SunOS 3.x, 4.x */
/*	SOL2			Nothing needed Solaris2.{4,5} */
/*      HPUX                    Nothing needed (A.08/A.09) */
/*      ULTRIX                  Nothing needed (4.2) */
/*      OSF                     Nothing needed (1.2) */
/*      SGI                     Nothing needed (IRIX 4.0.4) */
#undef	AIX			/* IBM ugly so-called Unix, AIX */
#undef	MIPS			/* MIPS Unix */
#undef 	SVR3			/* SVR3 stuff - being worked on where poss. */
#undef	DYNIXPTX		/* Sequents Brain-dead Posix implement. */
#undef	ESIX			/* ESIX */
#undef	NEXT			/* NeXTStep */

/*
 * NOTE: It is important to set this to the correct "domain" for your server.
 * Define this for the correct "domain" that your server is in.  This
 * is important for certain stats.  -mlv
 */

#define DOMAINNAME "iastate.edu"

/* Random Number Generator Seed
 *
 * Set this to an 8-character random text string.
 * Do not use the default text.
 * If people are able to defeat the IP-spoofing protection on your
 * server, consider changing the value and recompiling.
 */

#define RANDOM_SEED "12345678"

/*
 * Define this if you'd like to run two or more servers on the same port
 * of one machine, using IP aliasing. --Jamey
 *                  
 */

#undef VIRTUAL_HOST

/*
 * Clonebot Protection
 * This feature blocks connections if more than CHECK_CLONE_LIMIT
 * clients connect from the same host to ANY server on the network within
 * CHECK_CLONE_PERIOD seconds.
 * 
 * The feature is enabled CHECK_CLONE_DELAY seconds after the server
 * is started.
 *
 * Servers that do routing only, that carry few clients, or have ONE in 
 * ALL their I-lines can disable this feature and save some CPU.
 * If you're not certain, leave this feature enabled.
 */

#define CHECK_CLONE
#define CHECK_CLONE_LIMIT     2	/* recommended value 2   */
#define CHECK_CLONE_PERIOD   20	/* recommended value 20  */
#define CHECK_CLONE_DELAY    90	/* 90 secs should be ok */

/*
 * Nick flood limit
 * Minimum time between nick changes.
 * (The first two changes are allowed quickly after another however).
 *
 * Define NICK_DELAY if you want this feature.
 */

#define NICK_DELAY 30		/* recommended value 30 */

/*
 * Default LIST command parameters.
 * Undefine if you like having your server flooded by mIRC users.
 */

#define DEFAULT_LIST_PARAM	"T<10"

/*
 * Define this if you wish to output a *file* to a K lined client rather
 * than the K line comment (the comment field is treated as a filename)
 */

#undef	COMMENT_IS_FILE

#undef	PCS			/* PCS Cadmus MUNIX, use with BSD flag! */

/*
 * NOTE: On some systems, valloc() causes many problems.
 */
#undef	VALLOC			/* Define this if you have valloc(3) */

#ifdef APOLLO
#define	RESTARTING_SYSTEMCALLS
#endif /* read/write are restarted after signals
        * defining this 1, gets siginterrupt call
        * compiled, which attempts to remove this
        * behaviour (apollo sr10.1/bsd4.3 needs
        * this) */

/*
 * Define this if you want to find an existing bug.
 * It makes your server EAT cpu time though...
 * NEVER define this unless you are debugging a reproducable problem
 * under test circumstances.
 */
#undef	DEBUGMODE		/* define DEBUGMODE to enable debugging mode. */

/*
 * defining FORCE_CORE will automatically "unlimit core", forcing the
 * server to dump a core file whenever it has a fatal error.  -mlv
 */

#define FORCE_CORE

/* 
 * NPATH is path to backup file for NOTE.
 */
/* #define NPATH "/usr/lib/irc/.ircdnote" */

/*
 * Full pathnames and defaults of irc system's support files. Please note that
 * these are only the recommened names and paths. Change as needed.
 * You must define these to something, even if you don't really want them.
 */
#define	DPATH	"/usr/local/lib/ircd"	/* dir where all ircd stuff is */
#define	SPATH	"/usr/local/bin/ircd"	/* path to server executeable */
#define	CPATH	"ircd.conf"	/* server configuration file */
#define	MPATH	"ircd.motd"	/* server MOTD file */
#define	LPATH	"/tmp/ircd.log"	/* Where the debug file lives, if DEBUGMODE */
#define	PPATH	"ircd.pid"	/* file for server pid */

/* Define this if you want to keep a log of all G-lines that have been added
 * and the changes that are made by U-lined servers or local operators.  Do
 * this; you can simply append this log to your ircd.conf to add the G-lines
 * as K-lines!
 */
#define GPATH	"gline.log"

/*
 * Define this filename to maintain a list of persons who log
 * into this server. Logging will stop when the file does not exist.
 * Logging will be disable also if you do not define this.
 * FNAME_USERLOG just logs user connections, FNAME_OPERLOG logs every
 * successful use of /oper.  These are either full paths or files within DPATH.
 */
/* #define FNAME_USERLOG "/usr/local/lib/ircd/users" */
/* #define FNAME_OPERLOG "/usr/local/lib/ircd/opers" */

/* CHROOTDIR
 *
 * Define for value added security if you are a rooter.
 *
 * All files you access must be in the directory you define as DPATH.
 * (This may effect the PATH locations above, though you can symlink it)
 *
 * You may want to define IRC_UID and IRC_GID
 */
#undef CHROOTDIR

/* RELIABLE_CLOCK
 *
 * Define this if your host has an externally controlled system clock,
 * like running xntp.
 * If nobody defines this, it still works: The clock will be used of the
 * server that was started first.
 */
#undef RELIABLE_CLOCK

/* SHOW_ALL_INVISIBLE_USERS
 *
 * If this is defined operators on your server will see *ALL* +i users on the
 * net. This can be advantagous when tracking clones. (Chaos)
 * Only O:'s are affected, for o:'s (local operators) invisible users on
 * other servers still have their privacy... -- Niels
 */
#define SHOW_ALL_INVISIBLE_USERS

/* OPER_KILL
 *
 * If you dont believe operators should be allowed to use the /KILL command
 * or believe it is uncessary for them to use it, then leave OPER_KILL
 * undefined. This will not affect other operators or servers issuing KILL
 * commands however.  OPER_REHASH and OPER_RESTART allow operators to
 * issue the REHASH and RESTART commands when connected to your server.
 * Left undefined they increase the security of your server from wayward
 * operators and accidents.  Defining OPER_REMOTE removes the restriction
 * that O-lines only become fully effective for people on the 'same network'
 * as the server.  Undefined, it increases the secrity of the server by
 * placing restrictions on where people can use operator powers from.
 * The 'LOCOP_' #defines are for making the respective commands available
 * to 'local' operators.
 */
#define	OPER_KILL
#define	OPER_REHASH
#define	OPER_RESTART
#define	OPER_DIE
#define	OPER_REMOTE
#define	LOCOP_REHASH
#undef	LOCOP_RESTART
#undef	LOCOP_DIE

/* MAXIMUM LINKS
 *
 * This define is useful for leaf nodes and gateways. It keeps you from
 * connecting to too many places. It works by keeping you from
 * connecting to more than "n" nodes which you have C:blah::blah:6667
 * lines for.
 *
 * Note that any number of nodes can still connect to you. This only
 * limits the number that you actively reach out to connect to.
 *
 * Leaf nodes are nodes which are on the edge of the tree. If you want
 * to have a backup link, then sometimes you end up connected to both
 * your primary and backup, routing traffic between them. To prevent
 * this, #define MAXIMUM_LINKS 1 and set up both primary and
 * secondary with C:blah::blah:6667 lines. THEY SHOULD NOT TRY TO
 * CONNECT TO YOU, YOU SHOULD CONNECT TO THEM.
 *
 * Gateways such as the server which connects Australia to the US can
 * do a similar thing. Put the American nodes you want to connect to
 * in with C:blah::blah:6667 lines, and the Australian nodes with
 * C:blah::blah lines. Have the Americans put you in with C:blah::blah
 * lines. Then you will only connect to one of the Americans.
 *
 * This value is only used if you don't have server classes defined, and
 * a server is in class 0 (the default class if none is set).
 *
 */
#define MAXIMUM_LINKS 1

/*
 * If your server is running as a a HUB Server then define this.
 * A HUB Server has many servers connect to it at the same as opposed
 * to a leaf which just has 1 server (typically the uplink). Define this
 * correctly for performance reasons.
 */
#undef	HUB

/* R_LINES:  The conf file now allows the existence of R lines, or
 * restrict lines.  These allow more freedom in the ability to restrict
 * who is to sign on and when.  What the R line does is call an outside
 * program which returns a reply indicating whether to let the person on.
 * Because there is another program involved, Delays and overhead could
 * result. It is for this reason that there is a line in config.h to
 * decide whether it is something you want or need. -Hoppie
 *
 * The default is no R_LINES as most people probably don't need it. --Jto
 */
#undef	R_LINES

#ifdef	R_LINES
/* Also, even if you have R lines defined, you might not want them to be 
 * checked everywhere, since it could cost lots of time and delay.  Therefore, 
 * The following two options are also offered:  R_LINES_REHASH rechecks for 
 * R lines after a rehash, and R_LINES_OFTEN, which rechecks it as often
 * as it does K lines.  Note that R_LINES_OFTEN is *very* likely to cause 
 * a resource drain, use at your own risk.  R_LINES_REHASH shouldn't be too
 * bad, assuming the programs are fairly short.
 */
#define R_LINES_REHASH
#define R_LINES_OFTEN
#endif

/*
 * NOTE: defining CMDLINE_CONFIG and installing ircd SUID or SGID is a MAJOR
 *       security problem - they can use the "-f" option to read any files
 *       that the 'new' access lets them. Note also that defining this is
 *       a major security hole if your ircd goes down and some other user
 *       starts up the server with a new conf file that has some extra
 *       O-lines. So don't use this unless you're debugging.
 */
#undef	CMDLINE_CONFIG		/* allow conf-file to be specified on command line */

/*
 * To use m4 as a preprocessor on the ircd.conf file, define M4_PREPROC.
 * The server will then call m4 each time it reads the ircd.conf file,
 * reading m4 output as the server's ircd.conf file.
 */
#undef	M4_PREPROC

/*
 * If you wish to have the server send 'vital' messages about server
 * through syslog, define USE_SYSLOG. Only system errors and events critical
 * to the server are logged although if this is defined with FNAME_USERLOG,
 * syslog() is used instead of the above file. It is not recommended that
 * this option is used unless you tell the system administrator beforehand
 * and obtain their permission to send messages to the system log files.
 */
#undef	USE_SYSLOG

#ifdef	USE_SYSLOG
/*
 * If you use syslog above, you may want to turn some (none) of the
 * spurious log messages for KILL/SQUIT off.
 */
#undef	SYSLOG_KILL		/* log all operator kills to syslog */
#undef	SYSLOG_SQUIT		/* log all remote squits for all servers to syslog */
#undef	SYSLOG_CONNECT		/* log remote connect messages for other all servs */
#undef	SYSLOG_USERS		/* send userlog stuff to syslog */
#undef	SYSLOG_OPER		/* log all users who successfully become an Op */

/*
 * If you want to log to a different facility than DAEMON, change
 * this define.
 */
#define LOG_FACILITY LOG_DAEMON
#endif /* USE_SYSLOG */

/*
 * define this if you want to use crypted passwords for operators in your
 * ircd.conf file. See ircd/crypt/README for more details on this.
 */
#define	CRYPT_OPER_PASSWORD

/*
 * If you want to store encrypted passwords in N-lines for server links,
 * define this.  For a C/N pair in your ircd.conf file, the password
 * need not be the same for both, as long as hte opposite end has the
 * right password in the opposite line.  See INSTALL doc for more details.
 */
#undef	CRYPT_LINK_PASSWORD

/*
 * IDLE_FROM_MSG
 *
 * Idle-time nullified only from privmsg, if undefined idle-time
 * is nullified from everything except ping/pong.
 * Added 3.8.1992, kny@cs.hut.fi (nam)
 */
#define IDLE_FROM_MSG

/*
 * Max amount of internal send buffering when socket is stuck (bytes)
 */
#define MAXSENDQLENGTH 2000000	/* Recommended value: 300000 for leaves    */
				  /*                   2000000 for backbones */
/*
 *  BUFFERPOOL is the maximum size of the total of all sendq's.
 *  Recommended value is leaves: 3 * MAXSENDQLENGTH, for hubs: 5 - 7 *.
 */
#define	BUFFERPOOL     (6 * MAXSENDQLENGTH)

/*
 * use these to setup a Unix domain socket to connect clients/servers to.
 */
#define	UNIXPORT

/*
 * IRC_UID
 *
 * If you start the server as root but wish to have it run as another user,
 * define IRC_UID to that UID.  This should only be defined if you are running
 * as root and even then perhaps not.
 */
#undef	IRC_UID
#undef	IRC_GID

#ifdef	notdef
#define	IRC_UID	65534		/* eg for what to do to enable this feature */
#define	IRC_GID	65534
#endif

/*
 * CLIENT_FLOOD
 *
 * this controls the number of bytes the server will allow a client to
 * send to the server without processing before disconnecting the client for
 * flooding it.  Values greater than 8000 make no difference to the server.
 */
#define	CLIENT_FLOOD	1024

/*   STOP STOP STOP STOP STOP STOP STOP STOP STOP STOP STOP STOP STOP STOP  */

/* You shouldn't change anything below this line, unless absolutely needed. */

#ifdef	OPER_KILL
/* LOCAL_KILL_ONLY
 *
 * To be used, OPER_KILL must be defined.
 * LOCAL_KILL_ONLY restricts KILLs to clients which are connected to the
 * server the Operator is connected to (ie lets them deal with local
 * problem users or 'ghost' clients
 *
 * NOTE: #define'ing this on an IRC net with servers which have a version
 *       earlier than 2.7 is prohibited.  Such an action and subsequent use
 *       of KILL for non-local clients should be punished by removal of the
 *       server's links (if only for ignoring this warning!).
 */
#undef	LOCAL_KILL_ONLY
#endif
/*
 * Port where ircd resides. NOTE: This *MUST* be greater than 1024 if you
 * plan to run ircd under any other uid than root.
 */
#define PORTNUM 6667		/* Recommended values: 6667 or 6666 */

/*
 * Maximum number of network connections your server will allow.  This should
 * never exceed maximum number of open file descriptors and won't increase it.
 * This should be at *least* 23: see MAXCLIENTS.
 * The default value below assumes that your server has actually as many
 * clients as it can have file descriptors.
 */
#define MAXCONNECTIONS (FD_SETSIZE - 4)

/*
 * this defines the length of the nickname history.  each time a user changes
 * nickname or signs off, their old nickname is added to the top of the list.
 * The following sizes are recommended:
 * 8MB or less  core memory : 500       (at least 1/4 of max users)
 * 8MB-16MB     core memory : 500-750   (1/4 -> 1/2 of max users)
 * 16MB-32MB    core memory : 750-1000  (1/2 -> 3/4 of max users)
 * 32MB or more core memory : 1000+     (> 3/4 if max users)
 * where max users is the expected maximum number of users.
 * (100 nicks/users ~ 25k)
 * NOTE: this is directly related to the amount of memory ircd will use whilst
 *       resident and running - it hardly ever gets swapped to disk! You can
 *       ignore these recommendations- they only are meant to serve as a guide
 */
#define NICKNAMEHISTORYLENGTH 800

/*
 * Time interval to wait and if no messages have been received, then check for
 * PINGFREQUENCY and CONNECTFREQUENCY 
 */
#define TIMESEC  60		/* Recommended value: 60 */

/*
 * If daemon doesn't receive anything from any of its links within
 * PINGFREQUENCY seconds, then the server will attempt to check for
 * an active link with a PING message. If no reply is received within
 * (PINGFREQUENCY * 2) seconds, then the connection will be closed.
 */
#define PINGFREQUENCY    120	/* Recommended value: 120 */

/*
 * If the connection to to uphost is down, then attempt to reconnect every 
 * CONNECTFREQUENCY  seconds.
 */
#define CONNECTFREQUENCY 600	/* Recommended value: 600 */

/*
 * Often net breaks for a short time and it's useful to try to
 * establishing the same connection again faster than CONNECTFREQUENCY
 * would allow. But, to keep trying on bad connection, we require
 * that connection has been open for certain minimum time
 * (HANGONGOODLINK) and we give the net few seconds to steady
 * (HANGONRETRYDELAY). This latter has to be long enough that the
 * other end of the connection has time to notice it broke too.
 */
#define HANGONRETRYDELAY 10	/* Recommended value: 10 seconds */
#define HANGONGOODLINK 300	/* Recommended value: 5 minutes */

/*
 * Number of seconds to wait for write to complete if stuck.
 */
#define WRITEWAITDELAY     15	/* Recommended value: 15 */

/*
 * Number of seconds to wait for a connect(2) call to complete.
 * NOTE: this must be at *LEAST* 10.  When a client connects, it has
 * CONNECTTIMEOUT - 10 seconds for its host to respond to an ident lookup
 * query and for a DNS answer to be retrieved.
 * This value should consider the fact that users whose clients do not
 * support NOSPOOF will have to type /QUOTE PING <bignumber> before
 * registration.
 */
#define	CONNECTTIMEOUT	90	/* Recommended value: 90 */

/*
 * Max time from the nickname change that still causes KILL
 * automaticly to switch for the current nick of that user. (seconds)
 */
#define KILLCHASETIMELIMIT 90	/* Recommended value: 90 */

/*
 * Max number of channels a user is allowed to join.
 * Don't increase this please. With windows clients people are all to
 * easy idling in channels, if we allow them to sit in 10, they will
 * not reading it - but still using your bandwidth.
 */
#define MAXCHANNELSPERUSER  5	/* Recommended value: 5 */

/*
 * Max number of silences per user.  MAXSILELENGTH is the maximum total
 * length of silence masks; the first 2 is for the ! and the ~ (not fixed
 * elsewhere yet, but needs to be); the next 1 is for the @, and the last
 * 1 is for the terminating \0; this value is multiplied by the total number
 * of silences allowed per user.
 * When '40' is the average ban-mask length, then 40*MAXSILES is the expected
 * memory usage (per client) when they use MAXSILES silence masks.
 * We allow MAXSILES *average* lengths masks, so don't increase MAXSILELENGTH.
 */
#define	MAXSILES	15		/* Max. recommended value: 15 */
#define	MAXSILELENGTH	(40 * MAXSILES)	/* Don't change */

#endif /* CONFIG_H */
