/*
 *   IRC - Internet Relay Chat, include/dbuf.h
 *   Copyright (C) 1990 Markku Savela
 *   Copyright (C) 1996 Carlo Wood
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DBUF_H
#define DBUF_H

/*
 *  These structure definitions are only here to be used
 *  as a whole, *DO NOT EVER REFER TO THESE FIELDS INSIDE
 *  THE STRUCTURES*! It must be possible to change the internal
 *  implementation of this package without changing the
 *  interface.
 */

typedef struct dbuf {
  u_int length;                 /* Current number of bytes stored */
  u_int offset;                 /* Offset to the first byte */
  struct dbufbuf *head;         /* First data buffer, if length > 0 */
  /* added by mnystrom@mit.edu: */
  struct dbufbuf *tail;         /* last data buffer, if length > 0 */
} dbuf;

/*
 *  And this 'dbufbuf' should never be referenced outside the
 *  implementation of 'dbuf'--would be "hidden" if C had such
 *  keyword...
 *  If it was possible, this would compile to be exactly 1 memory
 *  page in size. 2048 bytes seems to be the most common size, so
 *  as long as a pointer is 4 bytes, we get 2032 bytes for buffer
 *  data after we take away a bit for malloc to play with. -avalon
 */
typedef struct dbufbuf
{
  struct dbufbuf *next;         /* Next data buffer, NULL if this is last */
  char data[2032];              /* Actual data stored here */
} dbufbuf;

/*=============================================================================
 * Macro's
 */

/*
 *  DBufLength
 *    Return the current number of bytes stored into the buffer.
 */
#define DBufLength(dyn) ((dyn)->length)

/*
 *  DBufClear
 *    Scratch the current content of the buffer. Release all
 *    allocated buffers and make it empty.
 */
#define DBufClear(dyn)	dbuf_delete((dyn), DBufLength(dyn))

/*=============================================================================
 * Proto types
 */

extern int dbuf_delete(dbuf * dyn, int length);
extern int dbuf_put(dbuf * dyn, char *buf, int length);
extern char *dbuf_map(dbuf * dyn, int *length);
extern int dbuf_get(dbuf * dyn, char *buf, int length);
extern int dbuf_getmsg(dbuf * dyn, char *buf, int length);

extern int dbufalloc, dbufblocks;

#endif /* DBUF_H */
