/*
 *   IRC - Internet Relay Chat, include/msg.h
 *   Copyright (C) 1990 Jarkko Oikarinen and
 *                      University of Oulu, Computing Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	MSG_H
#define MSG_H

/*=============================================================================
 * General defines
 */

#define MAXPARA    15

/*-----------------------------------------------------------------------------
 * Macro's
 */

/*
 * Tokenization:
 * Each command must have a TOK_COMMAND and MSG_COMMAND definition.
 * If you don't want one or the other, make them the same.
 */
#define MSG_PRIVATE  "PRIVMSG"	/* PRIV */
#define TOK_PRIVATE  "P"
#define MSG_WHO      "WHO"	/* WHO  -> WHOC */
#define TOK_WHO      "H"
#define MSG_WHOIS    "WHOIS"	/* WHOI */
#define TOK_WHOIS    "W"
#define MSG_WHOWAS   "WHOWAS"	/* WHOW */
#define TOK_WHOWAS   "X"
#define MSG_USER     "USER"	/* USER */
#define TOK_USER     "USER"
#define MSG_NICK     "NICK"	/* NICK */
#define TOK_NICK     "N"
#define MSG_SERVER   "SERVER"	/* SERV */
#define TOK_SERVER   "S"
#define MSG_LIST     "LIST"	/* LIST */
#define TOK_LIST     "LIST"
#define MSG_TOPIC    "TOPIC"	/* TOPI */
#define TOK_TOPIC    "T"
#define MSG_INVITE   "INVITE"	/* INVI */
#define TOK_INVITE   "I"
#define MSG_VERSION  "VERSION"	/* VERS */
#define TOK_VERSION  "V"
#define MSG_QUIT     "QUIT"	/* QUIT */
#define TOK_QUIT     "Q"
#define MSG_SQUIT    "SQUIT"	/* SQUI */
#define TOK_SQUIT    "SQ"
#define MSG_KILL     "KILL"	/* KILL */
#define TOK_KILL     "D"
#define MSG_INFO     "INFO"	/* INFO */
#define TOK_INFO     "F"
#define MSG_LINKS    "LINKS"	/* LINK */
#define TOK_LINKS    "LINKS"
#define MSG_STATS    "STATS"	/* STAT */
#define TOK_STATS    "R"
#define MSG_HELP     "HELP"	/* HELP */
#define TOK_HELP     "HELP"
#define MSG_ERROR    "ERROR"	/* ERRO */
#define TOK_ERROR    "Y"
#define MSG_AWAY     "AWAY"	/* AWAY */
#define TOK_AWAY     "A"
#define MSG_CONNECT  "CONNECT"	/* CONN */
#define TOK_CONNECT  "CN"
#define MSG_UPING    "UPING"	/* UPIN */
#define TOK_UPING    "UP"
#define MSG_MAP      "MAP"	/* MAP  */
#define TOK_MAP      "MAP"
#define MSG_PING     "PING"	/* PING */
#define TOK_PING     "G"
#define MSG_PONG     "PONG"	/* PONG */
#define TOK_PONG     "Z"
#define MSG_OPER     "OPER"	/* OPER */
#define TOK_OPER     "OPER"
#define MSG_PASS     "PASS"	/* PASS */
#define TOK_PASS     "PA"
#define MSG_WALLOPS  "WALLOPS"	/* WALL */
#define TOK_WALLOPS  "WA"
#define MSG_TIME     "TIME"	/* TIME */
#define TOK_TIME     "TI"
#define MSG_SETTIME  "SETTIME"	/* SETT */
#define TOK_SETTIME  "SE"
#define MSG_RPING    "RPING"	/* RPIN */
#define TOK_RPING    "RI"
#define MSG_RPONG    "RPONG"	/* RPON */
#define TOK_RPONG    "RO"
#define MSG_NAMES    "NAMES"	/* NAME */
#define TOK_NAMES    "E"
#define MSG_ADMIN    "ADMIN"	/* ADMI */
#define TOK_ADMIN    "AD"
#define MSG_TRACE    "TRACE"	/* TRAC */
#define TOK_TRACE    "TR"
#define MSG_NOTICE   "NOTICE"	/* NOTI */
#define TOK_NOTICE   "O"
#define MSG_JOIN     "JOIN"	/* JOIN */
#define TOK_JOIN     "J"
#define MSG_PART     "PART"	/* PART */
#define TOK_PART     "L"
#define MSG_LUSERS   "LUSERS"	/* LUSE */
#define TOK_LUSERS   "LUSERS"
#define MSG_MOTD     "MOTD"	/* MOTD */
#define TOK_MOTD     "MO"
#define MSG_MODE     "MODE"	/* MODE */
#define TOK_MODE     "M"
#define MSG_KICK     "KICK"	/* KICK */
#define TOK_KICK     "K"
#define MSG_SERVICE  "SERVICE"	/* SERV -> SRVI */
#define TOK_SERVICE  "SERVICE"
#define MSG_USERHOST "USERHOST"	/* USER -> USRH */
#define TOK_USERHOST "USERHOST"
#define MSG_ISON     "ISON"	/* ISON */
#define TOK_ISON     "ISON"
#define MSG_NOTE     "NOTE"	/* NOTE */
#define	TOK_NOTE     "NO"
#define MSG_SQUERY   "SQUERY"	/* SQUE */
#define TOK_SQUERY   "SQUERY"
#define MSG_SERVLIST "SERVLIST"	/* SERV -> SLIS */
#define TOK_SERVLIST "SERVSET"
#define MSG_SERVSET  "SERVSET"	/* SERV -> SSET */
#define TOK_SERVSET  "SERVSET"
#define	MSG_REHASH   "REHASH"	/* REHA */
#define TOK_REHASH   "REHASH"
#define	MSG_RESTART  "RESTART"	/* REST */
#define TOK_RESTART  "RESTART"
#define	MSG_CLOSE    "CLOSE"	/* CLOS */
#define TOK_CLOSE    "CLOSE"
#define MSG_DIE      "DIE"	/* DIE  */
#define TOK_DIE      "DIE"
#define	MSG_HASH     "HASH"	/* HASH */
#define TOK_HASH     "HASH"
#define	MSG_DNS      "DNS"	/* DNS  -> DNSS */
#define TOK_DNS      "DNS"
#define MSG_SILENCE  "SILENCE"	/* SILE */
#define TOK_SILENCE  "U"
#define MSG_GLINE    "GLINE"	/* GLIN */
#define TOK_GLINE    "GL"
#define MSG_BURST    "BURST"	/* BURS */
#define TOK_BURST    "B"
#define MSG_CREATE   "CREATE"	/* CREA */
#define TOK_CREATE   "C"
#define MSG_END_OF_BURST "END_OF_BURST"		/* END_ */
#define TOK_END_OF_BURST "EB"
#define MSG_END_OF_BOUNCE "END_OF_BOUNCE"	/* END_ */
#define TOK_END_OF_BOUNCE "EO"

/*=============================================================================
 * Structures
 */

struct Message {
  char *cmd;
  char *tok;
  int (*func) (aClient * cptr, aClient * sptr, int parc, char *parv[]);
    /* cptr = Connected client ptr
     * sptr = Source client ptr
     * parc = parameter count
     * parv = parameter variable array
     */
  unsigned int count;
  int parameters;
  char flags;
    /* bit 0 set means that this command is allowed to be used
     * only on the average of once per 2 seconds -SRB
     */
  unsigned long bytes;
};

/*=============================================================================
 * Proto types
 */

extern struct Message msgtab[];

#endif /* MSG_H */
