/*
 * runmalloc.h
 *
 * (C) Copyright 1996, Carlo Wood (carlo@runaway.xs4all.nl)
 *
 * Headerfile of runmalloc.c
 *
 */

#ifndef RUNMALLOC_H
#define RUNMALLOC_H

#ifdef DEBUGMALLOC

/*=============================================================================
 * Proto types
 */

extern unsigned int allocated;

extern void *RunMalloc(size_t size);
extern void *RunCalloc(size_t nmemb, size_t size);
extern int RunFree_test(void *ptr);
extern void RunFree(void *ptr);
extern void *RunRealloc(void *ptr, size_t size);
extern int report_malloc(void);

#else /* !DEBUGMALLOC */

#include <stdlib.h>

#define Debug_malloc(x)
#define RunMalloc(x) malloc(x)
#define RunCalloc(x,y) calloc(x,y)
#define RunRealloc(x,y) realloc(x,y)
#define RunFree(x) free(x)

#endif /* DEBUGMALLOC */

#endif /* RUNMALLOC_H */
