#ifndef S_BSD_H
#define S_BSD_H

#include <netdb.h>

/*=============================================================================
 * Macro's
 */

#define FLAGS_PINGSENT   0x0001 /* Unreplied ping sent */
#define FLAGS_DEADSOCKET 0x0002 /* Local socket is dead--Exiting soon */
#define FLAGS_KILLED     0x0004 /* Prevents "QUIT" from being sent for this */
#define FLAGS_OPER       0x0008 /* Operator */
#define FLAGS_LOCOP      0x0010 /* Local operator -- SRB */
#define FLAGS_INVISIBLE  0x0020 /* makes user invisible */
#define FLAGS_WALLOP     0x0040 /* send wallops to them */
#define FLAGS_SERVNOTICE 0x0080 /* server notices such as kill */
#define FLAGS_BLOCKED    0x0100 /* socket is in a blocked condition */
#define FLAGS_UNIX       0x0200 /* socket is in the unix domain, not inet */
#define FLAGS_CLOSING    0x0400 /* set when closing to suppress errors */
#define FLAGS_LISTEN     0x0800 /* used to mark clients which we listen() on */
#define FLAGS_CHKACCESS  0x1000 /* ok to check clients access if set */
#define FLAGS_DOINGDNS   0x2000 /* client is waiting for a DNS response */
#define FLAGS_AUTH       0x4000 /* client is waiting on rfc931 response */
#define FLAGS_WRAUTH     0x8000 /* set if we havent writen to ident server */
#define FLAGS_LOCAL     0x10000 /* set for local clients */
#define FLAGS_GOTID     0x20000 /* successful ident lookup achieved */
#define FLAGS_DOID      0x40000 /* I-lines say must use ident return */
#define FLAGS_NONL      0x80000 /* No \n in buffer */
#define FLAGS_TS8      0x100000 /* Why do you want to know? */
#define FLAGS_PING     0x200000 /* Socket is waiting for udp ping response */
#define FLAGS_ASKEDPING 0x400000        /* Client asked for udp ping */
#define FLAGS_MAP      0x800000 /* Show server on the map */
#define FLAGS_JUNCTION 0x1000000        /* Junction causing the net.burst */
#define FLAGS_DEAF     0x2000000        /* Makes user deaf */
#define FLAGS_NOKICK   0x4000000        /* prevents the possibility of KICK or MODE
                                         * -o on the user; can only be set by server
                                         * connections, not by local users */
#define FLAGS_BURST    0x8000000        /* Server is receiving a net.burst */
#define FLAGS_BOUNCE  0x10000000        /* Server is receiving a net.bounce */

#define SEND_UMODES     (FLAGS_INVISIBLE|FLAGS_OPER|FLAGS_WALLOP|FLAGS_DEAF|FLAGS_NOKICK)
#define ALL_UMODES      (SEND_UMODES|FLAGS_SERVNOTICE|FLAGS_LOCOP)
                    /* FLAGS_LOCOP was originally left out; this was a bug */
#define FLAGS_ID        (FLAGS_DOID|FLAGS_GOTID)

/*
 * flags macros.
 */
#define IsOper(x)               ((x)->flags & FLAGS_OPER)
#define IsLocOp(x)              ((x)->flags & FLAGS_LOCOP)
#define IsInvisible(x)          ((x)->flags & FLAGS_INVISIBLE)
#define IsDeaf(x)               ((x)->flags & FLAGS_DEAF)
#define IsAnOper(x)             ((x)->flags & (FLAGS_OPER|FLAGS_LOCOP))
#define IsPerson(x)             ((x)->user && IsClient(x))
#define IsPrivileged(x)         (IsAnOper(x) || IsServer(x))
#define SendWallops(x)          ((x)->flags & FLAGS_WALLOP)
#define SendServNotice(x)       ((x)->flags & FLAGS_SERVNOTICE)
#define IsUnixSocket(x)         ((x)->flags & FLAGS_UNIX)
#define IsListening(x)          ((x)->flags & FLAGS_LISTEN)
#define DoAccess(x)             ((x)->flags & FLAGS_CHKACCESS)
#define IsLocal(x)              ((x)->flags & FLAGS_LOCAL)
#define IsDead(x)               ((x)->flags & FLAGS_DEADSOCKET)
#define IsJunction(x)           ((x)->flags & FLAGS_JUNCTION)
#define IsBurst(x)              ((x)->flags & FLAGS_BURST)
#define IsBounce(x)             ((x)->flags & FLAGS_BOUNCE)

#define SetOper(x)              ((x)->flags |= FLAGS_OPER)
#define SetLocOp(x)             ((x)->flags |= FLAGS_LOCOP)
#define SetInvisible(x)         ((x)->flags |= FLAGS_INVISIBLE)
#define SetWallops(x)           ((x)->flags |= FLAGS_WALLOP)
#define SetUnixSock(x)          ((x)->flags |= FLAGS_UNIX)
#define SetDNS(x)               ((x)->flags |= FLAGS_DOINGDNS)
#define DoingDNS(x)             ((x)->flags & FLAGS_DOINGDNS)
#define SetAccess(x)            ((x)->flags |= FLAGS_CHKACCESS)
#define DoingAuth(x)            ((x)->flags & FLAGS_AUTH)
#define NoNewLine(x)            ((x)->flags & FLAGS_NONL)
#define DoPing(x)               ((x)->flags & FLAGS_PING)
#define SetAskedPing(x)         ((x)->flags |= FLAGS_ASKEDPING)
#define AskedPing(x)            ((x)->flags & FLAGS_ASKEDPING)
#define SetJunction(x)          ((x)->flags |= FLAGS_JUNCTION)
#define SetBurst(x)             ((x)->flags |= FLAGS_BURST)
#define SetBounce(x)            ((x)->flags |= FLAGS_BOUNCE)

#define ClearOper(x)            ((x)->flags &= ~FLAGS_OPER)
#define ClearInvisible(x)       ((x)->flags &= ~FLAGS_INVISIBLE)
#define ClearWallops(x)         ((x)->flags &= ~FLAGS_WALLOP)
#define ClearDNS(x)             ((x)->flags &= ~FLAGS_DOINGDNS)
#define ClearAuth(x)            ((x)->flags &= ~FLAGS_AUTH)
#define ClearAccess(x)          ((x)->flags &= ~FLAGS_CHKACCESS)
#define ClearPing(x)            ((x)->flags &= ~FLAGS_PING)
#define ClearAskedPing(x)       ((x)->flags &= ~FLAGS_ASKEDPING)
#define ClearBurst(x)           ((x)->flags &= ~FLAGS_BURST)
#define ClearBounce(x)          ((x)->flags &= ~FLAGS_BOUNCE)

/* used for async dns values */

#define ASYNC_NONE      (-1)
#define ASYNC_CLIENT    0
#define ASYNC_CONNECT   1
#define ASYNC_CONF      2
#define ASYNC_PING      3

/*=============================================================================
 * Proto types
 */

extern int connect_server(aConfItem * aconf, aClient * by, struct hostent *hp);
extern void add_local_domain(char *hname, int size);
extern void report_error(char *text, aClient * cptr);
extern int inetport(aClient * cptr, char *name, int port);
extern int add_listener(aConfItem * aconf);
extern void close_listeners(void);
extern void init_sys(void);
extern void write_pidfile(void);
extern int check_client(aClient * cptr);
extern int check_server(aClient * cptr);
extern void close_connection(aClient * cptr);
extern int get_sockerr(aClient * cptr);
extern void set_non_blocking(int fd, aClient * cptr);
extern aClient *add_connection(aClient * cptr, int fd);
extern int read_message(time_t delay);
extern void get_my_name(aClient * cptr, char *name, int len);
extern int setup_ping(void);

extern int highest_fd, resfd, readcalls;
extern aClient *local[MAXCONNECTIONS];
#ifdef VIRTUAL_HOST
extern struct sockaddr_in vserv;
#endif

#endif /* S_BSD_H */
