#ifndef S_DEBUG_H
#define S_DEBUG_H

#include <stdarg.h>

#ifdef DEBUGMODE

/*=============================================================================
 * Macro's
 */

#define Debug(x) debug x
#define LOGFILE LPATH

/*
 * defined debugging levels
 */
#define DEBUG_FATAL  0
#define DEBUG_ERROR  1          /* report_error() and other errors that are found */
#define DEBUG_NOTICE 3
#define DEBUG_DNS    4          /* used by all DNS related routines - a *lot* */
#define DEBUG_INFO   5          /* general usful info */
#define DEBUG_NUM    6          /* numerics */
#define DEBUG_SEND   7          /* everything that is sent out */
#define DEBUG_DEBUG  8          /* anything to do with debugging, ie unimportant :) */
#define DEBUG_MALLOC 9          /* malloc/free calls */
#define DEBUG_LIST  10          /* debug list use */

/*=============================================================================
 * proto types
 */

extern void vdebug(int level, const char *form, va_list vl);
extern void debug(int level, const char *form,...);
extern void send_usage(aClient * cptr, char *nick);

#else /* !DEBUGMODE */

#define Debug(x)
#define LOGFILE "/dev/null"

#endif /* !DEBUGMODE */

extern void count_memory(aClient * cptr, char *nick);
extern char serveropts[];

#endif /* S_DEBUG_H */
