#ifndef S_SERV_H
#define S_SERV_H

/*=============================================================================
 * General defines
 */

/*-----------------------------------------------------------------------------
 * Macro's
 */

#define GLINE_ACTIVE    1
#define GLINE_INACTIVE  0

#define STAT_PING       -7
#define STAT_LOG        -6      /* logfile for -x */
#define STAT_MASTER     -5      /* Local ircd master before identification */
#define STAT_CONNECTING -4
#define STAT_HANDSHAKE  -3
#define STAT_ME         -2
#define STAT_UNKNOWN    -1
#define STAT_SERVER     0
#define STAT_CLIENT     1
#define STAT_SERVICE    2       /* Services not implemented yet */

/*
 * status macros.
 */
#define IsRegisteredUser(x)     ((x)->status == STAT_CLIENT)
#define IsRegistered(x)         ((x)->status >= STAT_SERVER)
#define IsConnecting(x)         ((x)->status == STAT_CONNECTING)
#define IsHandshake(x)          ((x)->status == STAT_HANDSHAKE)
#define IsMe(x)                 ((x)->status == STAT_ME)
#define IsUnknown(x)            ((x)->status == STAT_UNKNOWN || \
                                 (x)->status == STAT_MASTER)
#define IsServer(x)             ((x)->status == STAT_SERVER)
#define IsClient(x)             ((x)->status == STAT_CLIENT)
#define IsLog(x)                ((x)->status == STAT_LOG)
#define IsService(x)            ((x)->status == STAT_SERVICE)
#define IsPing(x)               ((x)->status == STAT_PING)

#define SetMaster(x)            ((x)->status = STAT_MASTER)
#define SetConnecting(x)        ((x)->status = STAT_CONNECTING)
#define SetHandshake(x)         ((x)->status = STAT_HANDSHAKE)
#define SetMe(x)                ((x)->status = STAT_ME)
#define SetUnknown(x)           ((x)->status = STAT_UNKNOWN)
#define SetServer(x)            ((x)->status = STAT_SERVER)
#define SetClient(x)            ((x)->status = STAT_CLIENT)
#define SetLog(x)               ((x)->status = STAT_LOG)
#define SetService(x)           ((x)->status = STAT_SERVICE)
#define SetPing(x)              ((x)->status = STAT_PING)

/*=============================================================================
 * Structures
 */

struct Gline {
  struct Gline *next;
  char *host;
  char *reason;
  char *name;
  time_t expire;
  int active;
};

/*=============================================================================
 * Proto types
 */

#if defined(OPER_REHASH) || defined(LOCOP_REHASH)
extern int m_rehash(aClient * cptr, aClient * sptr, int parc, char *parv[]);
#endif
#if defined(OPER_RESTART) || defined(LOCOP_RESTART)
extern int m_restart(aClient * cptr, aClient * sptr, int parc, char *parv[]);
#endif
#if defined(OPER_DIE) || defined(LOCOP_DIE)
extern int m_die(aClient * cptr, aClient * sptr, int parc, char *parv[]);
#endif
extern int m_version(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_version(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_squit(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int exit_new_server(aClient * cptr, aClient * sptr, char *host, time_t timestamp, char *fmt,...);
extern int m_server(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_server_estab(aClient * cptr, aConfItem * aconf, aConfItem * bconf);
extern int m_info(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_links(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_stats(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_error(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_help(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_lusers(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_connect(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_wallops(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_time(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_settime(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern char *militime(char *sec, char *usec);
extern int m_rping(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_rpong(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_admin(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_trace(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_motd(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_close(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_gline(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_end_of_burst(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_end_of_bounce(aClient * cptr, aClient * sptr, int parc, char *parv[]);

#endif /* S_SERV_H */
