#ifndef S_USER_H
#define S_USER_H

/*=============================================================================
 * Macro's
 */

/* return values for hunt_server() */

#define HUNTED_NOSUCH   (-1)    /* if the hunted server is not found */
#define HUNTED_ISME     0       /* if this server should execute the command */
#define HUNTED_PASS     1       /* if message passed onwards successfully */

/* used when sending to #mask or $mask */

#define MATCH_SERVER  1
#define MATCH_HOST    2

#define isvalid(c) (((c) >= 'A' && (c) <= '~') || isdigit(c) || (c) == '-')

/*=============================================================================
 * Proto types
 */

extern int m_umode(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int is_silenced(aClient * sptr, aClient * acptr);
extern int hunt_server(aClient * cptr, aClient * sptr, char *command, int server, int parc, char *parv[]);
extern aClient *next_client(aClient * next, char *ch);
extern int m_nick(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_private(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_notice(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_who(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_whois(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_user(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_quit(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_kill(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_away(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_ping(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_pong(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_oper(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_pass(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_userhost(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_ison(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern int m_note(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern char *umode_str(aClient * cptr);
extern void send_umode(aClient * cptr, aClient * sptr, int old, int sendmask, char *umode_buf);
extern int del_silence(aClient * sptr, char *mask);
extern int m_silence(aClient * cptr, aClient * sptr, int parc, char *parv[]);

#endif /* S_USER_H */
