/*
 *   IRC - Internet Relay Chat, include/sys.h
 *   Copyright (C) 1990 University of Oulu, Computing Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	__sys_include__
#define __sys_include__

#include "../config.h"

#ifdef __sun__
#ifdef __svr4__
#define SOL2
#else
#define SUNOS4
#endif
#endif

#define MOTD MPATH
#define	MYNAME SPATH
#define	CONFIGFILE CPATH
#define	IRCD_PIDFILE PPATH

#ifdef	__osf__
#define	OSF
/* OSF defines BSD to be its version of BSD */
#undef BSD
#include <sys/param.h>
#ifndef BSD
#define BSD
#endif
#endif

#ifdef _SEQUENT_		/* Dynix 1.4 or 2.0 Generic Define.. */
#undef BSD
#define SYSV			/* Also #define SYSV */
#endif

#ifdef	ultrix
#define	ULTRIX
#endif

#ifdef	__hpux
#define	HPUX
#endif

#ifdef	sgi
#define	SGI
#endif

#if defined(mips) || defined(PCS)
#undef SYSV
#endif

#ifdef MIPS
#undef BSD
#define BSD             1	/* mips only works in bsd43 environment */
#endif

#ifdef sequent			/* Dynix (sequent OS) */
#define SEQ_NOFILE    128	/* set to your current kernel impl, */
#endif /* max number of socket connections */

#ifdef _SEQUENT_
#define	DYNIXPTX
#endif

#ifdef	BSD_RELIABLE_SIGNALS
#if defined(SYSV_UNRELIABLE_SIGNALS) || defined(POSIX_SIGNALS)
#error You stuffed up config.h signals #defines use only one.
#endif
#define	HAVE_RELIABLE_SIGNALS
#endif

#ifdef	SYSV_UNRELIABLE_SIGNALS
#ifdef	POSIX_SIGNALS
#error You stuffed up config.h signals #defines use only one.
#endif
#undef	HAVE_RELIABLE_SIGNALS
#endif

#ifdef	POSIX_SIGNALS
#define	HAVE_RELIABLE_SIGNALS
#endif

/*
 * safety margin so we can always have one spare fd, for motd/authd or
 * whatever else.  -24 allows "safety" margin of 10 listen ports, 8 servers
 * and space reserved for logfiles, DNS sockets and identd sockets etc.
 */
#define	MAXCLIENTS	(MAXCONNECTIONS-24)

#ifdef HAVECURSES
#define DOCURSES
#else
#undef DOCURSES
#endif

#ifdef HAVETERMCAP
#define DOTERMCAP
#else
#undef DOTERMCAP
#endif

#ifndef	UNIXPORT
#undef	UNIXPORTPATH
#endif

#if defined(CLIENT_FLOOD)
#if (CLIENT_FLOOD > 8000) || (CLIENT_FLOOD < 512)
#error CLIENT_FLOOD needs redefining.
#endif
#else
#error CLIENT_FLOOD undefined
#endif

/*
 * Some ugliness for AIX platforms.
 */
#ifdef AIX
#include <sys/machine.h>
#if BYTE_ORDER == BIG_ENDIAN
#define BIT_ZERO_ON_LEFT
#endif
#if BYTE_ORDER == LITTLE_ENDIAN
#define BIT_ZERO_ON_RIGHT
#endif
/*
 * this one is used later in sys/types.h (or so i believe). -avalon
 */
#define BSD_INCLUDES
#endif

#define Reg1 register
#define Reg2 register
#define Reg3 register
#define Reg4 register
#define Reg5 register
#define Reg6 register
#define Reg7 register
#define Reg8 register
#define Reg9 register
#define Reg10 register


#ifdef ISC202
#include <net/errno.h>
#else
#include <errno.h>
#endif
#if !defined(__FreeBSD__) && !defined(__NetBSD__) && !defined(__bsdi__)
extern char *sys_errlist[];
#endif

#include "setup.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>

#ifdef	STRINGH
#include <string.h>
#else
#ifdef	STRINGSH
#include <strings.h>
#endif
#endif
#ifdef SUNOS4
#include <memory.h>		/* Needed for memset/memcmp/memcpy */
extern char *strerror(int);	/* One the many not defined prototypes */
#endif

#ifdef AIX
#include <sys/select.h>
#endif
#if defined(HPUX )|| defined(AIX)
#include <time.h>
#ifdef AIX
#include <sys/time.h>
#endif
#else
#include <sys/time.h>
#endif

#ifdef NEXT
#define VOIDSIG int		/* whether signal() returns int of void */
#else
#define VOIDSIG void		/* whether signal() returns int of void */
#endif

#ifdef SOL2
#define OPT_TYPE char		/* opt type for get/setsockopt */
#else
#define OPT_TYPE void
#endif

/* Different name on NetBSD and FreeBSD --Skip */
#if defined(__NetBSD__) || defined(__FreeBSD__) || defined(__bsdi__)
#define dn_skipname  __dn_skipname
#endif

#ifdef	DYNIXPTX
#define	NO_U_TYPES
typedef unsigned short n_short;	/* short as received from the net */
typedef unsigned long n_long;	/* long as received from the net */
typedef unsigned long n_time;	/* ms since 00:00 GMT, byte rev */
#define _NETINET_IN_SYSTM_INCLUDED
#endif

#ifdef	NO_U_TYPES
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;
typedef unsigned int u_int;
#endif

#ifndef MAX
#define MAX(a, b)       ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a, b)       ((a) < (b) ? (a) : (b))
#endif

#ifndef FALSE
#define FALSE (0)
#endif
#ifndef TRUE
#define TRUE  (!FALSE)
#endif

#ifndef offsetof
#define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
#endif

#ifdef NOSTRCHR
#define strchr(a, b) index(a, b)
#define strrchr(a, b) rindex(a, b)
#endif

#ifdef NOMEMCPY
#define memcpy(a, b, c) bcopy(b, a, c)
#define memcmp(a, b) bcmp(a, b)
#define memset(a, b, c) bzero(a, c)  /* We ONLY use memset(x, 0, y) */
#else
#define bzero(a, c) memset(a, 0, c)  /* Some use it in the FD_ZERO macro */
#endif

#if defined(DEBUGMODE) && !defined(DEBUGMALLOC)
#define DEBUGMALLOC
#endif

#ifdef MALLOCH
#include MALLOCH
#include "runmalloc.h"
#endif

/* This isn't really POSIX :(, but we really need it -- can this be replaced ?*/
extern int gettimeofday(struct timeval *tv, struct timezone *tz);

/*
 * The following part is donated by Carlo Wood from his package 'libr':
 * (C) Copyright 1996 by Carlo Wood. All rights reserved.
 */

/* GNU CC improvements: We can only use this if we have a gcc/g++ compiler */
#ifdef __GNUC__

#if (__GNUC__ < 2) || (__GNUC__ == 2 && __GNUC_MINOR__ < 7)
#define NO_ATTRIBUTE
#endif

#else /* !__GNUC__ */

/* No attributes if we don't have gcc-2.7 or higher */
#define NO_ATTRIBUTE

#endif /* !__GNUC__ */

#ifdef NO_ATTRIBUTE
#define __attribute__(x)
#endif

#define RCSTAG_CC(string) static char rcs_ident[] __attribute__ ((unused)) = string;

#endif /* __sys_include__ */
