/*
 *   IRC - Internet Relay Chat, include/whowas.h
 *   Copyright (C) 1990  Markku Savela
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef WHOWAS_H
#define WHOWAS_H

/*=============================================================================
 * Structures
 */

typedef struct aname {
  anUser *ww_user;
  aClient *ww_online;
  time_t ww_logout;
  char ww_nick[NICKLEN + 1];
  char ww_info[REALLEN + 1];
  char *ww_server;
} aName;

/*=============================================================================
 * Proto types
 */

extern aClient *get_history(char *nick, time_t timelimit);
extern void add_history(aClient * cptr);
extern void off_history(aClient * cptr);
extern void initwhowas(void);
extern int m_whowas(aClient * cptr, aClient * sptr, int parc, char *parv[]);
extern void count_whowas_memory(int *wwu, int *wwa, u_long * wwam);

#endif /* WHOWAS_H */
