/*
 * Run's malloc/realloc/calloc/free DEBUG tools
 *
 * (C) Copyright 1996, Carlo Wood (carlo@runaway.xs4all.nl)
 *
 * These functions have been donated by Carlo Wood to the UnderNet
 * community. It may be modified for later versions of an IRC daemon,
 * provided that this copyright notice remains unchanged.
 * Use for any other program or purpose first needs written consent
 * by the Author (see E-mail above).
 *
 * These functions are distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifdef __GNUG__
#pragma implementation
#endif
#include "sys.h"
#include "h.h"

#ifdef DEBUGMALLOC

#define MyCoreDump *((int *)NULL)=0

#define MAXMALLOC 1000		/* Maximum number of allocated blocks per hash entry */
#define MALLOC_HASHTABLE_SIZE 256
#define MallocHash(x) ((u_int)((((long int)(x) * 0xDEECE66D) >> 16) & (long int)0xff))

static unsigned int allocated_hash[MALLOC_HASHTABLE_SIZE];
static size_t mem_size = 0;	/* Number of allocated bytes  */
typedef struct {
  size_t size;
  void *ptr;
} mdb_st;
static mdb_st mdb[MAXMALLOC][MALLOC_HASHTABLE_SIZE];

void *RunMalloc(size_t size)
{
  register u_int hash;
  register void *mptr;
  if (!(mptr = malloc(size)))
  {
    Debug((DEBUG_FATAL, "Out of memory !"));
    MyCoreDump;
  }
  hash = MallocHash(mptr);
  mdb[allocated_hash[hash]][hash].ptr = mptr;
  mdb[allocated_hash[hash]][hash].size = size;
  mem_size += size;
  if (allocated_hash[hash] == MAXMALLOC)
  {
    Debug((DEBUG_FATAL, "Too many (%lu) malloc calls for DEBUG_MALLOC hash %d",
	    allocated_hash[hash], hash));
    MyCoreDump;
  }
  allocated_hash[hash]++;
  Debug((DEBUG_DEBUG, "RunMalloc(%u) = %p", size, mptr));
  return mptr;
}

void *RunCalloc(size_t nmemb, size_t size)
{
  void *ptr;
  ptr = RunMalloc(nmemb * size);
  memset(ptr, 0, nmemb * size);
  return ptr;
}

int RunFree_test(void *ptr)
{
  register u_int hash;
  register unsigned long i;
  hash = MallocHash(ptr);
  for (i = 0; i < allocated_hash[hash] && mdb[i][hash].ptr != ptr; i++);
  return (i == allocated_hash[hash]) ? 0 : 1;
}

void RunFree(void *ptr)
{
  register u_int hash;
  register unsigned long i;
  Debug((DEBUG_DEBUG, "RunFree(%p)", ptr));
  hash = MallocHash(ptr);
  for (i = 0; i < allocated_hash[hash] && mdb[i][hash].ptr != ptr; i++);
  if (i == allocated_hash[hash])
  {
    Debug((DEBUG_FATAL, "FREEING NON MALLOC PTR !!!"));
    MyCoreDump;
  }
  else
  {
    mem_size -= mdb[i][hash].size;
    allocated_hash[hash]--;
    mdb[i][hash].ptr = mdb[allocated_hash[hash]][hash].ptr;
    mdb[i][hash].size = mdb[allocated_hash[hash]][hash].size;
    free(ptr);
  }
}

void *RunRealloc(void *ptr, size_t size)
{
  register u_int hash;
  register unsigned long i;
  void *ptr2;
  hash = MallocHash(ptr);
  for (i = 0; i < allocated_hash[hash] && mdb[i][hash].ptr != ptr; i++);
  if (i == allocated_hash[hash])
  {
    Debug((DEBUG_FATAL, "REALLOCATING NON MALLOC PTR !!!"));
    MyCoreDump;
  }
  mem_size -= mdb[i][hash].size;
  allocated_hash[hash]--;
  mdb[i][hash].ptr = mdb[allocated_hash[hash]][hash].ptr;
  mdb[i][hash].size = mdb[allocated_hash[hash]][hash].size;
  if ((ptr2 = realloc(ptr, size)) == NULL && size != 0)
  {
    Debug((DEBUG_FATAL, "RunRealloc: Out of memory :"));
    MyCoreDump;
  }
  if (size > 0)
  {
    hash = MallocHash(ptr2);
    mdb[allocated_hash[hash]][hash].ptr = ptr2;
    mdb[allocated_hash[hash]][hash].size = size;
    mem_size += size;
    if (allocated_hash[hash] == MAXMALLOC)
    {
      Debug((DEBUG_FATAL,
	  "Too many (%lu) realloc calls for DEBUG_MALLOC hash %d",
	  allocated_hash[hash], hash));
      MyCoreDump;
    }
    allocated_hash[hash]++;
  }
  Debug((DEBUG_DEBUG, ": RunRealloc(%p, %u) = %p", ptr, size, ptr2));
  return ptr2;
}

int report_malloc(void)
{
  u_long allocd = 0;		/* Number of allocated blocks */
  u_int hash;

  for (hash = 0; hash < MALLOC_HASHTABLE_SIZE; hash++)
    allocd += allocated_hash[hash];
  Debug((DEBUG_INFO, "Number of allocated blocks: %lu.", allocd));
  Debug((DEBUG_INFO, "Total allocated memory: %u bytes.", mem_size));

  return (allocd || mem_size ? 1 : 0);
}

#endif /* DEBUGMALLOC */
