case $CONFIG in
'')	 if test -r ../config.sh
	 then 
	    . ../config.sh ;
	 else 
	    spitshell=cat
	    package=IRC
	 fi
	 ;;
esac

echo "Extracting $package/ircd/version.c..."

if test -r version.c
then
   generation=`sed -n 's/^char \*generation = \"\(.*\)\";/\1/p' < version.c`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

sumsserv=`sum s_serv.c`;
sumsuser=`sum s_user.c`;
sumchan=`sum channel.c`;
sumsbsd=`sum s_bsd.c`;
sumhash=`sum hash.c`;
sumsmisc=`sum s_misc.c`;
sumircd=`sum ircd.c`;

creation=`date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

$spitshell >version.c <<!SUB!THIS!
/*
 *   IRC - Internet Relay Chat, ircd/version.c
 *   Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#ifdef __GNUG__
#pragma implementation
#endif
#include "sys.h"
#include "h.h"
#include "patchlevel.h"
#include "version.h"

char *generation = "$generation";
char *creation = "$creation";
char *version = BASE_VERSION PATCH1 PATCH2 PATCH3 PATCH4 PATCH5 PATCH6 PATCH7\
	PATCH8 PATCH9 PATCH10 PATCH11 PATCH12 PATCH13 PATCH14 PATCH15 PATCH16\
	PATCH17 PATCH18 PATCH19 PATCH20 PATCH21 PATCH22 PATCH23 PATCH24\
	PATCH25 PATCH26 PATCH27 PATCH28 PATCH29 PATCH30 PATCH31 PATCH32;

char *infotext[] = {
    "$package --",
    "Based on the original code written by Jarkko Oikarinen",
    "Copyright 1988, 1989, 1990, 1991 University of Oulu, Computing Center",
    "",
    "This program is free software; you can redistribute it and/or",
    "modify it under the terms of the GNU General Public License as",
    "published by the Free Software Foundation; either version 2, or",
    "(at your option) any later version.",
    "",
    "The following persons are responsible for the UnderNet code enhancements",
    "and still know how IRC really works if you have questions about it:",
    "",
    "Run          Carlo Wood               carlo@runaway.xs4all.nl",
    "Xorath       Vorac                    vorac@wheel.dcn.davis.ca.us",
    "Kev          Kevin L. Mitchell        kev@wildstar.net",
    "SeKs         Robin Thellend           seks@wildstar.net",
    "WildThang    Danny Mitchell           danny@wildstar.net",
    "",
    "Thanks to the following people for help with preparing 2.9 and 2.10",
    "CapVideo                              majdi@puck.nether.net",
    "Chaos                                 simon@troll.elec.uow.edu.au",
    "Cym                                   cym@acrux.net",
    "Ensor                                 dholmes@rahul.net",
    "flux                                  cmlambertus@ucdavis.edu",
    "Jamey                                 woodjr@durrance.Colorado.EDU",
    "Jarle                                 jarlel@II.UIB.NO",
    "Niels                                 niels@holding.pi.net",
    "record                                jegelhof@cloud9.net",
    "smg                                   smg@lm.com",
    "Starfox                               starfox@quicklink.com",
    "Trio                                  trio@b62897.STUDENT.CWRU.Edu",
    "",
    "Thanks also goes to those persons not mentioned here who have added",
    "their advice, opinions, and code to IRC.",
    "Thanks also to those who provide the kind sys admins who let me and",
    "others continue to develop IRC.",
    "",
    "[$sumsserv] [$sumchan] [$sumsbsd] [$sumsuser]",
    "[$sumhash] [$sumsmisc] [$sumircd]",
    0,
};
!SUB!THIS!
