/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * auth.h: A header for the ident functions.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: auth.h,v 1.5 2004/02/08 06:45:05 musirc Exp $
 */

#ifndef INCLUDED_auth_h
#define INCLUDED_auth_h
#include "res.h"
#define	AUTH_BLOCK_SIZE	64

struct Client;

struct AuthRequest
{
  dlink_node dns_node;     /* auth_doing_dns_list */
  dlink_node ident_node; /* auth_doing_ident_list */
  int flags;
  struct Client *client;    /* pointer to client struct for request */
  int fd;        /* file descriptor for auth queries */
  time_t timeout;   /* time when query expires */
  unsigned int ip6_int;
};

#define AM_AUTH_CONNECTING   (1 << 0)
#define AM_AUTH_PENDING      (1 << 1)
#define AM_DNS_PENDING       (1 << 2)
#define SetDNSPending(x)     ((x)->flags |= AM_DNS_PENDING)
#define ClearDNSPending(x)   ((x)->flags &= ~AM_DNS_PENDING)
#define IsDNSPending(x)      ((x)->flags &  AM_DNS_PENDING)
#define SetAuthConnect(x)    ((x)->flags |= AM_AUTH_CONNECTING)
#define ClearAuthConnect(x)  ((x)->flags &= ~AM_AUTH_CONNECTING)
#define IsAuthConnect(x)     ((x)->flags &  AM_AUTH_CONNECTING)
#define SetAuthPending(x)    ((x)->flags |= AM_AUTH_PENDING)
#define ClearAuthPending(x)  ((x)->flags &= AM_AUTH_PENDING)
#define IsAuthPending(x)     ((x)->flags &  AM_AUTH_PENDING)
#define ClearAuth(x)         ((x)->flags &= ~(AM_AUTH_PENDING | AM_AUTH_CONNECTING))
#define IsDoingAuth(x)       ((x)->flags &  (AM_AUTH_PENDING | AM_AUTH_CONNECTING))

extern void start_auth(struct Client *);
extern void init_auth(void);
extern void delete_identd_queries(struct Client *);

#endif
