/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * channel.h: The ircd channel header.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: channel.h,v 1.53.2.1 2004/05/02 05:05:03 musirc Exp $
 */

#ifndef INCLUDED_channel_h
#define INCLUDED_channel_h
#include "defs.h"
#include "tools.h"

struct Client;

/* mode structure for channels */
struct Mode
{
  unsigned int mode;
  unsigned int limit;
  char key[KEYLEN];
};

struct Channel
{
  dlink_node node;
  struct Channel *hnextch;
  struct Mode mode;
  char *topic;
  char *topic_info;
  time_t topic_time;
  time_t last_knock; /* don't allow knock to flood */
  dlink_list members;
  dlink_list locmembers;  /* local members are here too */
  dlink_list invites;
  dlink_list banlist;
  dlink_list exceptlist;
  dlink_list invexlist;
  time_t first_received_message_time; /* channel flood control */
  int received_number_of_privmsgs;
  char flood_noticed;
  time_t channelts;
  char name[CHANNELLEN + 1];
};

struct Membership
{
  dlink_node channode;      /* link to chptr->members */
  dlink_node locchannode;   /* link to chptr->locmembers */
  dlink_node usernode;      /* link to source_p->user->channel */
  struct Channel *chptr;
  struct Client *client_p;
  unsigned int flags;
};

extern dlink_list global_channel_list;
extern void init_channels(void);
extern int can_send(struct Channel *, struct Client *);
extern int can_send_part(struct Membership *, struct Channel *, struct Client *, const char *);
extern int is_banned (struct Channel *, struct Client *);
extern int can_join(struct Client *, struct Channel *, const char *);
extern int has_member_flags(struct Membership *, unsigned int);
extern void add_user_to_channel(struct Channel *, struct Client *, unsigned int);
extern void remove_user_from_channel(struct Membership *);
extern int check_channel_name(const char *);
extern void channel_member_names(struct Client *, struct Channel *, int, int);
extern const char *get_member_status(struct Membership *, int);
extern void add_invite(struct Channel *, struct Client *);
extern void del_invite(struct Channel *, struct Client *);
extern void send_channel_modes(struct Client *, struct Channel *);
extern void send_tburst(struct Client *, struct Channel *);
extern void channel_modes(struct Channel *, struct Client *, char *, char *);
extern void check_splitmode(void *);
extern void free_channel_list(dlink_list *);
extern int hascontrol(const char *);
#define ShowChannel(v,c) (PubChannel(c) || IsMember((v),(c)))
#define IsMember(who, chan) ((who && who->user && \
                 find_channel_link(who, chan)) ? 1 : 0)
#define AddMemberFlag(x, y) ((x)->flags |=  (y))
#define DelMemberFlag(x, y) ((x)->flags &= ~(y))

struct Ban
{
  dlink_node node;
  char *banstr;
  char *who;
  time_t when;
};

extern struct Membership *find_channel_link(struct Client *, struct Channel *);
extern void set_channel_topic(struct Channel *, const char *, const char *, time_t); 
extern void free_topic(struct Channel *);
extern void destroy_channel(struct Channel *chptr);
#endif
