/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * channel_mode.h: The ircd channel mode header.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: channel_mode.h,v 1.34.2.1 2004/04/13 01:11:11 musirc Exp $
 */

#ifndef INCLUDED_channel_mode_h
#define INCLUDED_channel_mode_h
#include "defs.h"
#define MODEBUFLEN 200
#define MAXMODEPARAMS 3
#define MAXSERVERMODES 12

extern int add_id(struct Client *, struct Channel *, char *, int);
extern void set_channel_mode(struct Client *, struct Client *, struct Channel *,
			     struct Membership *, int, char **, char *);
/* can_send results */
#define CAN_SEND_NO 0
#define CAN_SEND_NONOP 1
#define CAN_SEND_OPV 2

/* Channel related flags */
#define CHFL_CHANOP     0x0001
#define CHFL_HALFOP   	0x0002
#define CHFL_VOICE    	0x0004
#define CHFL_DEOPPED   	0x0008
#define CHFL_BAN     	0x0010
#define CHFL_EXCEPTION  0x0020
#define CHFL_INVEX    	0x0040

/* channel modes ONLY */
#define MODE_PRIVATE    0x0001
#define MODE_SECRET     0x0002
#define MODE_MODERATED  0x0004
#define MODE_TOPICLIMIT 0x0008
#define MODE_INVITEONLY 0x0010
#define MODE_NOPRIVMSGS 0x0020
#define MODE_NOCTCP	0x0040
#define MODE_NOCONTROL	0x0080

#define MODE_QUERY 0
#define MODE_ADD 1
#define MODE_DEL -1

/* name invisible */
#define SecretChannel(x)        ((x) && ((x)->mode.mode & MODE_SECRET))
/* channel not shown but names are */
#define HiddenChannel(x)        ((x) && ((x)->mode.mode & MODE_PRIVATE))
#define PubChannel(x)           ((!x) || ((x)->mode.mode &\
                                 (MODE_PRIVATE | MODE_SECRET)) == 0)
#define ClosedChannel(x)        ((x) && ((x)->mode.mode &\
                                (MODE_INVITEONLY | MODE_SECRET)))

struct ChModeChange
{
  char letter;
  char *arg;
  int dir;
  int mems;
  struct Client *client;
};

#define CHACCESS_NOTONCHAN -1
#define CHACCESS_PEON 0
#define CHACCESS_HALFOP 1
#define CHACCESS_CHANOP 2
#endif
