/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * defaults.h: The ircd defaults header for values and paths.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: defaults.h,v 1.27.2.2 2004/07/09 06:49:13 musirc Exp $
 */

#ifndef INCLUDED_defaults_h
#define INCLUDED_defaults_h

/* Directory paths and filenames for UNIX systems.
 * IRCD_PREFIX is set using ./configure --prefix, see INSTALL.
 * The other defaults should be fine.
 *
 * NOTE: CHANGING THESE WILL NOT ALTER THE DIRECTORY THAT FILES WILL
 *       BE INSTALLED TO.  IF YOU CHANGE THESE, DO NOT USE MAKE INSTALL,
 *       BUT COPY THE FILES MANUALLY TO WHERE YOU WANT THEM.
 *
 * IRCD_PREFIX = prefix for all directories,
 * DPATH       = root directory of installation,
 * BINPATH     = directory for binary files,
 * ETCPATH     = directory for configuration files,
 * LOGPATH     = directory for logfiles,
 * MSGPATH     = directory for language files.
 */

/* dirs */
#define DPATH   IRCD_PREFIX                                                     
#define BINPATH IRCD_PREFIX "/bin/"
#define MSGPATH IRCD_PREFIX "/messages/"
#define ETCPATH IRCD_PREFIX "/etc"
#define LOGPATH IRCD_PREFIX "/logs"
#define MODPATH IRCD_PREFIX "/modules/"
#define HPATH IRCD_PREFIX "/help"

/* files */
#define SPATH   BINPATH "/ircd"                 /* ircd executable */
#define CPATH   ETCPATH "/ircd.conf"            /* ircd.conf file */
#define KPATH   ETCPATH "/kline.conf"           /* kline file */
#define CJUPEPATH   ETCPATH "/cjupes.conf"       /* channel jupes file */
#define NJUPEPATH   ETCPATH "/njupes.conf"       /* nick jupes file */
#define DLPATH  ETCPATH "/dline.conf"           /* dline file */
#define XPATH   ETCPATH "/xline.conf"           /* xline file */
#define MPATH   ETCPATH "/ircd.motd"            /* MOTD file */
#define LPATH   LOGPATH "/ircd.log"             /* ircd logfile */
#define PPATH   ETCPATH "/ircd.pid"             /* pid file */
#define OPATH   ETCPATH "/opers.motd"           /* oper MOTD file */
#define LIPATH  ETCPATH "/links.txt"            /* cached links file */
#define MXPATH  ETCPATH "/ircd.max"

#define HANGONRETRYDELAY 60     /* Recommended value: 30-60 seconds */
#define IRCD_SOMAXCONN 25
#define MAX_TDKLINE_TIME	(24*60*30)
#define HANGONGOODLINK 3600     /* Recommended value: 30-60 minutes */

/* 10 FDs reserved for logging and name resolution */
#define HARD_FDLIMIT   MAXCONN + MAX_BUFFER + 10
#define MASTER_MAX      (HARD_FDLIMIT - MAX_BUFFER)
#define DEFAULT_SENDQ 9000000           /* default max SendQ */
#define PORTNUM 6667                    /* default outgoing portnum */
#define DEFAULT_PINGFREQUENCY    120    /* Default ping frequency */
#define DEFAULT_CONNECTFREQUENCY 600    /* Default connect frequency */
#define TS_MAX_DELTA_MIN      10        /* min value for ts_max_delta */
#define TS_MAX_DELTA_DEFAULT  600       /* default for ts_max_delta */
#define TS_WARN_DELTA_MIN     10        /* min value for ts_warn_delta */
#define TS_WARN_DELTA_DEFAULT 30        /* default for ts_warn_delta */
#define NETWORK_NAME_DEFAULT "MusIRC"             /* default for network_name */
#define MAXIMUM_LINKS_DEFAULT 1         /* default for maximum_links */
#define MAX_BUFFER 60
#define CLIENT_FLOOD_DEFAULT 2560       /* default for client_flood */
#define CLIENT_FLOOD_MAX     8000
#define CLIENT_FLOOD_MIN     512
#define LINKS_DELAY_DEFAULT  300
#define MAX_TARGETS_DEFAULT 4           /* default for max_targets */
#define INIT_LOG_LEVEL NOTICE         /* default for log_level */
#define CONNECTTIMEOUT  45
#define IDENT_TIMEOUT 10
#define SAVE_TIME 3600
#endif
