/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * fdlist.h: The file descriptor list header.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: fdlist.h,v 1.13 2004/02/08 06:45:05 musirc Exp $
 */

#ifndef INCLUDED_fdlist_h
#define INCLUDED_fdlist_h

#include "defs.h"
#include "res.h"
#define FD_DESC_SZ 128  /* hostlen + comment */

/* FD type values */
enum {
    FD_NONE,
    FD_LOG,
    FD_FILE,
    FD_FILECLOSE,
    FD_SOCKET,
    FD_PIPE,
    FD_UNKNOWN
};

enum {
    COMM_OK,
    COMM_ERR_BIND,
    COMM_ERR_DNS,
    COMM_ERR_TIMEOUT,
    COMM_ERR_CONNECT,
    COMM_ERROR,
    COMM_ERR_MAX
};

typedef enum fdlist_t {
    FDLIST_NONE,
    FDLIST_SERVICE,
    FDLIST_SERVER,
    FDLIST_IDLECLIENT,
    FDLIST_BUSYCLIENT,
    FDLIST_MAX
} fdlist_t;

typedef struct _fde fde_t;

/* Callback for completed IO events */
typedef void PF(int, void *);

/* Callback for completed connections */
typedef void CNCB(int, int, void *);

extern int highest_fd, number_fd;

struct Client;

struct _fde {
    /* Yes, this gives us only one pending read and one pending write per
     * filedescriptor. Think though: when do you think we'll need more?
     */
    int fd;		/* So we can use the fde_t as a callback ptr */
    int type;
    fdlist_t list;	/* Which list this FD should sit on */
    int comm_index;	/* where in the poll list we live */
    char desc[FD_DESC_SZ];
    PF *read_handler;
    void *read_data;
    PF *write_handler;
    void *write_data;
    PF *timeout_handler;
    void *timeout_data;
    time_t timeout;
    PF *flush_handler;
    void *flush_data;
    time_t flush_timeout;
    struct DNSQuery *dns_query;
    struct {
        unsigned int open:1;
        unsigned int close_request:1;
        unsigned int write_daemon:1;   
        unsigned int closing:1;
        unsigned int socket_eof:1;
        unsigned int nolinger:1;
        unsigned int nonblocking:1;
        unsigned int ipc:1;
        unsigned int called_connect:1;
    } flags;
    struct {
        /* We don't need the host here ? */
	struct irc_ssaddr S;
	struct irc_ssaddr hostaddr;
        CNCB *callback;
        void *data;
    } connect;
};

extern fde_t *fd_table;
void fdlist_init(void);
extern void fd_open(int, unsigned int, const char *);
extern void fd_close(int);
#endif
