/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * fileio.h: The file input/output header.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: fileio.h,v 1.10 2004/01/20 09:33:24 musirc Exp $
 */

#ifndef INCLUDED_fileio_h
#define INCLUDED_fileio_h

#define FB_EOF  0x01
#define FB_FAIL 0x02

struct FileBuf {
  int fd;           /* file descriptor */
  char *endp;         /* one past the end */
  char *ptr;          /* current read pos */
  char *pbptr;        /* pointer to push back char */
  int flags;        /* file state */
  char buf[BUFSIZ];  /* buffer */
  char pbuf[BUFSIZ+1]; /* push back buffer */
};

/* FileBuf is a mirror of the ANSI FILE struct, but it works for any
 * file descriptor. FileBufs are allocated when a file is opened with
 * fbopen, and they are freed when the file is closed using fbclose.
 */
typedef struct FileBuf FBFILE;

/* open a file and return a FBFILE*, see fopen(3) */
extern FBFILE* fbopen(const char *, const char *);

/* Positions the file pointer at the beginning of the file */
extern int fbrewind(FBFILE *);

/* associate a file descriptor with a FBFILE*
 * if a FBFILE* is associated here it MUST be closed using fbclose
 * see fdopen(3)
 */
extern FBFILE* fdbopen(int, const char *);
/* close a file opened with fbopen, see fclose(3) */
extern void fbclose(FBFILE *);
/* return the next character from the file, EOF on end of file
 * see fgetc(3)
 */
extern int fbgetc(FBFILE *);
/* return next string in a file up to and including the newline character
 * see fgets(3)
 */
extern char *fbgets(char *, size_t, FBFILE *);
/* ungets c to fb see ungetc(3) */
extern void fbungetc(char, FBFILE *);
/* write a null terminated string to a file, see fputs(3) */
extern int fbputs(const char *, FBFILE *, size_t);
/* popen a file. */
extern FBFILE *fbpopen(const char *, const char *);

extern int file_open(const char *, int, int);
extern void file_close(int);
#endif
