/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: getinfo.h,v 1.4 2004/02/08 06:45:05 musirc Exp $
 */

#ifndef INCLUDED_getinfo_h
#define INCLUDED_getinfo_h

int irc_getnameinfo(const struct sockaddr *, socklen_t, char *, size_t, char *, size_t, int);
int irc_getaddrinfo(const char *, const char *, const struct addrinfo *, struct addrinfo **);
extern void irc_freeaddrinfo(struct addrinfo *);

#define SUCCESS 0
#define ANY 0

#undef EAI_ADDRFAMILY
#undef EAI_AGAIN
#undef EAI_BADFLAGS
#undef EAI_FAIL
#undef EAI_FAMILY
#undef EAI_MEMORY
#undef EAI_NODATA
#undef EAI_NONAME
#undef EAI_SERVICE
#undef EAI_SOCKTYPE
#undef EAI_SYSTEM
#undef EAI_BADHINTS
#undef EAI_PROTOCOL
#undef EAI_MAX
#undef AI_MASK

#define EAI_ADDRFAMILY   1  /* address family for hostname not supported */
#define EAI_AGAIN    2  /* temporary failure in name resolution */
#define EAI_BADFLAGS     3  /* invalid value for ai_flags */
#define EAI_FAIL     4  /* non-recoverable failure in name resolution */
#define EAI_FAMILY   5  /* ai_family not supported */
#define EAI_MEMORY   6  /* memory allocation failure */
#define EAI_NODATA   7  /* no address associated with hostname */
#define EAI_NONAME   8  /* hostname nor servname provided, or not known */
#define EAI_SERVICE  9  /* servname not supported for ai_socktype */
#define EAI_SOCKTYPE    10  /* ai_socktype not supported */
#define EAI_SYSTEM  11  /* system error returned in errno */
#define EAI_BADHINTS    12
#define EAI_PROTOCOL    13
#define EAI_MAX     14
#define AI_MASK (AI_PASSIVE | AI_NUMERICHOST)

#ifndef IN_EXPERIMENTAL
#define IN_EXPERIMENTAL(a)    ((((long int) (a)) & 0xe0000000) == 0xe0000000)
#endif
#endif
