/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * ircd.h: A header for the ircd startup routines.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: ircd.h,v 1.42 2004/02/08 06:45:05 musirc Exp $
 */

#ifndef INCLUDED_ircd_h
#define INCLUDED_ircd_h

#include "tools.h"
#include "memory.h"

#define IRCD_MIN(a, b)  ((a) < (b) ? (a) : (b))

struct Client;
struct dlink_list;

/* MessageHandler */
typedef enum HandlerType {
  UNREGISTERED_HANDLER,
  CLIENT_HANDLER,
  SERVER_HANDLER,
  OPER_HANDLER,
  LAST_HANDLER_TYPE
} HandlerType;

struct SetOptions
{
  int maxclients;       /* max clients allowed */
  int autoconn;         /* autoconn enabled for all servers? */
  int idletime;
  int floodcount;	/* Number of messages in 1 second */
  int ident_timeout;     /* timeout for identd lookups */
};

struct Counter
{
  int myserver; /* my servers */
  int oper;     /* Opers */
  int service; /* Services */
  int local;    /* Local Clients       */
  int total;    /* total clients       */
  int max_loc;  /* MAX local clients   */
  int max_tot;  /* MAX global clients  */
};

extern struct SetOptions GlobalSetOptions; /* defined in ircd.c */

struct ServerState_t
{
  int foreground;
};

extern struct ServerState_t server_state;
extern void write_stats(void);
extern char **myargv;
extern const char *creation, *generation, *platform, *infotext[], 
		  *ircd_version, *logFileName, *pidFileName;
extern int dorehash, doremotd, default_server_capabs, splitmode, 
	   splitchecking, split_users, rehashed_klines, rehashed_xlines;
extern struct Counter Count;
extern struct timeval SystemTime;
#define CurrentTime SystemTime.tv_sec
extern time_t nextconnect;
extern unsigned int split_servers;
extern dlink_list unknown_list,local_client_list, serv_list, 
		  global_serv_list, oper_list;

extern unsigned long get_maxrss(void);
extern void set_time(void);

/* MessageHandler function
 * Params:
 * struct Client* client_p   - connection message originated from
 * struct Client* source_p   - source of message, may be different from client_p
 * int            parc   - parameter count
 * char*          parv[] - parameter vector
 */
typedef void (*MessageHandler)(struct Client*, struct Client*, int, char*[]);

extern void setup_signals(void);
#endif
