/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * istring.h: A header for the ircd string functions.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: istring.h,v 1.5 2004/02/24 05:32:22 musirc Exp $
 */

#ifndef INCLUDED_istring_h
#define INCLUDED_istring_h

/* match - compare name with mask, mask may contain * and ? as wildcards
 * match - returns 1 on successful match, 0 otherwise
 * match_esc - compare with support for escaping chars
 * match_cidr - compares u!h@addr with u!h@addr/cidr
 */
extern int match(const char *, const char *);
extern int match_esc(const char *, const char *);
extern int match_cidr(const char *, const char *);

/* collapse - collapse a string in place, converts multiple adjacent *'s 
 * into a single *.
 * collapse - modifies the contents of pattern 
 * collapse_esc() - collapse with support for escaping chars
 */
extern char *collapse(char *);
extern char *collapse_esc(char *);

/* NOTE: The following functions are NOT the same as strcasecmp
 * and strncasecmp! These functions use the Finnish (RFC1459)
 * character set. Do not replace!
 * irccmp - case insensitive comparison of s1 and s2
 */
extern int irccmp(const char *, const char *);

/* ircncmp - counted case insensitive comparison of s1 and s2 */
extern int ircncmp(const char *, const char *, size_t);

/* inetntoa - optimized inet_ntoa */
const char* inetntoa(const char* in_addr);

/* inetntop() 
 * portable interface for inet_ntop(), kludge; please use inet_ntop if possible
 * since inet_misc has a more conformant one
 */
const char *inetntop(int, const void *, char *, unsigned int);
                                
#ifndef HAVE_STRLCPY
size_t strlcpy(char *, const char *, size_t);
#endif

#ifndef HAVE_STRLCAT
size_t strlcat(char *, const char *, size_t);
#endif

#ifndef HAVE_STRCASESTR
char *strcasestr(const char *, const char *);
#endif

#ifndef HAVE_SNPRINTF
int snprintf(char *, size_t, const char *, ...);
#endif

#ifndef HAVE_VSNPRINTF
int vsnprintf(char *, size_t, const char *, va_list);
#endif

#ifndef HAVE_BASENAME
char* basename (char *);
#endif

/* clean_string - cleanup control and high ascii characters
 * -Dianora
 */
char* clean_string(char *, const unsigned char *, size_t);
/* strip_tabs - convert tabs to spaces
 * - jdc
 */
char *strip_tabs(char *, const unsigned char *, size_t);

const char *myctime(time_t);

#define EmptyString(x) (!(x) || (*(x) == '\0'))

#ifndef HAVE_STRTOK_R
char* strtoken(char **, char *, const char *);
#endif

/* character macros */
extern const unsigned char ToLowerTab[];
#define ToLower(c) (ToLowerTab[(unsigned char)(c)])

extern const unsigned char ToUpperTab[];
#define ToUpper(c) (ToUpperTab[(unsigned char)(c)])

extern const unsigned int CharAttrs[];

#define PRINT_C   0x001
#define CNTRL_C   0x002
#define ALPHA_C   0x004
#define DIGIT_C   0x008
#define SPACE_C   0x010
#define NICK_C    0x020
#define CHAN_C    0x040
#define KWILD_C   0x080
#define CHANPFX_C 0x100
#define USER_C    0x200
#define HOST_C    0x400
#define NONEOS_C 0x0800
#define SERV_C   0x1000
#define EOL_C    0x2000
#define MWILD_C  0x4000

#define IsHostChar(c)   (CharAttrs[(unsigned char)(c)] & HOST_C)
#define IsUserChar(c)   (CharAttrs[(unsigned char)(c)] & USER_C)
#define IsChanPrefix(c) (CharAttrs[(unsigned char)(c)] & CHANPFX_C)
#define IsChanChar(c)   (CharAttrs[(unsigned char)(c)] & CHAN_C)
#define IsKWildChar(c)  (CharAttrs[(unsigned char)(c)] & KWILD_C)
#define IsMWildChar(c)  (CharAttrs[(unsigned char)(c)] & MWILD_C)
#define IsNickChar(c)   (CharAttrs[(unsigned char)(c)] & NICK_C)
#define IsServChar(c)   (CharAttrs[(unsigned char)(c)] & (NICK_C | SERV_C))
#define IsAlpha(c)      (CharAttrs[(unsigned char)(c)] & ALPHA_C)
#define IsSpace(c)      (CharAttrs[(unsigned char)(c)] & SPACE_C)
#define IsLower(c)      (IsAlpha((c)) && ((unsigned char)(c) > 0x5f))
#define IsUpper(c)      (IsAlpha((c)) && ((unsigned char)(c) < 0x60))
#define IsDigit(c)      (CharAttrs[(unsigned char)(c)] & DIGIT_C)
#define IsXDigit(c) (IsDigit(c) || ('a' <= (c) && (c) <= 'f') || \
        ('A' <= (c) && (c) <= 'F'))
#define IsAlNum(c) (CharAttrs[(unsigned char)(c)] & (DIGIT_C | ALPHA_C))
#define IsPrint(c) (CharAttrs[(unsigned char)(c)] & PRINT_C)
#define IsEol(c) (CharAttrs[(unsigned char)(c)] & EOL_C)
#endif
