/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * jupe.h: A header for the C/NJUPE functions.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: jupe.h,v 1.1.2.1 2004/07/09 04:56:44 musirc Exp $
 */

#ifndef INCLUDED_jupe_h
#define INCLUDED_jupe_h

struct JupeChannel
{
  dlink_node node;
  struct JupeChannel *hnext;
  /* +1 for \0 */
  char name[CHANNELLEN + 1];
  char *reason;
  int conf;         /* 1 if set from ircd.conf, 0 if from elsewhere */
};

extern dlink_list jupe_channel_list;
extern struct ConfItem *create_channel_jupe(char *, char *, int);
extern struct ConfItem *create_nick_jupe(char *, char *, int);
extern int find_channel_jupe(const char *);
extern int clean_jupe_nick(char *);
extern int delete_channel_jupe(struct JupeChannel *);
extern void clear_conf_jupe(void);
extern void report_jupe(struct Client *);
extern int valid_wild_card_simple(char *);
extern dlink_list njupe_items;
#endif
