/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * modules.h: A header for the modules functions.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: modules.h,v 1.41.2.2 2004/08/03 04:54:37 musirc Exp $
 */

#ifndef INCLUDED_modules_h
#define INCLUDED_modules_h
#include "parse.h"

#ifdef HAVE_SHL_LOAD
#include <dl.h>
#endif
#if !defined(STATIC_MODULES) && defined(HAVE_DLFCN_H)
#include <dlfcn.h>
#endif
#include "msg.h"

#ifndef STATIC_MODULES
struct module
{
  dlink_node node;
  char *name;
  const char *version;
  void *address;
  int core;
  void (*modremove)(void);
};

struct module_path
{
  dlink_node node;
  char *path;
};

extern void mod_set_base(void);
extern void mod_add_path(const char *);
extern void mod_clear_paths(void);
extern void load_all_modules(int);
extern void load_core_modules(int);
extern void _modinit(void);
extern void _moddeinit(void);
extern int unload_one_module(char *, int);
extern int load_one_module(char *, int);
extern int load_a_module(char *, int, int);
extern dlink_node *findmodule_byname(const char *);
extern void modules_init(void);
#else /* STATIC_MODULES */
extern struct Message accept_msgtab;
extern struct Message admin_msgtab;
extern struct Message away_msgtab;
extern struct Message capab_msgtab;
extern struct Message cjupe_msgtab;
extern struct Message classlist_msgtab;
extern struct Message close_msgtab;
extern struct Message connect_msgtab;
extern struct Message die_msgtab;
extern struct Message dmem_msgtab;
extern struct Message eob_msgtab;
extern struct Message error_msgtab;
extern struct Message fixinvite_msgtab;
extern struct Message fixts_msgtab;
extern struct Message flags_msgtab;
extern struct Message help_msgtab;
extern struct Message info_msgtab;
extern struct Message invite_msgtab;
extern struct Message irfe_msgtab;
extern struct Message ison_msgtab;
extern struct Message join_msgtab;
extern struct Message kick_msgtab;
extern struct Message ajoin_msgtab;
extern struct Message kill_msgtab;
extern struct Message kline_msgtab;
extern struct Message dline_msgtab;
extern struct Message knock_msgtab;
extern struct Message links_msgtab;
extern struct Message list_msgtab;
extern struct Message olist_msgtab;
extern struct Message locops_msgtab;
extern struct Message lusers_msgtab;
extern struct Message privmsg_msgtab;
extern struct Message notice_msgtab;
extern struct Message map_msgtab;
extern struct Message mode_msgtab;
extern struct Message omode_msgtab;
extern struct Message motd_msgtab;
extern struct Message omotd_msgtab;
extern struct Message names_msgtab;
extern struct Message onames_msgtab;
extern struct Message nick_msgtab;
extern struct Message njupe_msgtab;
extern struct Message oper_msgtab;
extern struct Message opme_msgtab;
extern struct Message part_msgtab;
extern struct Message pass_msgtab;
extern struct Message ping_msgtab;
extern struct Message pong_msgtab;
extern struct Message post_msgtab;
extern struct Message quit_msgtab;
extern struct Message rehash_msgtab;
extern struct Message restart_msgtab;
extern struct Message server_msgtab;
extern struct Message set_msgtab;
extern struct Message sjoin_msgtab;
extern struct Message squit_msgtab;
extern struct Message stats_msgtab;
extern struct Message svinfo_msgtab;
extern struct Message svnick_msgtab;
extern struct Message testline_msgtab;
extern struct Message tburst_msgtab;
extern struct Message time_msgtab;
extern struct Message topic_msgtab;
extern struct Message otopic_msgtab;
extern struct Message trace_msgtab;
extern struct Message ctrace_msgtab;
extern struct Message ltrace_msgtab;
extern struct Message uncjupe_msgtab;
extern struct Message sjupe_msgtab;
extern struct Message unsjupe_msgtab;
extern struct Message undline_msgtab;
extern struct Message unkline_msgtab;
extern struct Message unnjupe_msgtab;
extern struct Message unxline_msgtab;
extern struct Message user_msgtab;
extern struct Message userhost_msgtab;
extern struct Message version_msgtab;
extern struct Message wallops_msgtab;
extern struct Message who_msgtab;
extern struct Message owho_msgtab;
extern struct Message owhois_msgtab;
extern struct Message whois_msgtab;
extern struct Message whowas_msgtab;
extern struct Message xline_msgtab;
extern struct Message get_msgtab;
extern struct Message put_msgtab;
extern struct Message nickserv_msgtab;
extern struct Message chanserv_msgtab;
extern struct Message memoserv_msgtab;
extern struct Message operserv_msgtab;
extern struct Message helpserv_msgtab;
extern struct Message aimold_msgtab;
extern struct Message aim_msgtab;
extern struct Message statserv_msgtab;
extern struct Message ns_msgtab;
extern struct Message cs_msgtab;
extern struct Message os_msgtab;
extern struct Message ms_msgtab;
extern struct Message global_msgtab;
extern void load_all_modules(int);
#endif /* STATIC_MODULES */
#endif
