/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * msg.h: A header for the message handler structure.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: msg.h,v 1.17 2004/02/09 09:55:04 musirc Exp $
 */

#ifndef INCLUDED_msg_h
#define INCLUDED_msg_h

#include "ircd.h"

struct Client;

struct Message
{
  const char *cmd;
  unsigned int parameters; /* at least this many args must be passed
                             * or an error will be sent to the user 
                             * before the m_func is even called 
                             */
  unsigned int flags;      /* bit 0 set means that this command is allowed
			     * to be used only on the average of once per 2
			     * seconds -SRB
			     */
  /* UNREGISTERED, CLIENT, SERVER, OPER */
  MessageHandler handlers[LAST_HANDLER_TYPE];
};

#define MFLG_SLOW 0x001   /* Command can be executed roughly once per 2 seconds. */
#define MFLG_UNREG 0x002   /* Command available to unregistered clients. */
#define MAXPARA 15
#endif
