/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * server.h: A header for the server functions.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: server.h,v 1.17 2004/02/06 07:34:11 musirc Exp $
 */

#ifndef INCLUDED_server_h
#define INCLUDED_server_h

struct ConfItem;

/* number of seconds to wait after server starts up, before
 * starting try_connections()
 * TOO SOON and you can nick collide like crazy. 
 */
#define STARTUP_CONNECTIONS_TIME 60

struct Client;
struct AccessItem;
struct Channel;

struct Capability
{
  dlink_node node;
  char *name;
  unsigned int cap;
};

#define CAP_QS 0x01

#define IsCapable(x, cap) ((x)->localClient->caps & (cap))
#define SetCapable(x, cap) ((x)->localClient->caps |= (cap))

extern struct Capability captab[];

/* return values for hunt_server() */
#define HUNTED_NOSUCH   (-1)    /* if the hunted server is not found */
#define HUNTED_ISME     0       /* if this server should execute the command */
#define HUNTED_PASS     1       /* if message passed onwards successfully */

extern int check_server(const char *, struct Client *);
extern int hunt_server(struct Client *, struct Client *,
		       const char *, int, int, char **);
extern const char *my_name_for_link(struct ConfItem *);
extern void add_capability(const char *, int, int);
extern int find_capability(const char *);
extern void send_capabilities(struct Client *);
extern void write_links_file(void *);
extern int server_estab(struct Client *);
extern void set_autoconn(struct Client *, const char *, int);
extern const char *show_capabilities(struct Client *);
extern void try_connections(void *);
extern void sendnick_TS(struct Client *, struct Client *);
extern int serv_connect(struct AccessItem *, struct Client *);
#endif
