/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * supported.h: Header for 005 numeric etc...
 * Copyright (C) 2004 by MusIRd Development.
 * $Id: supported.h,v 1.32 2004/03/19 00:10:13 musirc Exp $
 */

#ifndef INCLUDED_supported_h
#define INCLUDED_supported_h

#include "channel.h"
#include "defs.h"
#include "server.h"

#define PREFIX "(ohv)@%+"

#define FEATURES "INVEX DEAF EXCEPTS KNOCK SAFELIST SSIGNORE WALLCHOPS MODES=%i MAXCHANNELS=%i" \
                " MAXBANS=%i NICKLEN=%i TOPICLEN=%i KICKLEN=%i"
#define FEATURES2 "CHANTYPES=%s PREFIX=%s CHANMODES=%s CASEMAPPING=rfc1459 NETWORK=%s"

#define FEATURESVALUES MAXMODEPARAMS, ConfigChannel.max_chans_per_user, \
        ConfigChannel.max_bans, NICKLEN-1, TOPICLEN, TOPICLEN

#define FEATURESVALUES2 ConfigChannel.disable_local_channels ? "#" : "#&", \
        PREFIX, "eIb,k,l,Ccimnprst", ServerInfo.network_name

/* - from mirc's versions.txt
 *
 *  mIRC now supports the numeric 005 tokens: CHANTYPES=# and
 *  PREFIX=(ohv)@%+ and can handle a dynamic set of channel and
 *  nick prefixes.
 *
 *  mIRC assumes that @ is supported on all networks, any mode
 *  left of @ is assumed to have at least equal power to @, and
 *  any mode right of @ has less power.
 *
 *  mIRC has internal support for @%+ modes.
 *
 *  $nick() can now handle all mode letters listed in PREFIX.
 *
 *  Also added support for CHANMODES=A,B,C,D token (not currently
 *  supported by any servers), which lists all modes supported
 *  by a channel, where:
 *
 *    A = modes that take a parameter, and add or remove nicks
 *        or addresses to a list, such as +bIe for the ban,
 *        invite, and exception lists.
 *
 *    B = modes that change channel settings, but which take
 *        a parameter when they are set and unset, such as
 *        +k key, and -k key.
 *
 *    C = modes that change channel settings, but which take
 *        a parameter only when they are set, such as +l N,
 *        and -l.
 *
 *    D = modes that change channel settings, such as +imnpst
 *        and take no parameters.
 *
 *  All unknown/unlisted modes are treated as type D.
 */

#endif
