/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * user.h: A header for the user functions.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: user.h,v 1.3 2004/02/05 09:43:16 musirc Exp $
 */

#ifndef INCLUDED_user_h
#define INCLUDED_user_h

struct User;
struct Client;
struct AccessItem;

extern void init_user(void);
extern void free_user(struct User *, struct Client *);
extern void set_user_mode(struct Client *, struct Client *, int, char **);
extern void send_umode(struct Client *, struct Client *,
		       unsigned int, unsigned int, char *);
extern void send_umode_out(struct Client *, struct Client *, unsigned int);
extern void show_lusers(struct Client *);
extern void show_isupport(struct Client *);
extern void oper_up(struct Client *);
extern int register_local_user(struct Client *, struct Client *,
			       const char *, const char *);
extern int register_remote_user(struct Client *, struct Client *,
				const char *, const char *,
				const char *, const char *);
extern int do_local_user(const char *, struct Client *, struct Client *,
			 const char *, const char *, const char *,
			 const char *);
extern const unsigned int user_modes_from_c_to_bitmask[];
#endif
