/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * whowas.h: Header for the whowas functions.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: whowas.h,v 1.14 2004/02/04 06:43:43 musirc Exp $
 */

#ifndef INCLUDED_whowas_h
#define INCLUDED_whowas_h

#include "client.h"

/* Whowas hash table size */
#define WW_MAX 65536

struct User;
struct Client;

struct Whowas
{
  int hashv;
  char name[NICKLEN];
  char username[USERLEN + 1]; 
  char hostname[HOSTLEN + 1];
  char realname[REALLEN + 1];
  char servername[HOSTLEN + 1];
  time_t logoff;
  struct Client *online; /* Pointer to new nickname for chasing or NULL */
  struct Whowas *next;  /* for hash table... */
  struct Whowas *prev;  /* for hash table... */
  struct Whowas *cnext; /* for client struct linked list */
  struct Whowas *cprev; /* for client struct linked list */
};

extern void init_whowas(void);
/* add_history
 *      Add the currently defined name of the client to history.
 *      usually called before changing to a new name (nick).
 *      Client must be a fully registered user (specifically,
 *      the user structure must have been allocated).
 */
extern void add_history(struct Client *, int);

/* off_history
 *      This must be called when the client structure is about to
 *      be released. History mechanism keeps pointers to client
 *      structures and it must know when they cease to exist. This
 *      also implicitly calls AddHistory.
 */
extern void off_history(struct Client *);

/* get_history
 *      Return the current client that was using the given
 *      nickname within the timelimit. Returns NULL, if no
 *      one found...
 */
extern struct Client *get_history(const char *, time_t);
extern void count_whowas_memory(int *, unsigned long *);
extern struct Whowas *WHOWASHASH[];
extern unsigned int hash_whowas_name(const char *);
#endif
