/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * m_accept.c: Allows a user to talk to a +I user.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: m_accept.c,v 1.18 2004/02/08 06:46:04 musirc Exp $
 */

#include "handlers.h"
#include "client.h"
#include "istring.h"
#include "sprintf.h"
#include "hash.h"
#include "ircd.h"
#include "list.h"
#include "numeric.h"
#include "config.h"
#include "server.h"
#include "send.h"
#include "msg.h"
#include "modules.h"

static void m_accept(struct Client *, struct Client *, int, char **);
static void build_nicklist(struct Client *, char *, char *, char *);
static void add_accept(struct Client *, struct Client *);
static void list_accepts(struct Client *);

struct Message accept_msgtab = {
  "ACCEPT", 2, MFLG_SLOW,
  {m_unregistered, m_accept, m_ignore, m_accept}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&accept_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&accept_msgtab);
}

const char *_version = "$Revision: 1.18 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void
m_accept(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  char *nick, *p = NULL;
  static char addbuf[BUFSIZE], delbuf[BUFSIZE];
  struct Client *target_p;
  int accept_num;
  
  if(*parv[1] == '*')
  {
    list_accepts(source_p);
    return;
  }

  build_nicklist(source_p, addbuf, delbuf, parv[1]);

  /* parse the delete list */
  for(nick = strtoken(&p, delbuf, ","); nick != NULL;
      nick = strtoken(&p, NULL, ","))
  {
    /* shouldnt happen, but lets be paranoid */
    if (((target_p = find_client(nick)) == NULL) || !IsPerson(target_p))
    {
      sendto_one(source_p, form_str(ERR_NOSUCHNICK),
                 me.name, source_p->name, nick);
      continue;
    }

    /* user isnt on clients accept list */
    if (!accept_message(target_p, source_p))
    {
      sendto_one(source_p, form_str(ERR_ACCEPTNOT),
                 me.name, source_p->name, target_p->name);
      continue;
    }

    del_from_accept(target_p, source_p);
  }

  /* get the number of accepts they have */ 
  accept_num = dlink_list_length(&source_p->allow_list);
  
  /* parse the add list */
  for (nick = strtoken(&p, addbuf, ","); nick;
      nick = strtoken(&p, NULL, ","), accept_num++)
  {
    /* shouldnt happen, but lets be paranoid */
    if (((target_p = find_client(nick)) == NULL) || !IsPerson(target_p))
    {
      sendto_one(source_p, form_str(ERR_NOSUCHNICK),
                 me.name, source_p->name, nick);
      continue;
    }

    /* user is already on clients accept list */
    if (accept_message(target_p, source_p))
    {
      sendto_one(source_p, form_str(ERR_ACCEPTEXIST),
                 me.name, source_p->name, target_p->name);
      continue;
    }

    if (accept_num >= ConfigFileEntry.max_accept)
    {
      sendto_one(source_p, form_str(ERR_ACCEPTFULL),
                 me.name, source_p->name);
      return;
    }
      
    /* why is this here? */
    /* del_from accept(target_p, source_p); */
    add_accept(source_p, target_p);
  }
}

/* input	- pointer to client
 *		- pointer to addbuffer
 *		- pointer to remove buffer
 *		- pointer to list of nicks
 * side effects - addbuf/delbuf are modified to give valid nicks
 */
static void
build_nicklist(struct Client *source_p, char *addbuf,
               char *delbuf, char *nicks)
{
  char *name, *p;
  int lenadd, lendel, del;
  struct Client *target_p;

  *addbuf = *delbuf = '\0';
  del = lenadd = lendel = 0;

  /* build list of clients to add into addbuf, clients to remove in delbuf */
  for (name = strtoken(&p, nicks, ","); name; 
       name = strtoken(&p, NULL, ","), del = 0)
  {
    if(*name == '-')
    {
      del = 1;
      name++;
    }

    if (((target_p = find_client(name)) == NULL) || !IsPerson(target_p))
    {
      sendto_one(source_p, form_str(ERR_NOSUCHNICK),
                 me.name, source_p->name, name);
      continue;
    }

    /* we're deleting a client */
    if (del)
    {
      if (*delbuf)
        strcat(delbuf, ",");
	
      strncat(delbuf, name, BUFSIZE - lendel - 1);
      lendel += strlen(name) + 1;
    }
    /* adding a client */
    else
    {
      if (*addbuf)
        strcat(addbuf, ",");

      strncat(addbuf, name, BUFSIZE - lenadd - 1);
      lenadd += strlen(name) + 1;
    }
  }
}

/* input	- pointer to clients accept list to add to
 * 		- pointer to client to add
 * side effects - target is added to clients list
 */
static void
add_accept(struct Client *source_p, struct Client *target_p)
{
  dlinkAdd(target_p, make_dlink_node(), &source_p->allow_list);
  dlinkAdd(source_p, make_dlink_node(), &target_p->on_allow_list);
}
  
/* input 	- pointer to client
 * side effects	- print accept list to client
 */
static void
list_accepts(struct Client *source_p)
{
  dlink_node *ptr;
  struct Client *target_p;
  char nicks[BUFSIZE];
  int len = 0, len2 = 0, count = 0;
  
  *nicks = '\0';
  len2 = strlen(source_p->name) + 10;

  DLINK_FOREACH(ptr, source_p->allow_list.head)
  {
    target_p = ptr->data;

    if (target_p)
    {

      if ((len + strlen(target_p->name) + len2 > BUFSIZE) || count > 14)
      {
        sendto_one(source_p, form_str(RPL_ACCEPTLIST),
	           me.name, source_p->name, nicks);
		   
	len = count = 0;
	*nicks = '\0';
      }

      ircsprintf(nicks+len, "%s ", target_p->name);
      
      count++;
      len += strlen(target_p->name) + 1;
    }
  }

  if (*nicks)
    sendto_one(source_p, form_str(RPL_ACCEPTLIST),
               me.name, source_p->name, nicks);

  sendto_one(source_p, form_str(RPL_ENDOFACCEPT),
             me.name, source_p->name);

}
