/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * m_invite.c: Invites the user to join a channel.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: m_invite.c,v 1.27.2.1 2004/05/25 07:31:42 musirc Exp $
 */

#include "handlers.h"
#include "channel.h"
#include "channel_mode.h"
#include "client.h"
#include "hash.h"
#include "istring.h"
#include "ircd.h"
#include "numeric.h"
#include "send.h"
#include "config.h"
#include "server.h"
#include "modules.h"
#include "packet.h"

static void m_invite(struct Client *, struct Client *, int, char **);
static void ms_invite(struct Client *, struct Client *, int, char **);

struct Message invite_msgtab = {
  "INVITE", 3, MFLG_SLOW,
  {m_unregistered, m_invite, ms_invite, m_invite}
};
#ifndef STATIC_MODULES

void
_modinit(void)
{
  mod_add_cmd(&invite_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&invite_msgtab);
}

const char *_version = "$Revision: 1.27.2.1 $";
#endif

/* parv[0] - sender prefix
 * parv[1] - user to invite
 * parv[2] - channel name
 */
static void
m_invite(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  struct Client *target_p;
  struct Channel *chptr;
  struct Membership *ms;

  if (!IsFloodDone(source_p))
    flood_endgrace(source_p);

  if ((target_p = find_person(parv[1])) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOSUCHNICK),
               me.name, source_p->name, parv[1]);
    return;
  }

  if (check_channel_name(parv[2]) == 0)
  {
    sendto_one(source_p, form_str(ERR_BADCHANNAME),
               me.name, source_p->name, parv[2]);
    return;
  }

  if (!IsChanPrefix(*parv[2]))
  {
    if (MyClient(source_p))
      sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
                 me.name, source_p->name, parv[2]);
    return;
  }

  /* Do not send local channel invites to users if they are not on the
   * same server as the person sending the INVITE message.
   * Possibly should be an error sent to source_p
   * done .. there should be no problem because MyConnect(source_p) should
   * always be true if parse() and such is working correctly --is
   */
  if (!MyConnect(target_p) && (parv[2][0] == '&'))
  {
    if (ConfigServerHide.hide_servers == 0)
      sendto_one(source_p, form_str(ERR_USERNOTONSERV),
                 me.name, source_p->name, parv[1]);
    return;
  }

  if ((chptr = hash_find_channel(parv[2])) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
               me.name, source_p->name, parv[2]);
    return;
  }

  /* By this point, chptr is non NULL */
  if ((ms = find_channel_link(source_p, chptr)) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOTONCHANNEL),
               me.name, source_p->name, parv[2]);
    return;
  }

  if (IsMember(target_p, chptr))
  {
    sendto_one(source_p, form_str(ERR_USERONCHANNEL),
               me.name, source_p->name, parv[1], parv[2]);
    return;
  }

  if (chptr->mode.mode & MODE_INVITEONLY)
  {
    if (!has_member_flags(ms, CHFL_CHANOP))
    {
      sendto_one(source_p, form_str(ERR_CHANOPRIVSNEEDED),
                 me.name, source_p->name, parv[2]);
      return;
    }
  }
  sendto_one(source_p, form_str(RPL_INVITING),
             me.name, source_p->name, target_p->name, parv[2]);

  if (target_p->user->away)
    sendto_one(source_p, form_str(RPL_AWAY),
               me.name, source_p->name, target_p->name,
               target_p->user->away);

  if (MyConnect(target_p))
    add_invite(chptr, target_p);

  sendto_anywhere(target_p, source_p, "INVITE %s :%s",
                  target_p->name, chptr->name);
}

/* parv[0] - sender prefix
 * parv[1] - user to invite
 * parv[2] - channel name
 */
static void
ms_invite(struct Client *client_p, struct Client *source_p,
          int parc, char *parv[])
{
  struct Client *target_p;
  struct Channel *chptr;

  if (parc < 3)
    return;

  if (*parv[2] == '\0')
    return;

  if ((target_p = find_person(parv[1])) == NULL)
    return;

  if(check_channel_name(parv[2]) == 0)
    return;

  if (!IsChanPrefix(*parv[2]))
    return;

  if ((chptr = hash_find_channel(parv[2])) == NULL)
    return;

  if (IsMember(target_p, chptr))
    return;

  if (MyConnect(target_p))
    if (chptr->mode.mode & MODE_INVITEONLY)
      add_invite(chptr, target_p);

  sendto_anywhere(target_p, source_p, "INVITE %s :%s",
                  target_p->name, chptr->name);
}
