/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * m_links.c: Shows what servers are currently connected.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: m_links.c,v 1.41.2.3 2004/06/10 02:25:23 musirc Exp $
 */
 
#include "handlers.h"
#include "ircd.h"
#include "istring.h"
#include "numeric.h"
#include "server.h"
#include "send.h"
#include "config.h"
#include "modules.h"

static void m_links(struct Client *, struct Client *, int, char **);
static void mo_links(struct Client *, struct Client *, int, char **);
static void mo_map(struct Client *, struct Client *, int, char **);
static void dump_map(struct Client *, struct Client *, char *);

struct Message links_msgtab = {
  "LINKS", 0, MFLG_SLOW,
  {m_unregistered, m_links, m_ignore, mo_links}
};
struct Message map_msgtab = {
  "MAP", 0, MFLG_SLOW,
  {m_unregistered, m_not_oper, m_ignore, mo_map}
};
#ifndef STATIC_MODULES

void
_modinit(void)
{
  mod_add_cmd(&links_msgtab);
  mod_add_cmd(&map_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&links_msgtab);
  mod_del_cmd(&map_msgtab);
}

const char *_version = "$Revision: 1.41.2.3 $";
#endif

static char buf[BUFSIZE];

/* parv[0] = sender prefix
 * parv[1] = server to query 
 * parv[2] = servername mask
 */
static void
m_links(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  static time_t last_used = 0;

  if (((last_used + ConfigFileEntry.pace_wait) > CurrentTime))
  {
    sendto_one(source_p,form_str(RPL_LOAD2HI),
               me.name, source_p->name);
    return;
  }
  else
    last_used = CurrentTime;

  if (!ConfigServerHide.flatten_links)
  {
    mo_links(client_p, source_p, parc, parv);
    return;
  }
  send_message_file(source_p, &ConfigFileEntry.linksfile);
    
 /* Print our own info so at least it looks like a normal links
  * then print out the file (which may or may not be empty)
  */
  sendto_one(source_p, form_str(RPL_LINKS),
	     me.name, source_p->name,
             me.name, me.name, 0, me.info);
  sendto_one(source_p, form_str(RPL_ENDOFLINKS),
	     me.name, source_p->name, "*");
}

static void
mo_links(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  const char *mask = "*";
  struct Client *target_p;
  char clean_mask[2 * HOSTLEN + 4];
  dlink_node *ptr;

  if (parc > 2) 
  {
    if (!ConfigFileEntry.disable_remote || IsOper(source_p))
    {
      if (hunt_server(client_p, source_p, ":%s LINKS %s :%s", 1, parc, parv)
          != HUNTED_ISME)
      return;
    }
    mask = parv[2];
  }
  else if (parc == 2)
    mask = parv[1];

  if (*mask)
    mask = collapse(clean_string(clean_mask, (const unsigned char*)mask, 2 * HOSTLEN));

  DLINK_FOREACH(ptr, global_serv_list.head)
  {
    target_p = ptr->data;

    if (*mask && !match(mask, target_p->name))
      continue;
    
    sendto_one(source_p, form_str(RPL_LINKS),
               me.name, source_p->name,
               target_p->name, target_p->servptr->name,
               target_p->hopcount, target_p->info[0] ?
	       target_p->info : "No description");
  }
  sendto_one(source_p, form_str(RPL_ENDOFLINKS),
             me.name, source_p->name,
             EmptyString(mask) ? "*" : mask);

  sendto_realops_flags(UMODE_SPY, L_ALL, "LINKS '%s' by %s (%s@%s)",
                       mask, source_p->name, source_p->username, source_p->host);
}

static void
mo_map(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  dump_map(client_p, &me, buf);
  sendto_realops_flags(UMODE_SPY, L_ALL, "MAP by %s (%s@%s)",
                       source_p->name, source_p->username, source_p->host);
}

static void
dump_map(struct Client *client_p, struct Client *root_p, char *pbuf)
{
  int cnt = 0, i = 0, len, users;
  dlink_node *ptr;
  struct Client *server_p;
        
  *pbuf= '\0';

  snprintf(pbuf, BUFSIZE, "[%d] ", root_p->hopcount);
  strncat(pbuf + 4, root_p->name, BUFSIZE - ((size_t)pbuf - (size_t)buf));
  len = strlen(buf);
  buf[len] = ' ';

  users = dlink_list_length(&root_p->serv->users);
  snprintf(buf + len, BUFSIZE - len, " [%d(%1.1f%%)]", users,
           100 * (float)users / (float)Count.total);
  
  sendto_one(client_p, form_str(RPL_MAP), me.name, client_p->name, buf);
        
  if (root_p->serv->servers.head)
  {
    cnt += dlink_list_length(&root_p->serv->servers);
    if (cnt)
    {
      if (pbuf > buf + 3)
      {
        pbuf[-2] = ' ';
        if (pbuf[-3] == '`')
          pbuf[-3] = ' ';
      }
    }
  }
  i = 1;
  DLINK_FOREACH(ptr, root_p->serv->servers.head)
  {
    server_p = ptr->data;
    *pbuf = ' ';
    if (i < cnt)
      *(pbuf + 1) = '|';
    else
      *(pbuf + 1) = '`';
      
    *(pbuf + 2) = '-';
    *(pbuf + 3) = ' ';
    dump_map(client_p, server_p, pbuf+4);
 
    i++;
  }
}
