/* Copyright (C) 2004 by MusIRCd Development.
 * $Id: m_manage.c,v 1.14.2.4 2004/07/22 20:31:25 musirc Exp $
 */

#include "stdinc.h"
#include "handlers.h"
#include "numeric.h"
#include "client.h"
#include "ircd.h"
#include "send.h"
#include "istring.h"
#include "sprintf.h"
#include "hash.h"
#include "server.h"
#include "modules.h"
#include "channel_mode.h"
#include "log.h"
#include "channel.h"
#include "jupe.h"
#include "packet.h"
#include "config.h"

#define SERVICES_SERVER "services.int"
#define AIM_SERVER "aim.int"
#define NICKSERV_NICK "NickServ"
#define AIM_NICK "AIM"
#define AIMOLD_NICK "AIMSERV"
#define CHANSERV_NICK "ChanServ"
#define MEMOSERV_NICK "MemoServ"
#define HELPSERV_NICK "HelpServ"
#define STATSERV_NICK "StatServ"
#define SEENSERV_NICK "SeenServ"
#define GLOBAL_NICK "Global"
#define OPERSERV_NICK "OperServ"

static void mo_ajoin(struct Client *, struct Client *, int, char **);
static void mo_fixinvite(struct Client *, struct Client *, int, char **);
static void mo_fixts(struct Client *, struct Client *, int, char **);
static void ms_fixts(struct Client *, struct Client *, int, char **);
static void m_svnick(struct Client *, struct Client *, int, char **);
static void mo_opme(struct Client *, struct Client *, int, char **);
static void m_nickserv(struct Client *, struct Client *, int, char **);
static void m_chanserv(struct Client *, struct Client *, int, char **);
static void m_memoserv(struct Client *, struct Client *, int, char **);
static void mo_operserv(struct Client *, struct Client *, int, char **);
static void m_helpserv(struct Client *, struct Client *, int, char **);
static void m_statserv(struct Client *, struct Client *, int, char **);
static void m_seenserv(struct Client *, struct Client *, int, char **);
static void mo_global(struct Client *, struct Client *, int, char **);
static void m_aim(struct Client *, struct Client *, int, char **);
static void m_aimold(struct Client *, struct Client *, int, char **);
static void send_service(struct Client *, const char *, const char *, int, char **);
static void send_aim(struct Client *, const char *, int, char **);
static int clean_nick_name(char *);
static int opless(struct Channel *, struct Client *);
static void mo_mkpasswd(struct Client *, struct Client *, int, char **);
static char *des(void);
static char *md5(void);
static char saltChars[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./";

struct Message ajoin_msgtab = {
  "AJOIN", 3, MFLG_SLOW,
  {m_unregistered, m_ignore, m_ignore, mo_ajoin}
};
struct Message fixinvite_msgtab = {
  "FIXINVITE", 2, MFLG_SLOW,
  {m_unregistered, m_not_oper, m_ignore, mo_fixinvite}
};
struct Message fixts_msgtab = {
  "FIXTS", 2, MFLG_SLOW,
  {m_unregistered, m_not_oper, ms_fixts, mo_fixts}
};
struct Message svnick_msgtab = {
  "SVSNICK", 3, MFLG_SLOW,
  {m_unregistered, m_svnick, m_svnick, m_svnick}
};
struct Message opme_msgtab = {
  "OPME", 2, MFLG_SLOW,
  {m_unregistered, m_ignore, m_ignore, mo_opme}
};
struct Message nickserv_msgtab = {
  "NICKSERV", 0, MFLG_SLOW,
  {m_unregistered, m_nickserv, m_ignore, m_nickserv}
};
struct Message chanserv_msgtab = {
  "CHANSERV", 0, MFLG_SLOW,
  {m_unregistered, m_chanserv, m_ignore, m_chanserv}
};
struct Message memoserv_msgtab = {
  "MEMOSERV", 0, MFLG_SLOW,
  {m_unregistered, m_memoserv, m_ignore, m_memoserv}
};
struct Message operserv_msgtab = {
  "OPERSERV", 0, MFLG_SLOW,
  {m_unregistered, m_not_oper, m_ignore, mo_operserv}
};
struct Message helpserv_msgtab = {
  "HELPSERV", 0, MFLG_SLOW,
  {m_unregistered, m_helpserv, m_ignore, m_helpserv}
};
struct Message statserv_msgtab = {
  "STATSERV", 0, MFLG_SLOW,
  {m_unregistered, m_statserv, m_ignore, m_statserv}
};
struct Message seenserv_msgtab = {
  "SEENSERV", 0, MFLG_SLOW,
  {m_unregistered, m_seenserv, m_ignore, m_seenserv}
};
struct Message global_msgtab = {
  "GLOBAL", 0, MFLG_SLOW,
  {m_unregistered, m_not_oper, m_ignore, mo_global}
};
struct Message aim_msgtab = {
  "AIM", 0, MFLG_SLOW,
  {m_unregistered, m_aim, m_ignore, m_aim}
};
struct Message aimold_msgtab = {
  "AIMSERV", 0, MFLG_SLOW,
  {m_unregistered, m_aimold, m_ignore, m_aimold}
};
struct Message mkpasswd_msgtab = {
  "MKPASSWD", 1, MFLG_SLOW,
  {m_ignore, m_not_oper, m_ignore, mo_mkpasswd}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&ajoin_msgtab);
  mod_add_cmd(&fixinvite_msgtab);
  mod_add_cmd(&fixts_msgtab);
  mod_add_cmd(&svnick_msgtab);
  mod_add_cmd(&opme_msgtab);
  mod_add_cmd(&nickserv_msgtab);
  mod_add_cmd(&chanserv_msgtab);
  mod_add_cmd(&memoserv_msgtab);
  mod_add_cmd(&operserv_msgtab);
  mod_add_cmd(&helpserv_msgtab);
  mod_add_cmd(&statserv_msgtab);
  mod_add_cmd(&seenserv_msgtab);
  mod_add_cmd(&global_msgtab);
  mod_add_cmd(&aim_msgtab);
  mod_add_cmd(&aimold_msgtab);
  mod_add_cmd(&mkpasswd_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&ajoin_msgtab);
  mod_del_cmd(&fixinvite_msgtab);
  mod_del_cmd(&fixts_msgtab);
  mod_del_cmd(&svnick_msgtab);
  mod_del_cmd(&opme_msgtab);
  mod_del_cmd(&nickserv_msgtab);
  mod_del_cmd(&chanserv_msgtab);
  mod_del_cmd(&memoserv_msgtab);
  mod_del_cmd(&operserv_msgtab);
  mod_del_cmd(&helpserv_msgtab);
  mod_del_cmd(&statserv_msgtab);
  mod_del_cmd(&seenserv_msgtab);
  mod_del_cmd(&global_msgtab);
  mod_del_cmd(&aim_msgtab);
  mod_del_cmd(&aimold_msgtab);
  mod_del_cmd(&mkpasswd_msgtab);
}
const char *_version = "$Revision: 1.14.2.4 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = channel
 * parv[2] = reason
 */
static void
mo_ajoin(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  struct Channel *chptr;
  char *name = parv[1], modeletter = '\0';
  int move_me = 1;
  unsigned int tmp_flags = 0;
  char reason[REALLEN+2];
  char src_host[NICKLEN + USERLEN + HOSTLEN + 6];
  char src_iphost[NICKLEN + USERLEN + HOSTLEN + 6];

  if (!IsAdmin(source_p))
  {
    sendto_one(source_p, form_str(ERR_NOPRIVILEGES),
               me.name, source_p->name);
    return;
  }
  switch (*name)
  {
    case '@': tmp_flags = CHFL_CHANOP;
              modeletter = 'o'; name++; break;
    case '%': tmp_flags = CHFL_HALFOP;
              modeletter = 'h'; name++; break;
    case '+': tmp_flags = CHFL_VOICE;
              modeletter = 'v'; name++; break;
    /* No special mode flags - Just add the user */
    case '#':
    case '&':
      tmp_flags = 0;
      move_me = 0;
      modeletter = '\0';
      break;
  }
  if ((chptr = hash_find_channel(name)) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
               me.name, source_p->name, name);
    return;
  }
  if(IsMember(source_p, chptr))
  {
    sendto_one(source_p, ":%s NOTICE %s :AJOIN: Already in %s",
               me.name, source_p->name, chptr->name);
    return;
  }

  strlcpy(reason, parv[2], sizeof(reason));

  if (ClosedChannel(chptr) || chptr->mode.limit || *chptr->mode.key)
  {
    ircsprintf(src_host,"%s!%s@%s", source_p->name, source_p->username,
               source_p->host);
    ircsprintf(src_iphost,"%s!%s@%s", source_p->name, source_p->username,
               source_p->localClient->sockhost);

    if (move_me == 1)
      name--;

    add_user_to_channel(chptr, source_p, tmp_flags);

    sendto_wallops_flags(UMODE_WALLOP, &me, "AJOIN %s by %s!%s@%s reason being: %s",
                         chptr->name, source_p->name, source_p->username,
                         source_p->host, parv[2]);
    sendto_server(NULL, NULL, ":%s WALLOPS :AJOIN %s by %s!%s@%s reason being: %s", me.name,
                  parv[1], source_p->name, source_p->username, source_p->host,
                  parv[2]);
    ilog(NOTICE, "AJOIN %s by %s!%s@%s reason being %s",
         parv[1], source_p->name, source_p->username,
         source_p->host, parv[2]);

    if (chptr->name[0] == '#')
    {
      sendto_server(client_p, chptr, ":%s SJOIN %lu %s + :%c%s", me.name,
                    (unsigned long)chptr->channelts,
                    chptr->name, (modeletter != '\0') ? *name : ' ',
                    source_p->name);
    }
    sendto_channel_local(ALL_MEMBERS, chptr, ":%s!%s@%s JOIN %s",
                         source_p->name, source_p->username,
                         source_p->host, chptr->name);
    if (modeletter != '\0')
      sendto_channel_local(ALL_MEMBERS, chptr, ":%s MODE %s +%c %s",
                           me.name, chptr->name, modeletter, source_p->name);

    if (chptr->topic != NULL)
    {
      sendto_one(source_p, form_str(RPL_TOPIC),
                 me.name, source_p->name, chptr->name,
                 chptr->topic);
      sendto_one(source_p, form_str(RPL_TOPICWHOTIME),
                 me.name, source_p->name, chptr->name,
                 chptr->topic_info, chptr->topic_time);
    }
    channel_member_names(source_p, chptr, 1, 0);
  }
  else
    sendto_one(source_p, ":%s NOTICE %s :AJOIN: %s is not closed, use regular /join %s",
               me.name, source_p->name, chptr->name, chptr->name);
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
mo_fixinvite(struct Client *client_p, struct Client *source_p,
             int parc, char *parv[])
{
  struct Channel *chptr;

  if ((chptr = hash_find_channel(parv[1])) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
               me.name, source_p->name, parv[1]);
    return;
  }
  if (!opless(chptr, source_p))
    return;

  if (!(chptr->mode.mode & MODE_INVITEONLY))
  {
    sendto_one(source_p, ":%s NOTICE %s :FIXINVITE: %s is not invite only",
               me.name, source_p->name, chptr->name);
    return;
  }
  if (parv[1][0] == '&')
    sendto_wallops_flags(UMODE_LOCOPS, &me, "FIXINVITE [%s] by %s!%s@%s",
                         chptr->name, source_p->name, source_p->username,
                         source_p->host);
  else
  {
    sendto_wallops_flags(UMODE_WALLOP, &me, "FIXINVITE [%s] by %s!%s@%s",
                         chptr->name, source_p->name, source_p->username,
                         source_p->host);
    sendto_server(NULL, NULL, ":%s WALLOPS :FIXINVITE [%s] by %s!%s@%s",
                  me.name, chptr->name, source_p->name, source_p->username,
                  source_p->host);
  }
  ilog(NOTICE, "FIXINVITE [%s] by %s!%s@%s",
       chptr->name, source_p->name, source_p->username,
       source_p->host);

  sendto_channel_local(ALL_MEMBERS, chptr, ":%s MODE %s -il",
                       me.name, chptr->name);
  sendto_server(NULL, chptr, ":%s MODE %s -il", me.name, chptr->name);
  chptr->mode.limit = 0;
  chptr->mode.mode &= ~MODE_INVITEONLY;
}

static int
opless(struct Channel *chptr, struct Client *source_p)
{
  dlink_node *ptr;

  DLINK_FOREACH(ptr, chptr->members.head)
  {
    if (((struct Membership *)ptr->data)->flags & CHFL_CHANOP)
    {
      sendto_one(source_p, ":%s NOTICE %s :*** %s Channel not opless",
                 me.name, source_p->name, chptr->name);
      return(0);
    }
  }
  return(1);
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
mo_fixts(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  struct Channel *chptr;
  int currentts = CurrentTime;

  if (!IsAdmin(source_p))
  {
    sendto_one(source_p, form_str(ERR_NOPRIVILEGES),
               me.name, source_p->name);
    return;
  }

  if ((chptr = hash_find_channel(parv[1])) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
               me.name, source_p->name, parv[1]);
    return;
  }

  if (parv[1][0] == '&')
  {
    sendto_wallops_flags(UMODE_LOCOPS, &me,
                         "FIXTS [%s] by %s!%s@%s",
                         chptr->name, source_p->name, source_p->username,
                         source_p->host);
  }
  else
  {
    sendto_wallops_flags(UMODE_WALLOP, &me,
                         "FIXTS [%s] by %s!%s@%s",
                         chptr->name, source_p->name, source_p->username,
                         source_p->host);
    sendto_server(NULL, NULL, ":%s WALLOPS :FIXTS [%s] by %s!%s@%s",
                  me.name, chptr->name, source_p->name, source_p->username,
                  source_p->host);
  }
  ilog(NOTICE, "FIXTS [%s] by %s!%s@%s",
       chptr->name, source_p->name, source_p->username,
       source_p->host);

  if (chptr->channelts == 0)
  {
    chptr->channelts = currentts;
    sendto_channel_local(ALL_MEMBERS, chptr,
                         ":%s NOTICE %s :*** TS for %s changed from 0 to %lu",
                         me.name, chptr->name, chptr->name, (unsigned long)currentts);
    sendto_realops_flags(UMODE_ALL, L_ALL,
                         "%s changing TS on %s from 0 to %lu",
                         source_p->name, chptr->name, (unsigned long)currentts);
    sendto_server(NULL, NULL, ":%s FIXTS %s", source_p->name, chptr->name);
  }
  else
    sendto_one(source_p, ":%s NOTICE %s :*** %s does not have a TS of 0",
               me.name, source_p->name, chptr->name);
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
ms_fixts(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  struct Channel *chptr;
  int currentts = CurrentTime;

  if (parc != 2)
    return;

  if ((chptr = hash_find_channel(parv[1])) == NULL)
    return;

  if (chptr->channelts == 0)
  {
    chptr->channelts = currentts;
    sendto_channel_local(ALL_MEMBERS, chptr,
                         ":%s NOTICE %s :*** TS for %s changed from 0 to %lu",
                         me.name, chptr->name, chptr->name, (unsigned long)currentts);
    sendto_realops_flags(UMODE_ALL, L_ALL,
                         "%s changing TS on %s from 0 to %lu",
                         source_p->name, chptr->name, (unsigned long)currentts);
  }
}

/* parv[0] = sender prefix
 * parv[1] = oldnick
 * parv[2] = newnick
 */
static void
m_svnick(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  char oldnick[NICKLEN];
  char newnick[NICKLEN];
  struct Client *oldnickname;
  struct Client *newnickname;

  if (!IsServer(source_p) || !IsService(source_p))
    return;

  if(parc < 3 || EmptyString(parv[1]) || EmptyString(parv[2]))
    return;

  strlcpy(oldnick, parv[1], sizeof(oldnick));
  strlcpy(newnick, parv[2], sizeof(newnick));

  if (!(oldnickname = (find_client(oldnick))))
    return;

  if (!clean_nick_name(oldnick) || !clean_nick_name(newnick))
    return;

  if (find_matching_name_conf(NJUPE_TYPE, newnick, NULL, NULL, 0) &&
     !(IsOper(source_p) && ConfigFileEntry.oper_pass_jupes))
    return;

  if ((newnickname = (find_client(newnick))))
    return;

  if (MyConnect(oldnickname))
  {
    if (!IsFloodDone(oldnickname))
      flood_endgrace(oldnickname);

    if ((newnickname = find_client(oldnick)))
    {
      if(newnickname == oldnickname)
      {
        /* check the nick isnt exactly the same */
        if(strcmp(oldnickname->name, newnick))
        {
          change_local_nick(oldnickname->servptr, oldnickname, newnick);
          return;
        }
        else
        {
          return;
        }
      }
      if(IsUnknown(newnickname))
      {
        exit_client(NULL, newnickname, &me, "Nick Collision");
        change_local_nick(oldnickname->servptr, oldnickname, newnick);
        return;
      }
      else
      {
        return;
      }
    }
    else
    {
      change_local_nick(oldnickname->servptr, oldnickname, newnick);
      return;
    }
  }
  else
  {
    sendto_server(client_p, NULL, ":%s SVSNICK %s :%s", me.name, oldnick, newnick);
  }
}

static int
clean_nick_name(char *nick)
{
  if(nick == NULL)
    return 0;

  if (*nick == '-' || IsDigit(*nick) || *nick == '\0')
    return 0;

  for(; *nick; nick++)
    if(!IsNickChar(*nick))
      return 0;

  return 1;
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
mo_opme(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  struct Channel *chptr;
  struct Membership *member;

  if ((chptr = hash_find_channel(parv[1])) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
               me.name, source_p->name, parv[1]);
    return;
  }

  if ((member = find_channel_link(source_p, chptr)) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOTONCHANNEL),
               me.name, source_p->name, chptr->name);
    return;
  }

  if (!opless(chptr, source_p))
    return;

  AddMemberFlag(member, CHFL_CHANOP);

  if (parv[1][0] == '&')
  {
    sendto_wallops_flags(UMODE_LOCOPS, &me,
                         "OPME [%s] by %s!%s@%s",
                         chptr->name, source_p->name, source_p->username,
                         source_p->host);
  }
  else
  {
    sendto_wallops_flags(UMODE_WALLOP, &me,
                         "OPME [%s] by %s!%s@%s",
                         chptr->name, source_p->name, source_p->username,
                         source_p->host);
    sendto_server(NULL, NULL, ":%s WALLOPS :OPME [%s] by %s!%s@%s",
                  me.name, chptr->name, source_p->name, source_p->username,
                  source_p->host);
  }
  ilog(NOTICE, "OPME [%s] by %s!%s@%s",
       chptr->name, source_p->name, source_p->username,
       source_p->host);

   sendto_server(NULL, chptr, ":%s MODE %s +o %s", me.name, chptr->name,
                 source_p->name);
   sendto_channel_local(ALL_MEMBERS, chptr, ":%s MODE %s +o %s",
                        me.name, chptr->name, source_p->name);

}

static void
send_service(struct Client *source_p, const char *nick, const char *command, int parc, char *parv[])
{
  dlink_node *next;
  dlink_node *ptr;
  struct Client *serv = find_server(SERVICES_SERVER), *target_p;

  if (!ConfigFileEntry.use_services)
  {
    sendto_one(source_p, ":%s NOTICE %s :*** There are no services on this network.",
               me.name, source_p->name);
    return;
  }
  if (parc < 1)
  {
    sendto_one(source_p, form_str(ERR_NEEDMOREPARAMS),
               me.name, source_p->name, command);
    return;
  }
  if (serv == NULL || serv == &me)
  {
    sendto_one(source_p, form_str(ERR_SERVICESDOWN), me.name, source_p->name);
    return;
  }

  DLINK_FOREACH_SAFE(ptr, next, serv->serv->users.head)
  {
    target_p = ptr->data;
    if (!irccmp(target_p->name, nick))
    {
      char buffer[BUFSIZE - 1];

      buffer[0] = '\0';
      while(parc != 0)
      {
        strlcat(buffer, parv[0], BUFSIZE - 2);
        parc--;
        parv++;
        if (parc == 0)
          break;
        strlcat(buffer, " ", BUFSIZE - 2);
      }
      sendto_one(target_p, ":%s PRIVMSG %s :%s", source_p->name, target_p->name, buffer);
      return;
    }
  }
  sendto_one(source_p, form_str(ERR_SERVICESDOWN), me.name, source_p->name);
}

static void
send_aim(struct Client *source_p, const char *nick, int parc, char *parv[])
{
  dlink_node *next;
  dlink_node *ptr;
  struct Client *serv = find_server(AIM_SERVER), *target_p;

  if (serv == NULL || serv == &me)
  {
    sendto_one(source_p, form_str(ERR_SERVICESDOWN), me.name, source_p->name);
    return;
  }

  if (parc < 1)
  {
    sendto_one(source_p, form_str(ERR_NEEDMOREPARAMS),
               me.name, source_p->name, "AIM");
    return;
  }

  DLINK_FOREACH_SAFE(ptr, next, serv->serv->users.head)
  {
    target_p = ptr->data;
    if (!irccmp(target_p->name, nick))
    {
      char buffer[BUFSIZE - 1];

      buffer[0] = '\0';
      while(parc != 0)
      {
        strlcat(buffer, parv[0], BUFSIZE - 2);
        parc--;
        parv++;
        if (parc == 0)
          break;
        strlcat(buffer, " ", BUFSIZE - 2);
      }
      sendto_one(target_p, ":%s PRIVMSG %s :%s", source_p->name, target_p->name, buffer);
      return;
    }
  }
  sendto_one(source_p, form_str(ERR_SERVICESDOWN), me.name, source_p->name);
}

static void
m_nickserv(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  send_service(source_p, NICKSERV_NICK, "NICKSERV", parc - 1, parv + 1);
}

static void
m_chanserv(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  send_service(source_p, CHANSERV_NICK, "CHANSERV", parc - 1, parv + 1);
}

static void
m_memoserv(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  send_service(source_p, MEMOSERV_NICK, "MEMOSERV", parc - 1, parv + 1);
}

static void
mo_operserv(struct Client *client_p, struct Client *source_p,
            int parc, char *parv[])
{
  send_service(source_p, OPERSERV_NICK, "OPERSERV", parc - 1, parv + 1);
}

static void
m_helpserv(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  send_service(source_p, HELPSERV_NICK, "HELPSERV", parc - 1, parv + 1);
}

static void
m_statserv(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  send_service(source_p, STATSERV_NICK, "STATSERV", parc - 1, parv + 1);
}

static void
m_seenserv(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  send_service(source_p, SEENSERV_NICK, "SEENSERV", parc - 1, parv + 1);
}

static void
mo_global(struct Client *client_p, struct Client *source_p,
          int parc, char *parv[])
{
  send_service(source_p, GLOBAL_NICK, "GLOBAL", parc - 1, parv + 1);
}
static void
m_aim(struct Client *client_p, struct Client *source_p,
      int parc, char *parv[])
{
  send_aim(source_p, AIM_NICK, parc - 1, parv + 1);
}
static void
m_aimold(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  send_aim(source_p, AIMOLD_NICK, parc - 1, parv + 1);
}

static void
mo_mkpasswd(struct Client *client_p, struct Client *source_p,
            int parc, char *parv[])
{
  if (parv[2] == NULL)
    sendto_one(source_p, ":%s NOTICE %s :*** DES Encryption for [%s]: %s",
               me.name, source_p->name, parv[1], crypt(parv[1],
               des()));
  else if (!irccmp(parv[2], "DES"))
    sendto_one(source_p, ":%s NOTICE %s :*** DES Encryption for [%s]: %s",
               me.name, source_p->name, parv[1], crypt(parv[1],
               des()));
  else if (!irccmp(parv[2], "MD5"))
    sendto_one(source_p, ":%s NOTICE %s :*** MD5 Encryption for [%s]: %s",
               me.name, source_p->name, parv[1], crypt(parv[1],
               md5()));
  else
    sendto_one(source_p, ":%s NOTICE %s :MKPASSWD: Syntax: MKPASSWD pass [DES|MD5]",
               me.name, source_p->name);
}

static char
*des(void)
{
  static char salt[3];
  salt[0] = saltChars[random() % 64];
  salt[1] = saltChars[random() % 64];
  salt[2] = '\0';
  return(salt);
}

static char
*md5(void)
{
  static char salt[13];
  int i;
  salt[0] = '$';
  salt[1] = '1';
  salt[2] = '$';
  for (i=3; i<11; i++)
    salt[i] = saltChars[random() % 64];
  salt[11] = '$';
  salt[12] = '\0';
  return(salt);
}
