/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * m_ping.c: Requests that a PONG message be sent back.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: m_ping.c,v 1.44.2.1 2004/04/09 04:17:23 musirc Exp $
 */

#include "handlers.h"
#include "client.h"
#include "ircd.h"
#include "numeric.h"
#include "send.h"
#include "istring.h"
#include "modules.h"
#include "hash.h"
#include "config.h"
#include "server.h"
#include "user.h"

static void m_ping(struct Client *, struct Client *, int, char **);
static void ms_ping(struct Client *, struct Client *, int, char **);
static void mr_pong(struct Client *, struct Client *, int, char **);
static void ms_pong(struct Client *, struct Client *, int, char **);
static void mr_proxy(struct Client *, struct Client *, int, char **);

struct Message ping_msgtab = {
  "PING", 1, MFLG_SLOW,
  {m_unregistered, m_ping, ms_ping, m_ping}
};
struct Message pong_msgtab = {
  "PONG", 1, MFLG_SLOW | MFLG_UNREG,
  {mr_pong, m_ignore, ms_pong, m_ignore}
};
struct Message post_msgtab = {
  "POST", 0, MFLG_SLOW | MFLG_UNREG,
  {mr_proxy, m_ignore, m_ignore, m_ignore}
};
struct Message get_msgtab = {
  "GET", 0, MFLG_SLOW | MFLG_UNREG,
  {mr_proxy, m_ignore, m_ignore, m_ignore}
};
struct Message put_msgtab = {
  "PUT", 0, MFLG_SLOW | MFLG_UNREG,
  {mr_proxy, m_ignore, m_ignore, m_ignore}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&ping_msgtab);
  mod_add_cmd(&pong_msgtab);
  mod_add_cmd(&post_msgtab);
  mod_add_cmd(&get_msgtab);
  mod_add_cmd(&put_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&ping_msgtab);
  mod_del_cmd(&pong_msgtab);
  mod_del_cmd(&post_msgtab);
  mod_del_cmd(&get_msgtab);
  mod_del_cmd(&put_msgtab);
}

const char *_version = "$Revision: 1.44.2.1 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = origin
 * parv[2] = destination
 */
static void
m_ping(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  struct Client *target_p;
  char *origin, *destination;

  if (parc < 2 || *parv[1] == '\0')
  {
    sendto_one(source_p, form_str(ERR_NOORIGIN), me.name, source_p->name);
    return;
  }

  origin = parv[1];
  destination = parv[2]; /* Will get NULL or pointer (parc >= 2!!) */

  if (ConfigFileEntry.disable_remote && !IsOper(source_p))
  {
   sendto_one(source_p,":%s PONG %s :%s", me.name,
              (destination) ? destination : me.name, origin);
   return;
  }

  if (!EmptyString(destination) && irccmp(destination, me.name) != 0)
  {
    /* We're sending it across servers.. origin == client_p->name --fl_ */
    origin = client_p->name;

    if ((target_p = find_server(destination)) != NULL)
    {
      sendto_one(target_p,":%s PING %s :%s", source_p->name,
                 origin, destination);
    }
    else
    {
      sendto_one(source_p, form_str(ERR_NOSUCHSERVER),
                 me.name, source_p->name, destination);
      return;
    }
  }
  else
    sendto_one(source_p,":%s PONG %s :%s", source_p->name,
               (destination) ? destination : me.name, origin);
}

static void
ms_ping(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  struct Client *target_p;
  const char *origin, *destination;

  if (parc < 2)
  {
    sendto_one(source_p, form_str(ERR_NOORIGIN), me.name, source_p->name);
    return;
  }
  origin = source_p->name;
  destination = parv[2]; /* Will get NULL or pointer (parc >= 2!!) */

  if (!EmptyString(destination) && irccmp(destination, me.name) != 0)
  {
    if ((target_p = find_server(destination)))
      sendto_one(target_p,":%s PING %s :%s", source_p->name,
                 origin, destination);
    else
    {
      sendto_one(source_p, form_str(ERR_NOSUCHSERVER),
                 me.name, source_p->name, destination);
      return;
    }
  }
  else
    sendto_one(source_p,":%s PONG %s :%s", me.name,
               (destination) ? destination : me.name, origin);
}

static void
ms_pong(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  struct Client *target_p;
  const char *origin, *destination;

  if (parc < 2)
  {
    sendto_one(source_p, form_str(ERR_NOORIGIN),
               me.name, source_p->name);
    return;
  }

  origin = parv[1];
  destination = parv[2];

  /* Now attempt to route the PONG, comstud pointed out routable PING
   * is used for SPING.  routable PING should also probably be left in
   *        -Dianora
   * That being the case, we will route, but only for registered clients (a
   * case can be made to allow them only from servers). -Shadowfax
   */
  if (!EmptyString(destination) && !match(destination, me.name))
  {
    if ((target_p = find_client(destination)) ||
        (target_p = find_server(destination)))
      sendto_one(target_p,":%s PONG %s %s",
                 source_p->name, origin, destination);
    else
    {
      sendto_one(source_p, form_str(ERR_NOSUCHSERVER),
                 me.name, source_p->name, destination);
      return;
    }
  }
}

static void
mr_pong(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  if (parc >= 2)
  {
    unsigned long incoming_ping = strtoul(parv[1], NULL, 16);

    if (incoming_ping)
    {
      if(source_p->localClient->random_ping == incoming_ping)
      {
	char buf[USERLEN+1];
	strlcpy(buf, source_p->username, sizeof(buf));
	register_local_user(client_p, source_p, source_p->name, buf);
      }
      else
      {
        sendto_one(source_p, form_str(ERR_WRONGPONG), me.name,
		   source_p->name, source_p->localClient->random_ping);
	return;
      }
    }
  }
  else
    sendto_one(source_p, form_str(ERR_NOORIGIN), me.name, source_p->name);
}

/* parv[0] = sender prefix
 * parv[1] = comment
 */
static void
mr_proxy(struct Client *client_p, struct Client *source_p,
	      int parc, char *parv[])
{
  exit_client(client_p, source_p, source_p, "Unauthorized Connection");
}
