/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * list.c: Various assorted functions for various structures.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: list.c,v 1.33 2004/02/08 06:46:05 musirc Exp $
 */

#include "client.h"
#include "list.h"
#include "balloc.h"
#include "memory.h"

static int32_t dlinks_count = 0;
static BlockHeap *dnode_heap, *snode_heap;

/* inputs	- pointer to client struct
 * output	- pointer to struct Server
 * side effects - add's an Server information block to a client
 *                if it was not previously allocated.
 */
struct Server *
make_server(struct Client *client_p)
{
  struct Server *serv = client_p->serv;

  if (!serv)
  {
    serv = MyMalloc(sizeof(struct Server));
    client_p->serv = serv;
  }
  return(client_p->serv);
}

/* side effects - initializes the dnode BlockHeap */
void
init_dlink_nodes(void)
{
  dnode_heap = BlockHeapCreate(sizeof(dlink_node), DNODE_HEAP_SIZE);
}
 
/* make_dlink_node()
 * output	- pointer to new dlink_node
 */
dlink_node *
make_dlink_node(void)
{
  dlink_node *lp = BlockHeapAlloc(dnode_heap);

  ++dlinks_count;

  lp->next = NULL;
  lp->prev = NULL;
  return(lp);
}

/* inputs	- pointer to dlink_node
 * side effects	- free given dlink_node 
 */
void 
free_dlink_node(dlink_node *ptr)
{
  BlockHeapFree(dnode_heap, ptr);
  --dlinks_count;
}

/* side effects - initializes the snode BlockHeap */
void
init_slink_nodes(void)
{
  snode_heap = BlockHeapCreate(sizeof(slink_node), SNODE_HEAP_SIZE);
}
