/* MusIRCd: an advanced Internet Relay Chat Daemon(ircd).
 * tools.c: Various functions needed here and there.
 * Copyright (C) 2004 by MusIRCd Development.
 * $Id: tools.c,v 1.15 2004/01/18 06:03:55 musirc Exp $
 */

#include "tools.h"

void
dlinkAdd(void *data, dlink_node *m, dlink_list *list)
{
 m->data = data;
 m->prev = NULL;
 m->next = list->head;

 /* Assumption: If list->tail != NULL, list->head != NULL */
 if (list->head != NULL)
   list->head->prev = m;
 else
   list->tail = m;

 list->head = m;
 list->length++;
}

void
dlinkAddBefore(dlink_node *b, void *data, dlink_node *m, dlink_list *list)
{
    /* Shortcut - if its the first one, call dlinkAdd only */
    if (b == list->head)
    {
      dlinkAdd(data, m, list);
    }
    else
    {
      m->data = data;
      b->prev->next = m;
      m->prev = b->prev;
      b->prev = m; 
      m->next = b;
      list->length++;
    }
}

void
dlinkAddTail(void *data, dlink_node *m, dlink_list *list)
{
  m->data = data;
  m->next = NULL;
  m->prev = list->tail;
  /* Assumption: If list->tail != NULL, list->head != NULL */
  if (list->tail != NULL)
    list->tail->next = m;
  else /* if (list->head == NULL) */
    list->head = m;
 
  list->tail = m;
  list->length++;
}

void
dlinkDelete(dlink_node *m, dlink_list *list)
{
 /* Assumption: If m->next == NULL, then list->tail == m
  *      and:   If m->prev == NULL, then list->head == m
  */
  if (m->next)
    m->next->prev = m->prev;
  else
  {
    list->tail = m->prev;
  }
  if (m->prev)
    m->prev->next = m->next;
  else
  {
    list->head = m->next;
  }

  /* Set this to NULL does matter */
  m->next = m->prev = NULL;
  list->length--;
}

/* inputs	- list to search 
 *		- data
 * output	- pointer to link or NULL if not found
 * side effects	- Look for ptr in the linked listed pointed to by link.
 */
dlink_node *
dlinkFind(dlink_list *list, void *data)
{
  dlink_node *ptr;

  DLINK_FOREACH(ptr, list->head)
  {
    if (ptr->data == data)
      return(ptr);
  }
  return(NULL);
}

void
dlinkMoveList(dlink_list *from, dlink_list *to)
{
  if(from->head == NULL)
    return;

  if(to->head == NULL)
  {
    to->head = from->head;
    to->tail = from->tail;
    from->head = from->tail = NULL;
    to->length = from->length;
    from->length = 0;
    return;
  }

  from->tail->next = to->head;
  from->head->prev = to->head->prev;
  to->head->prev = from->tail;
  to->head = from->head;
  from->head = from->tail = NULL;
  to->length += from->length;
  from->length = 0;
}

dlink_node *
dlinkFindDelete(dlink_list *list, void *data)
{
  dlink_node *m;

  DLINK_FOREACH(m, list->head)
  {
    if (m->data == data)
    {
      if (m->next)
        m->next->prev = m->prev;
      else
      {
        list->tail = m->prev;
      }
      if (m->prev)
        m->prev->next = m->next;
      else
      {
        list->head = m->next;
      }
      /* Set this to NULL does matter */
      m->next = m->prev = NULL;
      list->length--;

      return(m);
    }
  }
  return(NULL);
}

void
slink_add(void *data, slink_node *node, slink_list *list)
{
    if(list->head == NULL)
    {
        list->head = node;
        node->next = NULL;
    }
    else
    {
        node->next = list->head->next;
        list->head = node;
    }

    node->data = data;
    list->length++;
}

void
slink_delete(slink_node *node, slink_list *list)
{
    slink_node *ptr;

    if(list->head == NULL)
        return;

    if(list->head->next == NULL)
        list->head = NULL;
    else
    {
        SLINK_FOREACH(ptr, list->head)
        {
            if(ptr->next == node)
            {
                ptr->next = node->next;
                break;
            }
        }
    }
    list->length--;
}

slink_node*
slink_find(slink_list *list, void *data)
{
    slink_node *ptr;

    SLINK_FOREACH(ptr, list->head)
    {
        if(ptr->data == data)
            return ptr;
    }
    return NULL;
}
