#!/bin/sh
# $Id: version.c.SH,v 1.387.2.48 2004/08/03 06:02:34 musirc Exp $ 

spitshell=cat
if test -r version.c.last
then
   generation=`sed -n 's/^const char \*generation = \"\(.*\)\";/\1/p' < version.c.last`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

uname=`uname -a | sed -e 's/\"/\\\"/g'`

creation=`date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

$spitshell >version.c <<!SUB!THIS!
/* IRC - Internet Relay Chat, src/version.c
 * Copyright (C) 1990 Chelsea Ashley Dyerman
 */
const char *generation = "$generation", *creation = "$creation", *platform = "$uname",
           *ircd_version = "MusIRCd-2.0", *infotext[] =
{
  "MusIRCd is based on ircd-hybrid-7 Release:8/02/2004 Revision:0",
  "Copyright (c) 1996-2001 Hybrid Development Team", 
  "Copyright (c) 2001-2004 MusIRCd Development Team",
  "",
!SUB!THIS!

IFS='
'
for i in `grep -v '^$[I]d' info.c |tr -d '"'` ; do
echo "  \"$i\"," >> version.c
done
$spitshell >>version.c <<!SUB!THISTOO!
  "", 0,
};
!SUB!THISTOO!
