/* balloc.h: The ircd block allocator header.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: balloc.h,v 1.17 2005/01/27 11:48:00 musirc Exp $
 */

#ifndef INCLUDED_balloc_h
#define INCLUDED_balloc_h
#include "tools.h"
#include "memory.h"

/* Block contains status information for an allocated block in our
 * heap.
 */
struct Block {
  int freeElems;
  size_t alloc_size;
  struct Block *next;
  void *elems;
  dlink_list free_list;
  dlink_list used_list;
};

typedef struct Block Block;

struct MemBlock {
  dlink_node self;		
  Block *block;				/* Which block we belong to */
};
typedef struct MemBlock MemBlock;

/* BlockHeap contains the information for the root node of the
 * memory heap.
 */
struct BlockHeap {
  size_t elemSize;                    /* Size of each element to be stored */
  int elemsPerBlock;               /* Number of elements per block */
  int blocksAllocated;             /* Number of blocks allocated */
  int freeElems;                   /* Number of free elements */
  Block *base;                        /* Pointer to first block */
  struct BlockHeap *next;              /* Pointer to next heap */
};

typedef struct BlockHeap BlockHeap;

extern int BlockHeapFree(BlockHeap *, void *);
extern void *BlockHeapAlloc(BlockHeap *);
extern BlockHeap* BlockHeapCreate(size_t, int);
extern int BlockHeapDestroy(BlockHeap *);
extern void initBlockHeap(void);
#endif
