/* bsd.h: A header for the network subsystem.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: bsd.h,v 1.11 2005/01/27 11:48:00 musirc Exp $
 */

#ifndef INCLUDED_bsd_h
#define INCLUDED_bsd_h

#include "fdlist.h"

/* Size of a read buffer */
#define READBUF_SIZE    16384   /* used by src/packet.c and src/server.c */

/* Type of IO */
#define	COMM_SELECT_READ 1
#define	COMM_SELECT_WRITE 2

struct Client;
struct AccessItem;
struct DNSReply;
struct Listener;

extern const char* const NONB_ERROR_MSG; 
extern const char* const SETBUF_ERROR_MSG;

extern void add_connection(struct Listener*, int);
extern void close_connection(struct Client*);
extern void close_all_connections(void);
extern int connect_server(struct AccessItem*, struct Client*, struct DNSReply*);
extern void report_error(int, const char*, const char*, int);
extern int set_non_blocking(int);
extern int set_sock_buffers(int, int);
extern void set_no_delay(int);
extern int get_sockerr(void);
extern int ignoreErrno(int);
extern void comm_settimeout(int, time_t, PF *, void *);
extern void comm_setflush(int, time_t, PF *, void *);
extern void comm_checktimeouts(void *);
extern void comm_connect_tcp(int, const char *, u_short,
           		     struct sockaddr *, int, CNCB *, void *, int, int);
extern const char *comm_errstr(int);
extern int comm_open(int, int, int, const char *);
extern int comm_accept(int, struct irc_ssaddr *);
/* These must be defined in the network IO loop code of your choice */
extern void comm_setselect(int, fdlist_t, unsigned int,
           	           PF *, void *, time_t);
extern void init_netio(void);
extern int read_message(time_t, unsigned char);
extern void comm_select(unsigned long);
extern void check_can_use_v6(void);

#ifdef IPV6
extern void remove_ipv6_mapping(struct irc_ssaddr *);
#endif

#ifdef USE_SIGIO
void do_sigio(int);
void setup_sigio_fd(int);
#endif

#endif
