/* dbuf.h: A header for the dynamic buffers functions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: dbuf.h,v 1.12 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef __DBUF_H_INCLUDED
#define __DBUF_H_INCLUDED
#include "tools.h"

#define DBUF_BLOCK_SIZE 1024  /* this is also our MTU used for sending */

struct dbuf_block
{
  size_t size;
  char data[DBUF_BLOCK_SIZE];
};

struct dbuf_queue
{
  dlink_list blocks;
  size_t total_size;
};

extern void dbuf_init(void);
extern void dbuf_put(struct dbuf_queue *, char *, size_t);
extern void dbuf_delete(struct dbuf_queue *, size_t);
#define dbuf_length(x) ((x)->total_size)
#define dbuf_clear(x) dbuf_delete(x, dbuf_length(x))
#endif
