/* defs.h: A header for ircd global definitions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: defs.h,v 1.4 2005/01/27 11:48:01 musirc Exp $
 */

/* defs.h - Global size definitions for record entries used
 * througout ircd. Please think 3 times before adding anything to this
 * file.
 */
#ifndef INCLUDED_defs_h
#define INCLUDED_defs_h
#include "inet_misc.h"

#define HOSTLEN         63      /* Length of hostname.  Updated to
                                   comply with RFC1123                     */

#define PORTNAMELEN 6  /* ":31337" */

#define USERLEN         10
#define REALLEN         50
#define KILLLEN         90      
#define CHANNELLEN      100
#define REASONLEN	120

/* 23+1 for \0 */
#define KEYLEN          24
#define BUFSIZE         512     /* WARNING: *DONT* CHANGE THIS!!!! */
#define OPERNICKLEN     NICKLEN*2 /* Length of OPERNICKs. */
#define USERHOST_REPLYLEN       (NICKLEN+HOSTLEN+USERLEN+5)
#define MAX_DATE_STRING 32      /* maximum string length for a date string */
#define IRCD_MAXNS    2    /* Maximum number of nameservers in
	                  /etc/resolv.conf we care about */
#define LOWEST_SAFE_FD  4    /* skip stdin, stdout, stderr, and profiler */

/* message return values */
#define CLIENT_EXITED    -2

/* This is to get around the fact that some implementations have ss_len and
 * others do not
 */
struct irc_ssaddr
{
  struct sockaddr_storage ss;
  unsigned char ss_len;  
  in_port_t ss_port;
};
#endif
