/* event.h: The ircd event header.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: event.h,v 1.11 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_event_h
#define INCLUDED_event_h

#define	MAX_EVENTS 50

typedef void EVH(void *);

/* The list of event processes */
struct ev_entry
{
  EVH *func;
  void *arg;
  const char *name;
  time_t frequency;
  time_t when;
  int active;
};

extern void eventAdd(const char *, EVH *, void *, time_t);
extern void eventAddIsh(const char *, EVH *, void *, time_t);
extern void eventRun(void);
extern time_t eventNextTime(void);
extern void eventInit(void);
extern void eventDelete(EVH *func, void *);
extern void set_back_events(time_t);
#endif
